/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import jd.utils.JDUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appwork.utils.Application;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.limewire.util.CommonUtils;

public final class AzureusStarter {
    private static final Log LOG = LogFactory.getLog(AzureusStarter.class);
    private static AzureusCore AZUREUS_CORE;

    public static final void start() {
        AzureusStarter.azureusInit();
    }

    public static AzureusCore getAzureusCore() {
        if (AzureusStarter.isAzureusCoreStarted()) {
            return AZUREUS_CORE;
        }
        AzureusStarter.azureusInit();
        return AZUREUS_CORE;
    }

    public static boolean isAzureusCoreStarted() {
        return AZUREUS_CORE != null && AZUREUS_CORE.isStarted();
    }

    private static synchronized void azureusInit() {
        try {
            if (AzureusStarter.isAzureusCoreStarted()) {
                LOG.debug("azureusInit(): core already started. skipping.");
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Application.setApplication(CommonUtils.getUserSettingsDir().getAbsolutePath() + File.separator + "appwork" + File.separator);
        File file = new File(CommonUtils.getUserSettingsDir().getAbsolutePath() + File.separator + "jd_home" + File.separator);
        if (!file.exists()) {
            file.mkdir();
        }
        JDUtilities.setJDHomeDirectory(file);
        JDUtilities.getConfiguration().setProperty("DOWNLOAD_DIRECTORY", SharingSettings.TORRENT_DATA_DIR_SETTING.getValue().getAbsolutePath());
        File file2 = new File(CommonUtils.getUserSettingsDir() + File.separator + "azureus" + File.separator);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        System.setProperty("azureus.loadplugins", "0");
        System.setProperty("azureus.config.path", file2.getAbsolutePath());
        System.setProperty("azureus.install.path", file2.getAbsolutePath());
        if (!AzureusCoreFactory.isCoreAvailable()) {
            block12: {
                SystemProperties.APPLICATION_NAME = "azureus";
                SystemProperties.setUserPath(file2.getAbsolutePath());
                if (!SharingSettings.TORRENTS_DIR_SETTING.getValue().exists()) {
                    SharingSettings.TORRENTS_DIR_SETTING.getValue().mkdirs();
                }
                COConfigurationManager.setParameter("Auto Adjust Transfer Defaults", false);
                COConfigurationManager.setParameter("General_sDefaultTorrent_Directory", SharingSettings.TORRENTS_DIR_SETTING.getValue().getAbsolutePath());
                try {
                    AZUREUS_CORE = AzureusCoreFactory.create();
                }
                catch (AzureusCoreException azureusCoreException) {
                    if (AZUREUS_CORE != null) break block12;
                    AZUREUS_CORE = AzureusCoreFactory.getSingleton();
                }
            }
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            AZUREUS_CORE.addLifecycleListener(new AzureusCoreLifecycleListener(){

                @Override
                public boolean syncInvokeRequired() {
                    return false;
                }

                @Override
                public void stopping(AzureusCore azureusCore) {
                    azureusCore.getGlobalManager().pauseDownloads();
                }

                @Override
                public void stopped(AzureusCore azureusCore) {
                }

                @Override
                public boolean stopRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                @Override
                public void started(AzureusCore azureusCore) {
                    countDownLatch.countDown();
                }

                @Override
                public boolean restartRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                @Override
                public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                    return false;
                }

                @Override
                public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
                }
            });
            if (!AZUREUS_CORE.isStarted() && !AZUREUS_CORE.isRestarting()) {
                AZUREUS_CORE.start();
            }
            AZUREUS_CORE.getGlobalManager().resumeDownloads();
            LOG.debug("azureusInit(): core.start() waiting...");
            try {
                countDownLatch.await();
                LOG.debug("azureusInit(): core started...");
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static void revertToDefaultConfiguration() {
        COConfigurationManager.resetToDefaults();
        AzureusStarter.autoAdjustBittorrentSpeed();
    }

    public static void autoAdjustBittorrentSpeed() {
        if (COConfigurationManager.getBooleanParameter("Auto Adjust Transfer Defaults")) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = n3 / 1024;
            int[][] nArrayArray = new int[][]{{56, 2, 20, 40}, {96, 3, 30, 60}, {128, 3, 40, 80}, {192, 4, 50, 100}, {256, 4, 60, 200}, {512, 5, 70, 300}, {1024, 6, 80, 400}, {2048, 8, 90, 500}, {5120, 10, 100, 600}, {10240, 20, 110, 750}, {20480, 30, 120, 900}, {51200, 40, 130, 1100}, {102400, 50, 140, 1300}, {-1, 60, 150, 1500}};
            int[] nArray = nArrayArray[nArrayArray.length - 1];
            for (n2 = 3; n2 < nArrayArray.length; ++n2) {
                int[] nArray2 = nArrayArray[n2];
                n = nArray2[0];
                int n5 = n / 8 * 4 / 5;
                if (n4 > n5) continue;
                nArray = nArray2;
                break;
            }
            n2 = nArray[1];
            int n6 = nArray[2];
            n = nArray[3];
            if (n2 != COConfigurationManager.getIntParameter("Max Uploads")) {
                COConfigurationManager.setParameter("Max Uploads", n2);
                COConfigurationManager.setParameter("Max Uploads Seeding", n2);
            }
            if (n6 != COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent")) {
                COConfigurationManager.setParameter("Max.Peer.Connections.Per.Torrent", n6);
                COConfigurationManager.setParameter("Max.Peer.Connections.Per.Torrent.When.Seeding", n6 / 2);
            }
            if (n != COConfigurationManager.getIntParameter("Max.Peer.Connections.Total")) {
                COConfigurationManager.setParameter("Max.Peer.Connections.Total", n);
            }
        }
    }
}

