/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.frostwire.HttpFetcherListener;
import com.frostwire.UserAgentGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.limewire.util.FileUtils;

public class HttpFetcher {
    private static final String DEFAULT_USER_AGENT = UserAgentGenerator.getUserAgent();
    private static final int DEFAULT_TIMEOUT = 10000;
    private static HttpClient DEFAULT_HTTP_CLIENT;
    private static HttpClient DEFAULT_HTTP_CLIENT_GZIP;
    private final URI _uri;
    private final String _userAgent;
    private final int _timeout;
    private byte[] body = null;

    public HttpFetcher(URI uRI, String string, int n) {
        this._uri = uRI;
        this._userAgent = string;
        this._timeout = n;
    }

    public HttpFetcher(URI uRI, String string) {
        this(uRI, string, 10000);
    }

    public HttpFetcher(URI uRI, int n) {
        this(uRI, DEFAULT_USER_AGENT, n);
    }

    public HttpFetcher(URI uRI) {
        this(uRI, DEFAULT_USER_AGENT);
    }

    public HttpFetcher(String string) {
        this(HttpFetcher.convert(string));
    }

    public HttpFetcher(String string, int n) {
        this(HttpFetcher.convert(string), n);
    }

    public Object[] fetch(boolean bl) throws IOException {
        return this.fetch(bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] fetch(boolean bl, String string) throws IOException {
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpGet httpGet = new HttpGet(this._uri);
        httpGet.addHeader("Connection", "close");
        if (string != null) {
            httpGet.addHeader("Referer", string);
        }
        HttpParams httpParams = httpGet.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, this._timeout);
        HttpConnectionParams.setSoTimeout(httpParams, this._timeout);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, this._userAgent);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HttpResponse httpResponse = (bl ? DEFAULT_HTTP_CLIENT_GZIP : DEFAULT_HTTP_CLIENT).execute(httpHost, httpGet);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, downloading file " + httpResponse.getStatusLine().getStatusCode());
            }
            Long l = 0L;
            Header[] headerArray = httpResponse.getAllHeaders();
            for (int i = 0; i < headerArray.length; ++i) {
                if (!headerArray[i].getName().startsWith("Last-Modified")) continue;
                try {
                    l = DateUtils.parseDate(headerArray[i].getValue()).getTime();
                }
                catch (Exception exception) {}
                break;
            }
            if (httpResponse.getEntity() != null) {
                if (bl) {
                    String string2 = EntityUtils.toString(httpResponse.getEntity());
                    byteArrayOutputStream.write(string2.getBytes());
                } else {
                    httpResponse.getEntity().writeTo(byteArrayOutputStream);
                }
            }
            this.body = byteArrayOutputStream.toByteArray();
            if (this.body == null || this.body.length == 0) {
                throw new IOException("invalid response");
            }
            Object[] objectArray = new Object[]{this.body, l};
            return objectArray;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] fetch() {
        Object[] objectArray = null;
        try {
            objectArray = this.fetch(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (objectArray != null) {
            return (byte[])objectArray[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpGet httpGet = new HttpGet(this._uri);
        httpGet.addHeader("Connection", "close");
        HttpParams httpParams = httpGet.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, this._timeout);
        HttpConnectionParams.setSoTimeout(httpParams, this._timeout);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, this._userAgent);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            HttpResponse httpResponse = DEFAULT_HTTP_CLIENT.execute(httpHost, httpGet);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, downloading file " + httpResponse.getStatusLine().getStatusCode());
            }
            if (httpResponse.getEntity() != null) {
                HttpFetcher.writeEntity(httpResponse.getEntity(), fileOutputStream);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(fileOutputStream);
            throw throwable;
        }
        FileUtils.close(fileOutputStream);
    }

    public byte[] postJSON(String string) throws IOException {
        return this.post(string, "application/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] post(String string, String string2) throws IOException {
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpPost httpPost = new HttpPost(this._uri);
        StringEntity stringEntity = new StringEntity(string);
        httpPost.setHeader("Accept", string2);
        httpPost.setHeader("Content-type", string2);
        httpPost.setEntity(stringEntity);
        HttpParams httpParams = httpPost.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, this._timeout);
        HttpConnectionParams.setSoTimeout(httpParams, this._timeout);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, DEFAULT_USER_AGENT);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HttpResponse httpResponse = DEFAULT_HTTP_CLIENT.execute(httpHost, httpPost);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, upload file " + httpResponse.getStatusLine().getStatusCode());
            }
            if (httpResponse.getEntity() != null) {
                httpResponse.getEntity().writeTo(byteArrayOutputStream);
            }
            this.body = byteArrayOutputStream.toByteArray();
            if (this.body == null || this.body.length == 0) {
                throw new IOException("invalid response");
            }
            byte[] byArray = this.body;
            return byArray;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            new IOException("Http error: " + exception.getMessage(), exception);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(File file) throws IOException {
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpPost httpPost = new HttpPost(this._uri);
        FileEntity fileEntity = new FileEntity(file, "binary/octet-stream");
        fileEntity.setChunked(true);
        httpPost.setEntity(fileEntity);
        HttpParams httpParams = httpPost.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, this._timeout);
        HttpConnectionParams.setSoTimeout(httpParams, this._timeout);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, DEFAULT_USER_AGENT);
        try {
            HttpResponse httpResponse = DEFAULT_HTTP_CLIENT.execute(httpHost, httpPost);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, upload file " + httpResponse.getStatusLine().getStatusCode());
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            new IOException("Http error: " + exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(FileEntity fileEntity) throws IOException {
        HttpClient httpClient = HttpFetcher.setupHttpClient(false);
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpPost httpPost = new HttpPost(this._uri);
        httpPost.setEntity(fileEntity);
        HttpParams httpParams = httpPost.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, this._timeout);
        HttpConnectionParams.setSoTimeout(httpParams, this._timeout);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, DEFAULT_USER_AGENT);
        try {
            HttpResponse httpResponse = httpClient.execute(httpHost, httpPost);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, upload file " + httpResponse.getStatusLine().getStatusCode());
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            new IOException("Http error: " + exception.getMessage(), exception);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void asyncPostJSON(String string, HttpFetcherListener httpFetcherListener) {
        this.asyncPost(string, "application/json", httpFetcherListener);
    }

    public void asyncPost(final String string, final String string2, final HttpFetcherListener httpFetcherListener) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] byArray = HttpFetcher.this.post(string, string2);
                    if (httpFetcherListener != null) {
                        httpFetcherListener.onSuccess(byArray);
                    }
                }
                catch (Throwable throwable) {
                    httpFetcherListener.onError(throwable);
                }
            }
        });
        thread.setName("HttpFetcher-asyncPost");
        thread.start();
    }

    public void asyncRequest(HttpRequestInfo httpRequestInfo, HttpFetcherListener httpFetcherListener) {
        if (httpRequestInfo.isGET()) {
            this.asyncGet(httpFetcherListener);
        } else {
            this.asyncPost(httpRequestInfo.getBody(), httpRequestInfo.getContentType(), httpFetcherListener);
        }
    }

    private void asyncGet(final HttpFetcherListener httpFetcherListener) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] byArray = HttpFetcher.this.fetch();
                if (byArray == null) {
                    httpFetcherListener.onError(new Exception("HttpFetch.fetch() failed."));
                } else {
                    httpFetcherListener.onSuccess(byArray);
                }
            }
        });
        thread.setName("HttpFetcher-asyncGet");
        thread.start();
    }

    private static void setupHttpClients() {
        DEFAULT_HTTP_CLIENT = HttpFetcher.setupHttpClient(false);
        DEFAULT_HTTP_CLIENT_GZIP = HttpFetcher.setupHttpClient(true);
    }

    private static HttpClient setupHttpClient(boolean bl) {
        SSLSocketFactory.getSocketFactory().setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        basicHttpParams.setParameter("http.conn-manager.max-per-route", new ConnPerRouteBean(20));
        basicHttpParams.setIntParameter("http.conn-manager.max-total", 200);
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager(basicHttpParams, schemeRegistry);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(threadSafeClientConnManager, new BasicHttpParams());
        defaultHttpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(0, false));
        if (bl) {
            defaultHttpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                @Override
                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    if (!httpRequest.containsHeader("Accept-Encoding")) {
                        httpRequest.addHeader("Accept-Encoding", "gzip");
                    }
                }
            });
            defaultHttpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                @Override
                public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    Header header = httpEntity.getContentEncoding();
                    if (header != null) {
                        HeaderElement[] headerElementArray = header.getElements();
                        for (int i = 0; i < headerElementArray.length; ++i) {
                            if (!headerElementArray[i].getName().equalsIgnoreCase("gzip")) continue;
                            httpResponse.setEntity(new GzipDecompressingEntity(httpResponse.getEntity()));
                            return;
                        }
                    }
                }
            });
        }
        return defaultHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeEntity(HttpEntity httpEntity, OutputStream outputStream) throws IOException {
        if (httpEntity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return;
        }
        int n = (int)httpEntity.getContentLength();
        if (n < 0) {
            n = 4096;
        }
        try {
            int n2;
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                outputStream.flush();
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static URI convert(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    static {
        HttpFetcher.setupHttpClients();
    }

    private static final class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity httpEntity) {
            super(httpEntity);
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        @Override
        public long getContentLength() {
            return -1L;
        }
    }

    public static class HttpRequestInfo {
        private boolean _isGet;
        private String _body;
        private String _contentType;

        public HttpRequestInfo(boolean bl, String string, String string2) {
            this._isGet = bl;
            this._body = string;
            this._contentType = string2;
        }

        public String getBody() {
            return this._body;
        }

        public String getContentType() {
            return this._contentType;
        }

        public boolean isGET() {
            return this._isGet;
        }
    }
}

