/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.frostwire.HttpFetcher;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.OSUtils;

public class ImageCache {
    private static final Log LOG = LogFactory.getLog(ImageCache.class);
    private static ImageCache instance;

    public static synchronized ImageCache instance() {
        if (instance == null) {
            instance = new ImageCache();
        }
        return instance;
    }

    private ImageCache() {
    }

    public BufferedImage getImage(URL uRL, OnLoadedListener onLoadedListener) {
        if (this.isCached(uRL)) {
            return this.loadFromCache(uRL, onLoadedListener);
        }
        if (!uRL.getProtocol().equals("http")) {
            return this.loadFromResource(uRL, onLoadedListener);
        }
        this.loadFromUrl(uRL, onLoadedListener);
        return null;
    }

    private File getCacheFile(URL uRL) {
        String string = uRL.getHost();
        String string2 = uRL.getPath();
        if (string == null || string.length() == 0) {
            string = "localhost";
            string2 = new File(string2).getName();
        }
        return new File(SharingSettings.getImageCacheDirectory(), File.separator + string + File.separator + string2);
    }

    public URL getCachedFileURL(URL uRL) {
        if (this.isCached(uRL)) {
            try {
                return this.getCacheFile(uRL).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    private boolean isCached(URL uRL) {
        File file = this.getCacheFile(uRL);
        return file.exists();
    }

    private BufferedImage loadFromCache(URL uRL, OnLoadedListener onLoadedListener) {
        try {
            File file = this.getCacheFile(uRL);
            BufferedImage bufferedImage = ImageIO.read(file);
            onLoadedListener.onLoaded(uRL, bufferedImage, true, false);
            return bufferedImage;
        }
        catch (Throwable throwable) {
            LOG.error("Failed to load image from cache: " + uRL, throwable);
            if (throwable instanceof OutOfMemoryError) {
                throwable.printStackTrace();
            }
            onLoadedListener.onLoaded(uRL, null, false, true);
            return null;
        }
    }

    private BufferedImage loadFromResource(URL uRL, OnLoadedListener onLoadedListener) {
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            this.saveToCache(uRL, bufferedImage, 0L);
            onLoadedListener.onLoaded(uRL, bufferedImage, false, false);
            return bufferedImage;
        }
        catch (Throwable throwable) {
            LOG.error("Failed to load image from resource: " + uRL, throwable);
            onLoadedListener.onLoaded(uRL, null, false, true);
            return null;
        }
    }

    private void loadFromUrl(final URL uRL, final OnLoadedListener onLoadedListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedImage bufferedImage = null;
                    String string = "FrostWire/" + OSUtils.getOS() + "/" + FrostWireUtils.getFrostWireVersion();
                    HttpFetcher httpFetcher = new HttpFetcher(uRL.toURI(), string);
                    Object[] objectArray = httpFetcher.fetch(false);
                    if (objectArray == null) {
                        throw new IOException("HttpFetcher.fetch() got nothing at " + uRL.toString());
                    }
                    byte[] byArray = (byte[])objectArray[0];
                    long l = (Long)objectArray[1];
                    if (byArray != null) {
                        bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                        ImageCache.this.saveToCache(uRL, bufferedImage, l);
                    }
                    if (onLoadedListener != null && bufferedImage != null) {
                        onLoadedListener.onLoaded(uRL, bufferedImage, false, false);
                    }
                }
                catch (Throwable throwable) {
                    LOG.error("Failed to load image from: " + uRL, throwable);
                    onLoadedListener.onLoaded(uRL, null, false, true);
                }
            }
        }).start();
    }

    private void saveToCache(URL uRL, BufferedImage bufferedImage, long l) {
        try {
            File file = this.getCacheFile(uRL);
            if (file.exists()) {
                file.delete();
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            String string3 = ImageIO.getImageReadersBySuffix(string2).next().getFormatName();
            if (!file.getParentFile().exists()) {
                file.mkdirs();
            }
            ImageIO.write((RenderedImage)bufferedImage, string3, file);
            file.setLastModified(l);
        }
        catch (Throwable throwable) {
            LOG.error("Failed to save image to cache: " + uRL, throwable);
        }
    }

    public static interface OnLoadedListener {
        public void onLoaded(URL var1, BufferedImage var2, boolean var3, boolean var4);
    }
}

