/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch;

import com.frostwire.HttpFetcher;
import com.frostwire.bittorrent.websearch.WebSearchPerformer;
import com.frostwire.bittorrent.websearch.WebSearchResult;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limewire.util.StringUtils;

public abstract class HttpWebSearchPerformer
implements WebSearchPerformer {
    @Override
    public List<WebSearchResult> search(String string) {
        ArrayList<WebSearchResult> arrayList = new ArrayList<WebSearchResult>();
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        HttpFetcher httpFetcher = null;
        try {
            httpFetcher = new HttpFetcher(this.getURI(string), 5000);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return arrayList;
        }
        byte[] byArray = httpFetcher.fetch();
        if (byArray == null) {
            return arrayList;
        }
        String string2 = StringUtils.getUTF8String(byArray);
        String string3 = this.getRegex();
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string2);
        int n = this.getMaxResults();
        int n2 = 0;
        while (matcher.find() && n2 < n) {
            try {
                WebSearchResult webSearchResult = this.getNextSearchResult(matcher);
                if (webSearchResult == null) continue;
                arrayList.add(webSearchResult);
                ++n2;
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    protected abstract URI getURI(String var1) throws URISyntaxException;

    protected abstract WebSearchResult getNextSearchResult(Matcher var1);

    protected abstract String getRegex();

    protected int getMaxResults() {
        return Integer.MAX_VALUE;
    }
}

