/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.clearbits;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.clearbits.ClearBitsItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ClearBitsWebSearchResult
implements WebSearchResult {
    private final ClearBitsItem _item;

    public ClearBitsWebSearchResult(ClearBitsItem clearBitsItem) {
        this._item = clearBitsItem;
    }

    @Override
    public long getCreationTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        long l = System.currentTimeMillis();
        try {
            l = simpleDateFormat.parse(this._item.created_at).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public String getFileName() {
        String string = this._item.title.replace("<b>", "").replace("</b>", "");
        return string + ".torrent";
    }

    @Override
    public String getHash() {
        return this._item.hashstr;
    }

    @Override
    public String getTorrentURI() {
        return this._item.torrent_url;
    }

    @Override
    public long getSize() {
        return this._item.mb_size * 1024 * 1024;
    }

    @Override
    public String getSource() {
        return "ClearBits";
    }

    @Override
    public int getSeeds() {
        return this._item.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this._item.location;
    }

    @Override
    public String getDisplayName() {
        return this._item.title;
    }
}

