/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.extratorrent;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.extratorrent.ExtratorrentItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ExtratorrentResponseWebSearchResult
implements WebSearchResult {
    private final ExtratorrentItem _item;

    public ExtratorrentResponseWebSearchResult(ExtratorrentItem extratorrentItem) {
        this._item = extratorrentItem;
    }

    @Override
    public String getFileName() {
        String string = this._item.title.replace("<b>", "").replace("</b>", "");
        return string + ".torrent";
    }

    @Override
    public long getSize() {
        return this._item.size;
    }

    @Override
    public long getCreationTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        long l = System.currentTimeMillis();
        try {
            l = simpleDateFormat.parse(this._item.pubDate).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public String getSource() {
        return "Extratorrent";
    }

    @Override
    public String getHash() {
        return this._item.hash;
    }

    @Override
    public String getTorrentURI() {
        return this._item.torrentLink;
    }

    @Override
    public int getSeeds() {
        return this._item.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this._item.link;
    }

    @Override
    public String getDisplayName() {
        return this._item.title;
    }
}

