/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.isohunt;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.isohunt.ISOHuntItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ISOHuntWebSearchResult
implements WebSearchResult {
    private ISOHuntItem _item;

    public ISOHuntWebSearchResult(ISOHuntItem iSOHuntItem) {
        this._item = iSOHuntItem;
        this._item.title = this._item.title.replace("<b>", "").replace("</b>", "");
    }

    @Override
    public long getCreationTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        long l = System.currentTimeMillis();
        try {
            l = simpleDateFormat.parse(this._item.pubDate).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public String getFileName() {
        return this._item.title + ".torrent";
    }

    @Override
    public String getHash() {
        return this._item.hash;
    }

    @Override
    public String getTorrentURI() {
        return this._item.enclosure_url;
    }

    @Override
    public long getSize() {
        return Long.valueOf(this._item.length);
    }

    @Override
    public String getSource() {
        return "ISOHunt";
    }

    @Override
    public int getSeeds() {
        try {
            return Integer.valueOf(this._item.Seeds);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public String getDetailsUrl() {
        return this._item.link;
    }

    @Override
    public String getDisplayName() {
        return this._item.title;
    }
}

