/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.kat;

import com.frostwire.HttpFetcher;
import com.frostwire.JsonEngine;
import com.frostwire.bittorrent.websearch.WebSearchPerformer;
import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.kat.KATItem;
import com.frostwire.bittorrent.websearch.kat.KATResponse;
import com.frostwire.bittorrent.websearch.kat.KATWebSearchResult;
import com.limegroup.gnutella.settings.SearchEnginesSettings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class KATWebSearchPerformer
implements WebSearchPerformer {
    @Override
    public List<WebSearchResult> search(String string) {
        ArrayList<WebSearchResult> arrayList = new ArrayList<WebSearchResult>();
        KATResponse kATResponse = this.searchKAT(string);
        if (kATResponse != null && kATResponse.list != null) {
            int n = 0;
            for (KATItem kATItem : kATResponse.list) {
                KATWebSearchResult kATWebSearchResult = new KATWebSearchResult(kATItem);
                arrayList.add(kATWebSearchResult);
                if (++n <= this.getMaxResults()) continue;
                break;
            }
        }
        return arrayList;
    }

    private int getMaxResults() {
        return SearchEnginesSettings.KAT_WEBSEARCHPERFORMER_MAX_RESULTS.getValue();
    }

    private KATResponse searchKAT(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        HttpFetcher httpFetcher = null;
        try {
            httpFetcher = new HttpFetcher(new URI("http://www.kat.ph/json.php?q=" + string2), 5000);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        byte[] byArray = httpFetcher.fetch();
        if (byArray == null) {
            return null;
        }
        String string3 = new String(byArray);
        JsonEngine jsonEngine = new JsonEngine();
        KATResponse kATResponse = null;
        try {
            kATResponse = jsonEngine.toObject(string3, KATResponse.class);
        }
        catch (Exception exception) {
            return null;
        }
        kATResponse.fixItems();
        return kATResponse;
    }
}

