/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.kat;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.kat.KATItem;
import com.limegroup.gnutella.util.UrlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class KATWebSearchResult
implements WebSearchResult {
    private final KATItem _item;

    public KATWebSearchResult(KATItem kATItem) {
        this._item = kATItem;
    }

    @Override
    public long getCreationTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE dd MMM yyyy HH:mm:ss Z ");
        long l = System.currentTimeMillis();
        try {
            l = simpleDateFormat.parse(this._item.pubDate).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public String getFileName() {
        String string = this._item.title.replace("<b>", "").replace("</b>", "");
        return string + ".torrent";
    }

    @Override
    public String getHash() {
        return this._item.hash;
    }

    @Override
    public String getTorrentURI() {
        return "magnet:?xt=urn:btih:" + this.getHash() + "&dn=" + UrlUtils.encode(this.getFileName()) + "&tr=http%3A%2F%2Ftracker.publicbt.com%2Fannounce";
    }

    @Override
    public long getSize() {
        return this._item.size;
    }

    @Override
    public String getSource() {
        return "KAT";
    }

    @Override
    public int getSeeds() {
        return this._item.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this._item.link;
    }

    @Override
    public String getDisplayName() {
        return this._item.title;
    }
}

