/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.monova;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.limewire.util.FilenameUtils;

public class MonovaWebSearchResult
implements WebSearchResult {
    private String fileName;
    private String torrentDetailsURI;
    private String torrentURI;
    private String infoHash;
    private long size;
    private long creationTime;
    private int seeds;
    private static final long[] BYTE_MULTIPLIERS = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 256L, 262144L};
    private static final Map<String, Integer> UNIT_TO_BYTE_MULTIPLIERS_MAP = new HashMap<String, Integer>();

    public MonovaWebSearchResult(String string, Matcher matcher) {
        this.torrentDetailsURI = string;
        this.torrentURI = matcher.group(1);
        this.fileName = FilenameUtils.getName(this.torrentURI);
        this.infoHash = matcher.group(2).split("&")[0];
        this.creationTime = this.parseCreationTime(this.torrentURI);
        this.size = this.parseSize(matcher.group(4));
        this.seeds = this.parseSeeds(matcher.group(3));
    }

    private long parseSize(String string) {
        String[] stringArray = string.trim().split(" ");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        long l = BYTE_MULTIPLIERS[UNIT_TO_BYTE_MULTIPLIERS_MAP.get(string3)];
        if (string2.indexOf(".") > 0) {
            float f = Float.parseFloat(string2);
            return (long)(f * (float)l);
        }
        int n = Integer.parseInt(string2);
        return (long)n * l;
    }

    private int parseSeeds(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private long parseCreationTime(String string) {
        String[] stringArray = string.split("/");
        stringArray = stringArray[6].split("-");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n, n2, n3);
        return calendar.getTimeInMillis();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "Monova";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public String getTorrentURI() {
        return this.torrentURI;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.torrentDetailsURI;
    }

    @Override
    public String getDisplayName() {
        return this.fileName;
    }

    static {
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("B", 0);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("KB", 1);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("MB", 2);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("GB", 3);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("TB", 4);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("PB", 5);
    }
}

