/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.soundcloud;

import com.frostwire.HttpFetcher;
import com.frostwire.JsonEngine;
import com.frostwire.bittorrent.websearch.WebSearchPerformer;
import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.soundcloud.SoundcloudItem;
import com.frostwire.bittorrent.websearch.soundcloud.SoundcloudTrackSearchResult;
import com.limegroup.gnutella.settings.SearchEnginesSettings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.StringUtils;

public class SoundcloudSearchPerformer
implements WebSearchPerformer {
    private static final Log LOG = LogFactory.getLog(SoundcloudSearchPerformer.class);
    private SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMMM, dd yyyy HH:mm:ss Z");

    @Override
    public List<WebSearchResult> search(String string) {
        ArrayList<WebSearchResult> arrayList = new ArrayList<WebSearchResult>();
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Can't UTF-8 encode keywords: " + string, unsupportedEncodingException);
        }
        int n = this.getMaxResults() / 10;
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(this.searchPage(i + 1, string));
        }
        return arrayList;
    }

    private List<WebSearchResult> searchPage(int n, String string) {
        ArrayList<WebSearchResult> arrayList = new ArrayList<WebSearchResult>();
        HttpFetcher httpFetcher = null;
        try {
            httpFetcher = new HttpFetcher(this.getURI(n, string), 5000);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.error("Can't create uri", uRISyntaxException);
            return arrayList;
        }
        byte[] byArray = httpFetcher.fetch();
        if (byArray == null) {
            return arrayList;
        }
        String string2 = StringUtils.getUTF8String(byArray);
        String string3 = this.getRegex();
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string2);
        JsonEngine jsonEngine = new JsonEngine();
        int n2 = this.getMaxResults();
        int n3 = 0;
        while (matcher.find() && n3 < n2) {
            try {
                SoundcloudTrackSearchResult soundcloudTrackSearchResult;
                SoundcloudItem soundcloudItem = jsonEngine.toObject(matcher.group(2), SoundcloudItem.class);
                try {
                    soundcloudItem.date = this.DATE_FORMAT.parse(matcher.group(1)).getTime();
                }
                catch (Throwable throwable) {
                    soundcloudItem.date = -1L;
                }
                if ((soundcloudTrackSearchResult = new SoundcloudTrackSearchResult(soundcloudItem)) == null) continue;
                arrayList.add(soundcloudTrackSearchResult);
                ++n3;
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public URI getURI(int n, String string) throws URISyntaxException {
        return new URI("http://soundcloud.com/tracks/search?page=" + n + "&q[fulltext]=" + string);
    }

    public String getRegex() {
        return "(?is)<abbr title='(.*?)'.*?window.SC.bufferTracks.push\\((.*?)\\);";
    }

    protected int getMaxResults() {
        return SearchEnginesSettings.SOUNDCLOUD_WEBSEARCHPERFORMER_MAX_RESULTS.getValue();
    }
}

