/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.soundcloud;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.soundcloud.SoundcloudItem;

public class SoundcloudTrackSearchResult
implements WebSearchResult {
    private final SoundcloudItem item;
    private final String trackUrl;

    public SoundcloudTrackSearchResult(SoundcloudItem soundcloudItem) {
        this.item = soundcloudItem;
        this.trackUrl = "http://soundcloud.com" + soundcloudItem.uri;
    }

    @Override
    public String getFileName() {
        return this.item.name + ".mp3";
    }

    @Override
    public long getSize() {
        return Math.round((float)this.item.duration * 128.0f / 8.0f);
    }

    @Override
    public long getCreationTime() {
        return this.item.date;
    }

    @Override
    public String getSource() {
        if (this.item.user != null && this.item.user.username != null) {
            return "Soundcloud - " + this.item.user.username;
        }
        return "Soundcloud";
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public String getTorrentURI() {
        return this.trackUrl;
    }

    @Override
    public int getSeeds() {
        return -1;
    }

    @Override
    public String getDetailsUrl() {
        return this.trackUrl;
    }

    @Override
    public String getDisplayName() {
        return this.item.title;
    }

    public String getStreamUrl() {
        return this.item.streamUrl;
    }
}

