/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.tpb;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TPBWebSearchResult
implements WebSearchResult {
    private String fileName;
    private String torrentDetailsURI;
    private String torrentURI;
    private String infoHash;
    private long size;
    private long creationTime;
    private int seeds;
    private static final long[] BYTE_MULTIPLIERS = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 256L, 262144L};
    private static final Map<String, Integer> UNIT_TO_BYTE_MULTIPLIERS_MAP = new HashMap<String, Integer>();
    private static final Pattern COMMON_DATE_PATTERN;
    private static final Pattern OLDER_DATE_PATTERN;
    private static final Pattern DATE_TIME_PATTERN;

    public TPBWebSearchResult(Matcher matcher) {
        this.torrentDetailsURI = matcher.group(2);
        this.fileName = matcher.group(3);
        this.torrentURI = matcher.group(4);
        this.infoHash = this.torrentURI.substring(20, 60);
        this.creationTime = this.parseCreationTime(matcher.group(5));
        this.size = this.parseSize(matcher.group(6));
        this.seeds = this.parseSeeds(matcher.group(7));
    }

    private long parseSize(String string) {
        String[] stringArray = string.split("&nbsp;");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        long l = BYTE_MULTIPLIERS[UNIT_TO_BYTE_MULTIPLIERS_MAP.get(string3)];
        if (string2.indexOf(".") > 0) {
            float f = Float.parseFloat(string2);
            return (long)(f * (float)l);
        }
        int n = Integer.parseInt(string2);
        return (long)n * l;
    }

    private int parseSeeds(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private long parseCreationTime(String string) {
        Matcher matcher;
        if (string.contains("Today") || string.contains("<b>")) {
            return System.currentTimeMillis();
        }
        if (string.contains("Y-day")) {
            return System.currentTimeMillis() - 86400000L;
        }
        Matcher matcher2 = OLDER_DATE_PATTERN.matcher(string);
        Matcher matcher3 = COMMON_DATE_PATTERN.matcher(string);
        Matcher matcher4 = DATE_TIME_PATTERN.matcher(string);
        Matcher matcher5 = matcher = matcher2.matches() ? matcher2 : matcher3;
        if (!matcher.matches() && matcher4.matches()) {
            matcher = matcher4;
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = 0;
        if (matcher2.matches() && matcher2.groupCount() == 3) {
            n3 = Integer.parseInt(matcher.group(3));
        } else if (matcher3.matches() || matcher4.matches()) {
            n3 = Calendar.getInstance().get(1);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n3, n, n2);
        return calendar.getTimeInMillis();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "TPB";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public String getTorrentURI() {
        return this.torrentURI;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return "http://thepiratebay.org" + this.torrentDetailsURI;
    }

    @Override
    public String getDisplayName() {
        return this.fileName;
    }

    static {
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("B", 0);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("KiB", 1);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("MiB", 2);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("GiB", 3);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("TiB", 4);
        UNIT_TO_BYTE_MULTIPLIERS_MAP.put("PiB", 5);
        COMMON_DATE_PATTERN = Pattern.compile("([\\d]{2})-([\\d]{2})");
        OLDER_DATE_PATTERN = Pattern.compile("([\\d]{2})-([\\d]{2})&nbsp;([\\d]{4})");
        DATE_TIME_PATTERN = Pattern.compile("([\\d]{2})-([\\d]{2})&nbsp;(\\d\\d:\\d\\d)");
    }
}

