/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent.websearch.vertor;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.vertor.VertorItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class VertorResponseWebSearchResult
implements WebSearchResult {
    private final VertorItem _item;

    public VertorResponseWebSearchResult(VertorItem vertorItem) {
        this._item = vertorItem;
    }

    @Override
    public String getFileName() {
        String string = this._item.name.replace("<b>", "").replace("</b>", "");
        return string + ".torrent";
    }

    @Override
    public long getSize() {
        return Long.valueOf(this._item.size);
    }

    @Override
    public long getCreationTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yy");
        long l = System.currentTimeMillis();
        try {
            l = simpleDateFormat.parse(this._item.cdate).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public String getSource() {
        return "Vertor";
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public String getTorrentURI() {
        return this._item.download;
    }

    @Override
    public int getSeeds() {
        return Integer.valueOf(this._item.seeds);
    }

    @Override
    public String getDetailsUrl() {
        return this._item.url;
    }

    @Override
    public String getDisplayName() {
        return this._item.name;
    }
}

