/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class HideExitDialog
extends JDialog {
    private static final long serialVersionUID = 2944990636303224030L;
    public static final int NONE = 0;
    public static final int HIDE = 1;
    public static final int EXIT = 2;
    private JLabel _label;
    private JCheckBox _checkBox;
    private JButton _buttonHide;
    private JButton _buttonExit;
    private int _result = 0;

    public HideExitDialog(JFrame jFrame) {
        super((Frame)jFrame, I18n.tr("Do you want to hide FrostWire?"));
        this.setupUI();
        this.setLocationRelativeTo(jFrame);
    }

    protected void setupUI() {
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this._label = new JLabel(I18n.tr("<html>Closing the FrostWire window will only hide the application<p>This way file transfers may continue in the background.</html>"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._label, gridBagConstraints);
        this._checkBox = new JCheckBox(I18n.tr("Don't show this again"));
        this._checkBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._checkBox, gridBagConstraints);
        this._buttonHide = new JButton(I18n.tr("Hide"));
        this._buttonHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HideExitDialog.this.buttonHide_actionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 430, 8, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 20;
        this.getContentPane().add((Component)this._buttonHide, gridBagConstraints);
        this._buttonExit = new JButton(I18n.tr("Exit"));
        this._buttonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HideExitDialog.this.buttonExit_actionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 8, 6);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 18;
        this.getContentPane().add((Component)this._buttonExit, gridBagConstraints);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getRootPane().setDefaultButton(this._buttonHide);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
    }

    protected void buttonHide_actionPerformed(ActionEvent actionEvent) {
        this._result = 1;
        if (this._checkBox.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(true);
            ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.setValue(false);
        }
        GUIUtils.getDisposeAction().actionPerformed(actionEvent);
    }

    protected void buttonExit_actionPerformed(ActionEvent actionEvent) {
        this._result = 2;
        if (this._checkBox.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.setValue(false);
        }
        GUIUtils.getDisposeAction().actionPerformed(actionEvent);
    }

    public int getResult() {
        return this._result;
    }
}

