/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.ShareTorrentDialog;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class BTDownloadActions {
    static final ShowDetailsAction SHOW_DETAILS_ACTION = new ShowDetailsAction();
    static final ExploreAction EXPLORE_ACTION = new ExploreAction();
    static final ShowInLibraryAction SHOW_IN_LIBRARY_ACTION = new ShowInLibraryAction();
    static final ResumeAction RESUME_ACTION = new ResumeAction();
    static final PauseAction PAUSE_ACTION = new PauseAction();
    static final RemoveAction REMOVE_ACTION = new RemoveAction(false, false);
    static final RemoveAction REMOVE_YOUTUBE_ACTION = new RemoveYouTubeAction();
    static final RemoveAction REMOVE_TORRENT_ACTION = new RemoveAction(true, false);
    static final RemoveAction REMOVE_TORRENT_AND_DATA_ACTION = new RemoveAction(true, true);
    static final CopyMagnetAction COPY_MAGNET_ACTION = new CopyMagnetAction();
    static final CopyInfoHashAction COPY_HASH_ACTION = new CopyInfoHashAction();
    static final SendBTDownloaderAudioFilesToiTunes SEND_TO_ITUNES_ACTION = new SendBTDownloaderAudioFilesToiTunes();
    static final ToggleSeedsVisibilityAction TOGGLE_SEEDS_VISIBILITY_ACTION = new ToggleSeedsVisibilityAction();
    static final ShareTorrentAction SHARE_TORRENT_ACTION = new ShareTorrentAction();
    static final PlaySingleAudioFileAction PLAY_SINGLE_AUDIO_FILE_ACTION = new PlaySingleAudioFileAction();

    BTDownloadActions() {
    }

    static class AddToPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 2785648153922643785L;
        private Playlist playlist;

        public AddToPlaylistAction(Playlist playlist) {
            super(playlist.getName());
            this.putValue("LongDescription", I18n.tr("Add to playlist ") + "\"" + playlist.getName() + "\"");
            this.playlist = playlist;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            ArrayList<File> arrayList = new ArrayList<File>(bTDownloadArray.length);
            for (BTDownload bTDownload : bTDownloadArray) {
                if (!bTDownload.isCompleted()) {
                    return;
                }
                arrayList.add(bTDownload.getSaveLocation());
            }
            LibraryUtils.asyncAddToPlaylist(this.playlist, arrayList.toArray(new File[0]));
            GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
        }
    }

    static final class PlaySingleAudioFileAction
    extends AbstractAction {
        private static final long serialVersionUID = -3628469680044329612L;

        public PlaySingleAudioFileAction() {
            super(I18n.tr("Play audio file"));
            this.putValue("LongDescription", I18n.tr("Play Audio file"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = BTDownloadMediator.instance().getSelectedDownloaders()[0].getSaveLocation();
            if (AudioPlayer.isPlayableFile(file)) {
                AudioPlayer.instance().loadSong(new AudioSource(file), true, false);
            }
        }
    }

    static class CreateNewPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 3460908036485828909L;

        public CreateNewPlaylistAction() {
            super(I18n.tr("Create New Playlist"));
            this.putValue("LongDescription", I18n.tr("Create and add to a new playlist"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            ArrayList<File> arrayList = new ArrayList<File>(bTDownloadArray.length);
            for (BTDownload bTDownload : bTDownloadArray) {
                if (!bTDownload.isCompleted()) {
                    return;
                }
                arrayList.add(bTDownload.getSaveLocation());
            }
            LibraryUtils.createNewPlaylist(arrayList.toArray(new File[0]));
        }
    }

    static class ToggleSeedsVisibilityAction
    extends RefreshingAction {
        private static final long serialVersionUID = -1632629016830943795L;

        public ToggleSeedsVisibilityAction() {
            this.updateName();
            this.putValue("LimeShortName", I18n.tr("Show Details"));
            this.putValue("ShortDescription", I18n.tr("Show Torrent Details"));
        }

        private void updateName() {
            if (ApplicationSettings.SHOW_SEEDING_TRANSFERS.getValue()) {
                this.putValue("Name", I18n.tr("Hide Seeding Transfers"));
                this.putValue("LimeShortName", I18n.tr("Hide Seeding Transfers"));
                this.putValue("ShortDescription", I18n.tr("Don't show Seeding Transfers"));
            } else {
                this.putValue("Name", I18n.tr("Show Seeding Transfers"));
                this.putValue("LimeShortName", I18n.tr("Show Seeding Transfers"));
                this.putValue("ShortDescription", I18n.tr("Show Seeding Transfers"));
            }
        }

        @Override
        protected void performAction(ActionEvent actionEvent) {
            ApplicationSettings.SHOW_SEEDING_TRANSFERS.setValue(!ApplicationSettings.SHOW_SEEDING_TRANSFERS.getValue());
            this.updateName();
            BTDownloadMediator.instance().updateTableFilters();
        }
    }

    private static class ShareTorrentAction
    extends RefreshingAction {
        private static final long serialVersionUID = 1138409323772464985L;

        public ShareTorrentAction() {
            this.putValue("Name", I18n.tr("Send to friend"));
            this.putValue("LimeShortName", I18n.tr("Send to friend"));
            this.putValue("ShortDescription", I18n.tr("Send to friend"));
            this.putValue("LimeIconName", "SEND_HASH");
            this.putValue("SmallIcon", GUIMediator.getThemeImage("share"));
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            if (bTDownloadArray.length != 1) {
                return;
            }
            BTDownload bTDownload = bTDownloadArray[0];
            new ShareTorrentDialog(bTDownload.getDownloadManager().getTorrent()).setVisible(true);
        }
    }

    private static class CopyInfoHashAction
    extends RefreshingAction {
        private static final long serialVersionUID = 1138409323772464985L;

        public CopyInfoHashAction() {
            this.putValue("Name", I18n.tr("Copy Infohash"));
            this.putValue("LimeShortName", I18n.tr("Copy Infohash"));
            this.putValue("ShortDescription", I18n.tr("Copy Infohash"));
            this.putValue("LimeIconName", "COPY_HASH");
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            String string = "";
            for (int i = 0; i < bTDownloadArray.length; ++i) {
                string = string + bTDownloadArray[i].getHash();
                if (i >= bTDownloadArray.length - 1) continue;
                string = string + "\n";
            }
            GUIMediator.setClipboardContent(string);
        }
    }

    private static class CopyMagnetAction
    extends RefreshingAction {
        private static final long serialVersionUID = 1602974659454016547L;

        public CopyMagnetAction() {
            this.putValue("Name", I18n.tr("Copy Magnet"));
            this.putValue("LimeShortName", I18n.tr("Copy Magnet"));
            this.putValue("ShortDescription", I18n.tr("Copy Magnet"));
            this.putValue("LimeIconName", "COPY_MAGNET");
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            String string = "";
            for (int i = 0; i < bTDownloadArray.length; ++i) {
                string = string + TorrentUtil.getMagnet(bTDownloadArray[i].getHash()) + "&" + TorrentUtil.getMagnetURLParameters(bTDownloadArray[i].getDownloadManager().getTorrent());
                if (i >= bTDownloadArray.length - 1) continue;
                string = string + "\n";
            }
            GUIMediator.setClipboardContent(string);
        }
    }

    public static class RemoveYouTubeAction
    extends RemoveAction {
        private static final long serialVersionUID = 4101890173830827703L;

        public RemoveYouTubeAction() {
            super(true, true);
            this.putValue("Name", I18n.tr("Remove Download and Data"));
            this.putValue("LimeShortName", I18n.tr("Remove Download and Data"));
            this.putValue("ShortDescription", I18n.tr("Remove Download and Data from selected downloads"));
        }
    }

    public static class RemoveAction
    extends RefreshingAction {
        private static final long serialVersionUID = -1742554445891016991L;
        private final boolean _deleteTorrent;
        private final boolean _deleteData;

        public RemoveAction(boolean bl, boolean bl2) {
            if (bl && bl2) {
                this.putValue("Name", I18n.tr("Remove Torrent and Data"));
                this.putValue("LimeShortName", I18n.tr("Remove Torrent and Data"));
                this.putValue("ShortDescription", I18n.tr("Remove Torrent and Data from selected downloads"));
            } else if (bl) {
                this.putValue("Name", I18n.tr("Remove Torrent"));
                this.putValue("LimeShortName", I18n.tr("Remove Torrent"));
                this.putValue("ShortDescription", I18n.tr("Remove Torrent from selected downloads"));
            } else {
                this.putValue("Name", I18n.tr("Remove Download"));
                this.putValue("LimeShortName", I18n.tr("Remove"));
                this.putValue("ShortDescription", I18n.tr("Remove Selected Downloads"));
            }
            this.putValue("LimeIconName", "DOWNLOAD_KILL");
            this._deleteTorrent = bl;
            this._deleteData = bl2;
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            int n;
            if (this._deleteData && (n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.tr("Are you sure you want to remove the data files from your computer?\n\nYou won't be able to recover the files."), I18n.tr("Are you sure?"), 0, 3)) != 0) {
                return;
            }
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            for (int i = 0; i < bTDownloadArray.length; ++i) {
                bTDownloadArray[i].setDeleteTorrentWhenRemove(this._deleteTorrent);
                bTDownloadArray[i].setDeleteDataWhenRemove(this._deleteData);
            }
            BTDownloadMediator.instance().removeSelection();
        }
    }

    private static class PauseAction
    extends RefreshingAction {
        private static final long serialVersionUID = 4682149704934484393L;

        public PauseAction() {
            this.putValue("Name", I18n.tr("Pause Download"));
            this.putValue("LimeShortName", I18n.tr("Pause"));
            this.putValue("ShortDescription", I18n.tr("Pause Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_PAUSE");
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            for (int i = 0; i < bTDownloadArray.length; ++i) {
                bTDownloadArray[i].pause();
            }
        }
    }

    private static class ResumeAction
    extends RefreshingAction {
        private static final long serialVersionUID = -4449981369424872994L;

        public ResumeAction() {
            this.putValue("Name", I18n.tr("Resume Download"));
            this.putValue("LimeShortName", I18n.tr("Resume"));
            this.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_FILE_MORE_SOURCES");
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            int n;
            boolean bl = false;
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            for (n = 0; n < bTDownloadArray.length; ++n) {
                if (!bTDownloadArray[n].isCompleted()) continue;
                bl = true;
                break;
            }
            n = 1;
            DialogOption dialogOption = null;
            if (bl && !SharingSettings.SEED_FINISHED_TORRENTS.getValue()) {
                String string = bTDownloadArray.length > 1 ? "One of the transfers is complete and resuming will cause it to start seeding" : "This transfer is already complete, resuming it will cause it to start seeding";
                String string2 = "Do you want to enable torrent seeding?";
                dialogOption = GUIMediator.showYesNoMessage(I18n.tr(string + "\n\n" + string2), DialogOption.YES);
                n = dialogOption.equals((Object)DialogOption.YES) ? 1 : 0;
                if (n != 0) {
                    SharingSettings.SEED_FINISHED_TORRENTS.setValue(true);
                }
            }
            if (n != 0) {
                for (int i = 0; i < bTDownloadArray.length; ++i) {
                    bTDownloadArray[i].resume();
                }
            }
        }
    }

    private static class ShowInLibraryAction
    extends RefreshingAction {
        private static final long serialVersionUID = -4648558721588938475L;

        public ShowInLibraryAction() {
            this.putValue("Name", I18n.tr("Show"));
            this.putValue("LimeShortName", I18n.tr("Show"));
            this.putValue("ShortDescription", I18n.tr("Shows the contents of this transfer in the Library Tab"));
            this.putValue("LimeIconName", "LIBRARY_TAB");
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            if (bTDownloadArray.length > 0) {
                String string = bTDownloadArray[0].getDisplayName();
                if (string == null) {
                    return;
                }
                LibraryMediator.instance().getLibrarySearch().searchFor(string.replace("_", " ").replace("-", " ").replace(".", " "));
            }
        }
    }

    private static class ExploreAction
    extends RefreshingAction {
        private static final long serialVersionUID = -4648558721588938475L;

        public ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void performAction(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            if (bTDownloadArray.length > 0) {
                File file = bTDownloadArray[0].getSaveLocation();
                if (file == null) {
                    return;
                }
                GUIMediator.launchExplorer(file);
            }
        }
    }

    private static class ShowDetailsAction
    extends RefreshingAction {
        private static final long serialVersionUID = 6100070262538050091L;

        public ShowDetailsAction() {
            this.putValue("Name", I18n.tr("Details"));
            this.putValue("LimeShortName", I18n.tr("Show Details"));
            this.putValue("ShortDescription", I18n.tr("Show Torrent Details"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        protected void performAction(ActionEvent actionEvent) {
            System.out.println("Pending implementation");
        }
    }

    private static abstract class RefreshingAction
    extends AbstractAction {
        private static final long serialVersionUID = -937688457597255711L;

        private RefreshingAction() {
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.performAction(actionEvent);
            BTDownloadMediator.instance().doRefresh();
        }

        protected abstract void performAction(ActionEvent var1);
    }

    private static class SendBTDownloaderAudioFilesToiTunes
    extends AbstractAction {
        private static final long serialVersionUID = 8230574519252660781L;

        public SendBTDownloaderAudioFilesToiTunes() {
            this.putValue("Name", I18n.tr("Send to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Send files to iTunes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedDownloaders();
            if (bTDownloadArray != null && bTDownloadArray.length > 0) {
                try {
                    System.out.println("Sending to iTunes " + bTDownloadArray[0].getSaveLocation());
                    iTunesMediator.instance().scanForSongs(bTDownloadArray[0].getSaveLocation());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

