/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.AzureusStarter;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadImpl;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.DuplicateDownload;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.LibraryMediator;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.limewire.util.OSUtils;

public class BTDownloadCreator {
    private final GlobalManager _globalManager = AzureusStarter.getAzureusCore().getGlobalManager();
    private final File _torrentFile;
    private final File _saveDir;
    private final boolean _initialSeed;
    private boolean[] _filesSelection;
    private DownloadManager _downloadManager;
    private boolean _torrentInGlobalManager;
    private boolean createDownload;
    private TOTorrent torrent;

    public BTDownloadCreator(File file, File file2, boolean bl, boolean[] blArray) throws TOTorrentException {
        this._torrentFile = file;
        this._saveDir = file2;
        this._initialSeed = bl;
        this._filesSelection = blArray;
        File file3 = file2 = this._saveDir == null ? SharingSettings.TORRENT_DATA_DIR_SETTING.getValue() : this._saveDir;
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.torrent = TorrentUtils.readFromFile(this._torrentFile, false);
        this.createDownload = true;
        this._downloadManager = this._globalManager.getDownloadManager(this.torrent);
        if (this._downloadManager == null) {
            if (this._filesSelection == null) {
                this._downloadManager = this._globalManager.addDownloadManager(this._torrentFile.getAbsolutePath(), null, file2.getAbsolutePath(), 0, true, this._initialSeed, null);
            } else {
                this.addPartialDownload(file2);
            }
            this._torrentInGlobalManager = false;
        } else {
            this._torrentInGlobalManager = true;
            if (this._filesSelection != null) {
                boolean[] blArray2 = this.getPreviousFileSelections(this._downloadManager);
                if (blArray2.length != this._filesSelection.length) {
                    System.out.println("BTDownloadCreator::constructor warning: inconsistency between file selection count, from old state to new state. Is this the same torrent?");
                    return;
                }
                if (this.isDownloadingEntireContents(blArray2)) {
                    return;
                }
                for (int i = 0; i < this._filesSelection.length; ++i) {
                    if (!blArray2[i]) continue;
                    this._filesSelection[i] = true;
                }
            } else {
                boolean[] blArray3 = this.getPreviousFileSelections(this._downloadManager);
                if (this.isDownloadingEntireContents(blArray3)) {
                    this.createDownload = false;
                    return;
                }
                this._filesSelection = blArray3;
                for (int i = 0; i < this._filesSelection.length; ++i) {
                    this._filesSelection[i] = true;
                }
            }
            TorrentUtil.removeDownload(this._downloadManager, false, false, false);
            this.addPartialDownload(file2);
        }
    }

    public void addPartialDownload(File file) throws TOTorrentException {
        this._downloadManager = this._globalManager.addDownloadManager(this._torrentFile.getAbsolutePath(), this.torrent.getHash(), file.getAbsolutePath(), null, 0, true, false, new DownloadManagerInitialisationAdapter(){

            @Override
            public void initialised(DownloadManager downloadManager) {
                BTDownloadCreator.this.setupPartialDownload(downloadManager);
            }
        });
    }

    private boolean isDownloadingEntireContents(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            return false;
        }
        return true;
    }

    private boolean[] getPreviousFileSelections(DownloadManager downloadManager) {
        boolean[] blArray = new boolean[downloadManager.getDiskManagerFileInfoSet().getFiles().length];
        for (int i = 0; i < downloadManager.getDiskManagerFileInfoSet().getFiles().length; ++i) {
            blArray[i] = !downloadManager.getDiskManagerFileInfoSet().getFiles()[i].isSkipped();
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPartialDownload(DownloadManager downloadManager) {
        DiskManagerFileInfo[] diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfoSet().getFiles();
        try {
            downloadManager.getDownloadState().suppressStateSave(true);
            boolean[] blArray = new boolean[diskManagerFileInfoArray.length];
            boolean[] blArray2 = new boolean[diskManagerFileInfoArray.length];
            int n = 0;
            for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
                DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
                File file = diskManagerFileInfo.getFile(true);
                if (this._filesSelection[i]) continue;
                blArray[i] = true;
                if (file.exists()) continue;
                blArray2[i] = true;
                ++n;
            }
            if (n > 0) {
                downloadManager.getDiskManagerFileInfoSet().setStorageTypes(blArray2, 2);
            }
            downloadManager.getDiskManagerFileInfoSet().setSkipped(blArray, true);
        }
        finally {
            downloadManager.getDownloadState().suppressStateSave(false);
        }
    }

    public BTDownloadCreator(File file, boolean[] blArray) throws TOTorrentException {
        this(file, null, false, blArray);
    }

    public BTDownload createDownload() throws SaveLocationException, TOTorrentException {
        if (this._torrentInGlobalManager) {
            if (this.createDownload) {
                return new DuplicateDownload(BTDownloadCreator.createDownload(this._downloadManager, false));
            }
            return new DuplicateDownload(new BTDownloadImpl(this._downloadManager));
        }
        return BTDownloadCreator.createDownload(this._downloadManager, false);
    }

    public static BTDownload createDownload(DownloadManager downloadManager, final boolean bl) throws SaveLocationException, TOTorrentException {
        downloadManager.addListener(new DownloadManagerAdapter(){

            @Override
            public void stateChanged(DownloadManager downloadManager, int n) {
                if (n == 40) {
                    downloadManager.startDownload();
                }
                if (!SharingSettings.SEED_FINISHED_TORRENTS.getValue() && downloadManager.getAssumedComplete() && TorrentUtil.isStopable(downloadManager)) {
                    TorrentUtil.stop(downloadManager);
                }
                if (downloadManager.getAssumedComplete() && iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && !iTunesMediator.instance().isScanned(downloadManager.getSaveLocation()) && (OSUtils.isMacOSX() || OSUtils.isWindows())) {
                    iTunesMediator.instance().scanForSongs(downloadManager.getSaveLocation());
                }
                if (downloadManager.getAssumedComplete() && !LibraryMediator.instance().isScanned(downloadManager.hashCode())) {
                    LibraryMediator.instance().scan(downloadManager.hashCode(), downloadManager.getSaveLocation());
                }
                if (bl && n == 60) {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BTDownloadMediator.instance().updateTableFilters();
                        }
                    });
                }
            }
        });
        if (downloadManager.getState() != 70) {
            downloadManager.initialize();
        }
        return new BTDownloadImpl(downloadManager);
    }
}

