/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.SoundcloudTrackDownload;
import com.frostwire.gui.bittorrent.YouTubeItemDownload;
import com.frostwire.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.SeedsHolder;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.limewire.util.OSUtils;

final class BTDownloadDataLine
extends AbstractDataLine<BTDownload> {
    private static final String PARTIAL_DOWNLOAD_TEXT = I18n.tr(" (Partial)");
    private String _status;
    private long _download = 0L;
    private long _upload;
    private int _progress;
    private long _size = -1L;
    private double _downloadSpeed;
    private double _uploadSpeed;
    private long _timeLeft;
    private String _seeds;
    private String _peers;
    private String _shareRatio;
    private String _seedToPeerRatio;
    private Date dateCreated;
    private boolean _notification;
    static final int FILE_INDEX = 0;
    private static final LimeTableColumn FILE_COLUMN = new LimeTableColumn(0, "DOWNLOAD_NAME_COLUMN", I18n.tr("Name"), 201, true, IconAndNameHolder.class);
    static final int SIZE_INDEX = 1;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(1, "DOWNLOAD_SIZE_COLUMN", I18n.tr("Size"), 65, true, SizeHolder.class);
    static final int STATUS_INDEX = 2;
    private static final LimeTableColumn STATUS_COLUMN = new LimeTableColumn(2, "DOWNLOAD_STATUS_COLUMN", I18n.tr("Status"), 152, true, String.class);
    static final int PROGRESS_INDEX = 3;
    private static final LimeTableColumn PROGRESS_COLUMN = new LimeTableColumn(3, "DOWNLOAD_PROGRESS_COLUMN", I18n.tr("Progress"), 71, true, ProgressBarHolder.class);
    static final int BYTES_DOWNLOADED_INDEX = 4;
    private static final LimeTableColumn BYTES_DOWNLOADED_COLUMN = new LimeTableColumn(4, "DOWNLOAD_BYTES_DOWNLOADED_COLUMN", I18n.tr("Downloaded"), 20, true, SizeHolder.class);
    static final int BYTES_UPLOADED_INDEX = 5;
    private static final LimeTableColumn BYTES_UPLOADED_COLUMN = new LimeTableColumn(5, "DOWNLOAD_BYTES_UPLOADED_COLUMN", I18n.tr("Uploaded"), 20, false, SizeHolder.class);
    static final int DOWNLOAD_SPEED_INDEX = 6;
    private static final LimeTableColumn DOWNLOAD_SPEED_COLUMN = new LimeTableColumn(6, "DOWNLOAD_SPEED_COLUMN", I18n.tr("Down Speed"), 58, true, SpeedRenderer.class);
    static final int UPLOAD_SPEED_INDEX = 7;
    private static final LimeTableColumn UPLOAD_SPEED_COLUMN = new LimeTableColumn(7, "UPLOAD_SPEED_COLUMN", I18n.tr("Up Speed"), 58, true, SpeedRenderer.class);
    static final int TIME_INDEX = 8;
    private static final LimeTableColumn TIME_COLUMN = new LimeTableColumn(8, "DOWNLOAD_TIME_REMAINING_COLUMN", I18n.tr("Time"), 49, true, TimeRemainingHolder.class);
    static final int SEEDS_INDEX = 9;
    private static final LimeTableColumn SEEDS_COLUMN = new LimeTableColumn(9, "SEEDS_STATUS_COLUMN", I18n.tr("Seeds"), 80, true, String.class);
    static final int PEERS_INDEX = 10;
    private static final LimeTableColumn PEERS_COLUMN = new LimeTableColumn(10, "PEERS_STATUS_COLUMN", I18n.tr("Peers"), 80, false, String.class);
    static final int SHARE_RATIO_INDEX = 11;
    private static final LimeTableColumn SHARE_RATIO_COLUMN = new LimeTableColumn(11, "SHARE_RATIO_COLUMN", I18n.tr("Share Ratio"), 80, false, String.class);
    static final int SEED_TO_PEER_RATIO_INDEX = 12;
    private static final LimeTableColumn SEED_TO_PEER_RATIO_COLUMN = new LimeTableColumn(12, "SEED_TO_PEER_RATIO_COLUMN", I18n.tr("Seeds/Peers"), 80, false, String.class);
    static final int DATE_CREATED_INDEX = 13;
    static final LimeTableColumn DATE_CREATED_COLUMN = new LimeTableColumn(13, "DATE_CREATED_COLUMN", I18n.tr("Started On"), 80, false, Date.class);
    static final int NUMBER_OF_COLUMNS = 14;

    BTDownloadDataLine() {
    }

    @Override
    public int getColumnCount() {
        return 14;
    }

    @Override
    public void initialize(BTDownload bTDownload) {
        super.initialize(bTDownload);
        this._notification = bTDownload.isCompleted();
        this.update();
    }

    public boolean isSeeding() {
        if (this.initializer == null) {
            return false;
        }
        return ((BTDownload)this.initializer).getState() == 60;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return new IconAndNameHolderImpl(this.getIcon(), ((BTDownload)this.initializer).getDisplayName());
            }
            case 1: {
                if (((BTDownload)this.initializer).isPartialDownload()) {
                    return new SizeHolder(this._size, PARTIAL_DOWNLOAD_TEXT);
                }
                return new SizeHolder(this._size);
            }
            case 2: {
                return this._status;
            }
            case 3: {
                return this._progress;
            }
            case 4: {
                return new SizeHolder(this._download);
            }
            case 5: {
                return new SizeHolder(this._upload);
            }
            case 6: {
                return new Double(this._downloadSpeed);
            }
            case 7: {
                return new Double(this._uploadSpeed);
            }
            case 8: {
                if (((BTDownload)this.initializer).isCompleted()) {
                    return new TimeRemainingHolder(0L);
                }
                if (this._downloadSpeed < 0.001) {
                    return new TimeRemainingHolder(-1L);
                }
                return new TimeRemainingHolder(this._timeLeft);
            }
            case 9: {
                return new SeedsHolder(this._seeds);
            }
            case 10: {
                return this._peers;
            }
            case 11: {
                return this._shareRatio;
            }
            case 12: {
                return this._seedToPeerRatio;
            }
            case 13: {
                return this.dateCreated;
            }
        }
        return null;
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        switch (n) {
            case 0: {
                return FILE_COLUMN;
            }
            case 1: {
                return SIZE_COLUMN;
            }
            case 2: {
                return STATUS_COLUMN;
            }
            case 3: {
                return PROGRESS_COLUMN;
            }
            case 4: {
                return BYTES_DOWNLOADED_COLUMN;
            }
            case 5: {
                return BYTES_UPLOADED_COLUMN;
            }
            case 6: {
                return DOWNLOAD_SPEED_COLUMN;
            }
            case 7: {
                return UPLOAD_SPEED_COLUMN;
            }
            case 8: {
                return TIME_COLUMN;
            }
            case 9: {
                return SEEDS_COLUMN;
            }
            case 10: {
                return PEERS_COLUMN;
            }
            case 11: {
                return SHARE_RATIO_COLUMN;
            }
            case 12: {
                return SEED_TO_PEER_RATIO_COLUMN;
            }
            case 13: {
                return DATE_CREATED_COLUMN;
            }
        }
        return null;
    }

    static LimeTableColumn staticGetColumn(int n) {
        switch (n) {
            case 0: {
                return FILE_COLUMN;
            }
            case 1: {
                return SIZE_COLUMN;
            }
            case 2: {
                return STATUS_COLUMN;
            }
            case 3: {
                return PROGRESS_COLUMN;
            }
            case 4: {
                return BYTES_DOWNLOADED_COLUMN;
            }
            case 5: {
                return BYTES_UPLOADED_COLUMN;
            }
            case 6: {
                return DOWNLOAD_SPEED_COLUMN;
            }
            case 7: {
                return UPLOAD_SPEED_COLUMN;
            }
            case 8: {
                return TIME_COLUMN;
            }
            case 9: {
                return SEEDS_COLUMN;
            }
            case 10: {
                return PEERS_COLUMN;
            }
            case 11: {
                return SHARE_RATIO_COLUMN;
            }
            case 12: {
                return SEED_TO_PEER_RATIO_COLUMN;
            }
            case 13: {
                return DATE_CREATED_COLUMN;
            }
        }
        return null;
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }

    @Override
    public String[] getToolTipArray(int n) {
        String[] stringArray = new String[11];
        String string = ((BTDownload)this.getInitializeObject()).getDisplayName();
        String string2 = I18n.tr("Status") + ": " + ((BTDownload)this.getInitializeObject()).getStateString();
        String string3 = I18n.tr("Progress") + ": " + ((BTDownload)this.getInitializeObject()).getProgress() + "%";
        String string4 = I18n.tr("Down Speed") + ": " + GUIUtils.rate2speed(((BTDownload)this.getInitializeObject()).getDownloadSpeed());
        String string5 = I18n.tr("Up Speed") + ": " + GUIUtils.rate2speed(((BTDownload)this.getInitializeObject()).getUploadSpeed());
        String string6 = I18n.tr("Downloaded") + ": " + new SizeHolder(((BTDownload)this.getInitializeObject()).getBytesReceived());
        String string7 = I18n.tr("Uploaded") + ": " + new SizeHolder(((BTDownload)this.getInitializeObject()).getBytesSent());
        String string8 = I18n.tr("Peers") + ": " + ((BTDownload)this.getInitializeObject()).getPeersString();
        String string9 = I18n.tr("Seeds") + ": " + ((BTDownload)this.getInitializeObject()).getSeedsString();
        String string10 = I18n.tr("Size") + ": " + new SizeHolder(((BTDownload)this.getInitializeObject()).getSize());
        String string11 = I18n.tr("ETA") + ": " + (((BTDownload)this.getInitializeObject()).isCompleted() ? new TimeRemainingHolder(0L) : (((BTDownload)this.getInitializeObject()).getDownloadSpeed() < 0.001 ? new TimeRemainingHolder(-1L) : new TimeRemainingHolder(((BTDownload)this.getInitializeObject()).getETA())));
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
        stringArray[3] = string4;
        stringArray[4] = string5;
        stringArray[5] = string6;
        stringArray[6] = string7;
        stringArray[7] = string8;
        stringArray[8] = string9;
        stringArray[9] = string10;
        stringArray[10] = string11;
        return stringArray;
    }

    private Icon getIcon() {
        if (((BTDownload)this.initializer).isPartialDownload()) {
            try {
                return IconManager.instance().getIconForFile(new File(((BTDownload)this.initializer).getDisplayName()));
            }
            catch (Exception exception) {
                return IconManager.instance().getIconForFile(((BTDownload)this.initializer).getSaveLocation());
            }
        }
        if (this.initializer instanceof YouTubeItemDownload || this.initializer instanceof SoundcloudTrackDownload) {
            return IconManager.instance().getIconForFile(new File(((BTDownload)this.initializer).getDisplayName()));
        }
        return IconManager.instance().getIconForFile(((BTDownload)this.initializer).getSaveLocation());
    }

    @Override
    public void update() {
        this._status = ((BTDownload)this.initializer).getStateString();
        this._progress = ((BTDownload)this.initializer).getProgress();
        this._download = ((BTDownload)this.initializer).getBytesReceived();
        this._upload = ((BTDownload)this.initializer).getBytesSent();
        this._downloadSpeed = ((BTDownload)this.initializer).getDownloadSpeed();
        this._uploadSpeed = ((BTDownload)this.initializer).getUploadSpeed();
        this._timeLeft = ((BTDownload)this.initializer).getETA();
        this._seeds = ((BTDownload)this.initializer).getSeedsString();
        this._peers = ((BTDownload)this.initializer).getPeersString();
        this._shareRatio = ((BTDownload)this.initializer).getShareRatio();
        this._seedToPeerRatio = ((BTDownload)this.initializer).getSeedToPeerRatio();
        this._size = ((BTDownload)this.initializer).getSize();
        this.dateCreated = ((BTDownload)this.initializer).getDateCreated();
        if (((BTDownload)this.getInitializeObject()).isCompleted()) {
            this.showNotification();
        }
    }

    private void showNotification() {
        if (!this._notification) {
            File file;
            Action[] actionArray;
            this._notification = true;
            Notification notification = null;
            BTDownload bTDownload = (BTDownload)this.getInitializeObject();
            if (bTDownload.isCompleted()) {
                actionArray = null;
                file = ((BTDownload)this.getInitializeObject()).getSaveLocation();
                if (file != null) {
                    actionArray = new Action[]{new LaunchAction(file), new ShowInLibraryAction(file)};
                }
            } else {
                return;
            }
            notification = new Notification(bTDownload.getDisplayName(), this.getIcon(), actionArray);
            LibraryMediator.instance().getLibraryExplorer().clearDirectoryHolderCaches();
            this.iTunesScanIfNecessaryForNonTorrentDownloadItem(bTDownload, file);
            if (notification != null) {
                NotifyUserProxy.instance().showMessage(notification);
            }
        }
    }

    private void iTunesScanIfNecessaryForNonTorrentDownloadItem(BTDownload bTDownload, File file) {
        if ((OSUtils.isMacOSX() || OSUtils.isWindows()) && (bTDownload instanceof YouTubeItemDownload || bTDownload instanceof SoundcloudTrackDownload) && iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && !iTunesMediator.instance().isScanned(file)) {
            iTunesMediator.instance().scanForSongs(file);
        }
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    @Override
    public boolean isClippable(int n) {
        return false;
    }

    private final class ShowInLibraryAction
    extends AbstractAction {
        private static final long serialVersionUID = -6177511216279954853L;
        private File file;

        public ShowInLibraryAction(File file) {
            this.file = file;
            this.putValue("Name", I18n.tr("Show in Library"));
            this.putValue("ShortDescription", I18n.tr("Show Download in Library"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
            LibraryMediator.instance().setSelectedFile(this.file);
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        private static final long serialVersionUID = 4020797972200661119L;
        private File file;

        public LaunchAction(File file) {
            this.file = file;
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIUtils.launchOrEnqueueFile(this.file, false);
        }
    }
}

