/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.TorrentUtil;
import java.io.File;
import java.util.Date;
import java.util.Set;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.DisplayFormatters;

public class BTDownloadImpl
implements BTDownload {
    private DownloadManager _downloadManager;
    private boolean _partialDownload;
    private long _size;
    private Set<DiskManagerFileInfo> _fileInfoSet;
    private String _hash;
    private boolean _deleteTorrentWhenRemove;
    private boolean _deleteDataWhenRemove;
    private String _displayName;

    public BTDownloadImpl(DownloadManager downloadManager) {
        this.updateDownloadManager(downloadManager);
        this._deleteTorrentWhenRemove = false;
        this._deleteDataWhenRemove = false;
    }

    public void updateSize(DownloadManager downloadManager) {
        if (this._partialDownload) {
            this._fileInfoSet = TorrentUtil.getNoSkippedFileInfoSet(downloadManager);
            if (this._fileInfoSet.isEmpty()) {
                this._size = downloadManager.getSize();
            } else {
                long l = 0L;
                for (DiskManagerFileInfo diskManagerFileInfo : this._fileInfoSet) {
                    l += diskManagerFileInfo.getLength();
                }
                this._size = l;
            }
        } else {
            this._fileInfoSet = null;
            this._size = downloadManager.getSize();
        }
    }

    @Override
    public long getSize() {
        return this.getSize(false);
    }

    @Override
    public long getSize(boolean bl) {
        if (bl) {
            this.updateSize(this._downloadManager);
        }
        return this._size;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public boolean isResumable() {
        return TorrentUtil.isStartable(this._downloadManager);
    }

    @Override
    public boolean isPausable() {
        return TorrentUtil.isStopable(this._downloadManager);
    }

    @Override
    public boolean isCompleted() {
        return this._downloadManager.getAssumedComplete();
    }

    @Override
    public int getState() {
        return this._downloadManager.getState();
    }

    @Override
    public void remove() {
        TorrentUtil.removeDownload(this._downloadManager, this._deleteTorrentWhenRemove, this._deleteDataWhenRemove);
    }

    @Override
    public void pause() {
        if (this.isPausable()) {
            TorrentUtil.stop(this._downloadManager);
        }
    }

    @Override
    public void resume() {
        if (this.isResumable()) {
            TorrentUtil.start(this._downloadManager);
        }
    }

    @Override
    public File getSaveLocation() {
        return this._downloadManager.getSaveLocation();
    }

    @Override
    public int getProgress() {
        if (this._partialDownload) {
            long l = 0L;
            for (DiskManagerFileInfo diskManagerFileInfo : this._fileInfoSet) {
                l += diskManagerFileInfo.getDownloaded();
            }
            return (int)(l * 100L / this._size);
        }
        return this._downloadManager.getStats().getDownloadCompleted(true) / 10;
    }

    @Override
    public String getStateString() {
        return DisplayFormatters.formatDownloadStatus(this._downloadManager);
    }

    @Override
    public long getBytesReceived() {
        return this._downloadManager.getStats().getTotalGoodDataBytesReceived();
    }

    @Override
    public long getBytesSent() {
        return this._downloadManager.getStats().getTotalDataBytesSent();
    }

    @Override
    public double getDownloadSpeed() {
        return this._downloadManager.getStats().getDataReceiveRate() / 1000L;
    }

    @Override
    public double getUploadSpeed() {
        return this._downloadManager.getStats().getDataSendRate() / 1000L;
    }

    @Override
    public long getETA() {
        return this._downloadManager.getStats().getETA();
    }

    @Override
    public DownloadManager getDownloadManager() {
        return this._downloadManager;
    }

    @Override
    public String getPeersString() {
        boolean bl;
        int n;
        DownloadManager downloadManager;
        long l;
        long l2 = -1L;
        long l3 = 0L;
        if (this._downloadManager != null) {
            TRTrackerScraperResponse tRTrackerScraperResponse;
            l3 = this._downloadManager.getNbPeers();
            if (l2 == -1L && (tRTrackerScraperResponse = this._downloadManager.getTrackerScrapeResponse()) != null && tRTrackerScraperResponse.isValid()) {
                l2 = tRTrackerScraperResponse.getPeers();
            }
        }
        if ((l = l2) <= 0L && (downloadManager = this._downloadManager) != null) {
            l = downloadManager.getActivationCount();
        }
        boolean bl2 = (n = this._downloadManager.getState()) == 60 || n == 50;
        boolean bl3 = bl = l2 >= 0L;
        String string = bl2 ? (bl ? (l3 > l2 ? "%1" : "%1 / %2") : "%1") : (bl ? "%2" : "");
        string = string.replaceAll("%1", String.valueOf(l3));
        string = string.replaceAll("%2", String.valueOf(l));
        return string;
    }

    @Override
    public String getSeedsString() {
        boolean bl;
        int n;
        long l = -1L;
        long l2 = 0L;
        DownloadManager downloadManager = this._downloadManager;
        if (downloadManager != null) {
            TRTrackerScraperResponse tRTrackerScraperResponse;
            l2 = downloadManager.getNbSeeds();
            if (l == -1L && (tRTrackerScraperResponse = downloadManager.getTrackerScrapeResponse()) != null && tRTrackerScraperResponse.isValid()) {
                l = tRTrackerScraperResponse.getSeeds();
            }
        }
        boolean bl2 = (n = downloadManager.getState()) == 60 || n == 50;
        boolean bl3 = bl = l >= 0L;
        String string = bl2 ? (bl ? (l2 > l ? "%1" : "%1 / %2") : "%1") : (bl ? "%2" : "");
        string = string.replaceAll("%1", String.valueOf(l2));
        String string2 = "?";
        if (l != -1L) {
            string2 = String.valueOf(l);
        }
        string = string.replaceAll("%2", string2);
        return string;
    }

    @Override
    public boolean isDeleteTorrentWhenRemove() {
        return this._deleteTorrentWhenRemove;
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean bl) {
        this._deleteTorrentWhenRemove = bl;
    }

    @Override
    public boolean isDeleteDataWhenRemove() {
        return this._deleteDataWhenRemove;
    }

    @Override
    public void setDeleteDataWhenRemove(boolean bl) {
        this._deleteDataWhenRemove = bl;
    }

    @Override
    public String getHash() {
        return this._hash;
    }

    @Override
    public String getSeedToPeerRatio() {
        float f = -1.0f;
        DownloadManager downloadManager = this._downloadManager;
        if (downloadManager != null) {
            int n;
            int n2;
            TRTrackerScraperResponse tRTrackerScraperResponse = downloadManager.getTrackerScrapeResponse();
            if (tRTrackerScraperResponse != null && tRTrackerScraperResponse.isValid()) {
                n2 = Math.max(downloadManager.getNbSeeds(), tRTrackerScraperResponse.getSeeds());
                int n3 = tRTrackerScraperResponse.getPeers();
                n = downloadManager.getNbPeers();
                if (n == 0 || n3 > n) {
                    n = n3 <= 0 ? downloadManager.getActivationCount() : n3;
                }
            } else {
                n2 = downloadManager.getNbSeeds();
                n = downloadManager.getNbPeers();
            }
            f = n < 0 || n2 < 0 ? 0.0f : (n == 0 ? (n2 == 0 ? 0.0f : Float.POSITIVE_INFINITY) : (float)n2 / (float)n);
        }
        if (f == -1.0f) {
            return "";
        }
        if (f == 0.0f) {
            return "??";
        }
        return DisplayFormatters.formatDecimal(f, 3);
    }

    @Override
    public String getShareRatio() {
        try {
            int n;
            DownloadManager downloadManager = this._downloadManager;
            DownloadManagerStats downloadManagerStats = downloadManager.getStats();
            int n2 = n = downloadManager == null ? 0 : downloadManagerStats.getShareRatio();
            if (n == Integer.MAX_VALUE) {
                n = 0x7FFFFFFE;
            }
            if (n == -1) {
                long l = downloadManagerStats.getTotalGoodDataBytesReceived();
                long l2 = downloadManagerStats.getTotalDataBytesSent();
                n = l == 0L && l2 > 0L ? (int)(1000L * l2 / downloadManager.getDiskManager().getTotalLength()) : Integer.MAX_VALUE;
            }
            String string = "";
            string = n == Integer.MAX_VALUE ? "\u221e" : DisplayFormatters.formatDecimal((double)n / 1000.0, 3);
            return string;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public Date getDateCreated() {
        return new Date(this._downloadManager.getCreationTime());
    }

    @Override
    public boolean isPartialDownload() {
        return this._partialDownload;
    }

    @Override
    public void updateDownloadManager(DownloadManager downloadManager) {
        this._downloadManager = downloadManager;
        this._partialDownload = TorrentUtil.getSkippedFiles(downloadManager).size() > 0;
        this.updateSize(downloadManager);
        this.updateName(downloadManager);
        try {
            this._hash = TorrentUtil.hashToString(downloadManager.getTorrent().getHash());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._hash = "";
        }
    }

    private void updateName(DownloadManager downloadManager) {
        this._displayName = TorrentUtil.getNoSkippedFileInfoSet(downloadManager).size() == 1 ? TorrentUtil.getNoSkippedFileInfoSet(downloadManager).toArray(new DiskManagerFileInfo[0])[0].getFile(false).getName() : this._downloadManager.getDisplayName();
    }
}

