/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.frostwire.AzureusStarter;
import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadActions;
import com.frostwire.gui.bittorrent.BTDownloadButtons;
import com.frostwire.gui.bittorrent.BTDownloadCreator;
import com.frostwire.gui.bittorrent.BTDownloadDataLine;
import com.frostwire.gui.bittorrent.BTDownloadMediatorAdvancedMenuFactory;
import com.frostwire.gui.bittorrent.BTDownloadRowFilteredModel;
import com.frostwire.gui.bittorrent.BTDownloadTransferHandler;
import com.frostwire.gui.bittorrent.DuplicateDownload;
import com.frostwire.gui.bittorrent.PartialFilesDialog;
import com.frostwire.gui.bittorrent.SoundcloudTrackDownload;
import com.frostwire.gui.bittorrent.SoundcloudTrackUrlDownload;
import com.frostwire.gui.bittorrent.TorrentFetcherDownload;
import com.frostwire.gui.bittorrent.YouTubeItemDownload;
import com.frostwire.gui.bittorrent.YouTubeVideoUrlDownload;
import com.frostwire.gui.filters.TableLineFilter;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.BittorrentSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.TablesHandlerSettings;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import jd.controlling.downloadcontroller.DownloadController;
import jd.plugins.FilePackage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.limewire.util.FilenameUtils;
import org.limewire.util.OSUtils;

public final class BTDownloadMediator
extends AbstractTableMediator<BTDownloadRowFilteredModel, BTDownloadDataLine, BTDownload> {
    private static final Log LOG = LogFactory.getLog(BTDownloadMediator.class);
    public static final int MIN_HEIGHT = 150;
    private static BTDownloadMediator INSTANCE;
    private Action removeAction;
    private Action removeYouTubeAction;
    private Action resumeAction;
    private Action pauseAction;
    private Action exploreAction;
    private Action copyMagnetAction;
    private Action copyHashAction;
    private Action shareTorrentAction;
    private Action showInLibraryAction;
    private BTDownloadButtons _downloadButtons;
    private SeedingFilter _seedingFilter;
    private Action sendToItunesAction;
    private BTDownloadActions.PlaySingleAudioFileAction playSingleAudioFileAction;

    public static BTDownloadMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new BTDownloadMediator();
        }
        return INSTANCE;
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            @Override
            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new BTDownloadTransferHandler());
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.removeAction = BTDownloadActions.REMOVE_ACTION;
        this.removeYouTubeAction = BTDownloadActions.REMOVE_YOUTUBE_ACTION;
        this.resumeAction = BTDownloadActions.RESUME_ACTION;
        this.pauseAction = BTDownloadActions.PAUSE_ACTION;
        this.exploreAction = BTDownloadActions.EXPLORE_ACTION;
        this.showInLibraryAction = BTDownloadActions.SHOW_IN_LIBRARY_ACTION;
        this.copyMagnetAction = BTDownloadActions.COPY_MAGNET_ACTION;
        this.copyHashAction = BTDownloadActions.COPY_HASH_ACTION;
        this.shareTorrentAction = BTDownloadActions.SHARE_TORRENT_ACTION;
        this.sendToItunesAction = BTDownloadActions.SEND_TO_ITUNES_ACTION;
        this.playSingleAudioFileAction = BTDownloadActions.PLAY_SINGLE_AUDIO_FILE_ACTION;
    }

    public Action[] getActions() {
        Action[] actionArray = OSUtils.isWindows() || OSUtils.isMacOSX() ? new Action[]{this.resumeAction, this.pauseAction, this.showInLibraryAction, this.exploreAction, this.removeAction} : new Action[]{this.resumeAction, this.pauseAction, this.removeAction};
        return actionArray;
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(I18n.tr("Transfers"));
        this._seedingFilter = new SeedingFilter();
        this.DATA_MODEL = new BTDownloadRowFilteredModel(this._seedingFilter);
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this._downloadButtons = new BTDownloadButtons(this);
        this.BUTTON_ROW = this._downloadButtons.getComponent();
        this.updateTableFilters();
    }

    public void updateTableFilters() {
        if (this.TABLE == null || this.DATA_MODEL == null) {
            return;
        }
        ((BTDownloadRowFilteredModel)this.DATA_MODEL).filtersChanged();
    }

    boolean filterChanged() {
        int n;
        int[] nArray = this.TABLE.getSelectedRows();
        BTDownloadDataLine[] bTDownloadDataLineArray = new BTDownloadDataLine[nArray.length];
        LinkedList<BTDownloadDataLine> linkedList = new LinkedList<BTDownloadDataLine>();
        for (n = 0; n < nArray.length; ++n) {
            BTDownloadDataLine bTDownloadDataLine;
            int n2 = nArray[n];
            bTDownloadDataLineArray[n] = bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(n2);
            if (!this.TABLE.isRowVisible(n2)) continue;
            linkedList.add(bTDownloadDataLine);
        }
        ((BTDownloadRowFilteredModel)this.DATA_MODEL).filtersChanged();
        for (n = 0; n < nArray.length; ++n) {
            BTDownloadDataLine bTDownloadDataLine = bTDownloadDataLineArray[n];
            int n3 = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRow(bTDownloadDataLine);
            if (n3 == -1) continue;
            this.TABLE.addRowSelectionInterval(n3, n3);
            if (linkedList == null || !linkedList.contains(bTDownloadDataLine)) continue;
            this.TABLE.ensureRowVisible(n3);
            linkedList = null;
        }
        return true;
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Download Window..."));
    }

    private BTDownloadMediator() {
        super("DOWNLOAD_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        this.restoreSorting();
    }

    @Override
    public void doRefresh() {
        ((BTDownloadRowFilteredModel)this.DATA_MODEL).refresh();
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length > 0) {
            BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(nArray[0]);
            BTDownload bTDownload = (BTDownload)bTDownloadDataLine.getInitializeObject();
            boolean bl = bTDownload.isResumable();
            boolean bl2 = bTDownload.isPausable();
            boolean bl3 = bTDownload.isCompleted();
            this.resumeAction.setEnabled(bl);
            this.pauseAction.setEnabled(bl2);
            this.exploreAction.setEnabled(bl3);
            this.showInLibraryAction.setEnabled(bl3);
        }
    }

    public int getActiveDownloads() {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).getActiveDownloads();
    }

    public int getActiveUploads() {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).getActiveUploads();
    }

    public int getTotalDownloads() {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).getTotalDownloads();
    }

    private double getBandwidth(boolean bl) {
        if (!AzureusStarter.isAzureusCoreStarted()) {
            return 0.0;
        }
        AzureusCore azureusCore = AzureusStarter.getAzureusCore();
        if (azureusCore == null) {
            return 0.0;
        }
        return bl ? (double)azureusCore.getGlobalManager().getStats().getDataReceiveRate() : (double)azureusCore.getGlobalManager().getStats().getDataSendRate();
    }

    public double getDownloadsBandwidth() {
        return this.getBandwidth(true) / 1000.0;
    }

    public double getUploadsBandwidth() {
        return this.getBandwidth(false) / 1000.0;
    }

    @Override
    public void add(BTDownload bTDownload) {
        if (!((BTDownloadRowFilteredModel)this.DATA_MODEL).contains(bTDownload)) {
            super.add(bTDownload, ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount());
            if (((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount() > 0) {
                int n = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRow(bTDownload);
                this.TABLE.setSelectedRow(n);
                this.TABLE.ensureSelectionVisible();
            }
        }
    }

    @Override
    public void remove(BTDownload bTDownload) {
        super.remove(bTDownload);
        bTDownload.remove();
    }

    void launchSelectedDownloads() {
    }

    void pauseSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            ((BTDownload)((BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(nArray[i])).getInitializeObject()).pause();
        }
    }

    void launchExplorer() {
        int[] nArray = this.TABLE.getSelectedRows();
        BTDownload bTDownload = (BTDownload)((BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(nArray[nArray.length - 1])).getInitializeObject();
        File file = bTDownload.getSaveLocation();
        if (file == null) {
            return;
        }
        GUIMediator.launchExplorer(file);
    }

    FileTransfer[] getSelectedFileTransfers() {
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList arrayList = new ArrayList(nArray.length);
        return arrayList.toArray(new FileTransfer[arrayList.size()]);
    }

    public BTDownload[] getSelectedBTDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList arrayList = new ArrayList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(nArray[i]);
            if (!((BTDownload)bTDownloadDataLine.getInitializeObject()).isCompleted()) continue;
            arrayList.add(bTDownloadDataLine.getInitializeObject());
        }
        return arrayList.toArray(new BTDownload[arrayList.size()]);
    }

    void resumeSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(nArray[i]);
            BTDownload bTDownload = (BTDownload)bTDownloadDataLine.getInitializeObject();
            bTDownload.resume();
        }
    }

    @Override
    public void handleActionKey() {
        BTDownload[] bTDownloadArray = this.getSelectedDownloaders();
        if (bTDownloadArray.length == 1) {
            this.playSingleAudioFileAction.setEnabled(this.selectionHasAudioFiles(bTDownloadArray[0]));
        }
        if (this.playSingleAudioFileAction.isEnabled()) {
            this.playSingleAudioFileAction.actionPerformed(null);
        }
        if (this.showInLibraryAction.isEnabled()) {
            this.showInLibraryAction.actionPerformed(null);
        }
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
        if (this.playSingleAudioFileAction.isEnabled()) {
            skinPopupMenu.add(new SkinMenuItem(this.playSingleAudioFileAction));
        }
        skinPopupMenu.add(new SkinMenuItem(this.resumeAction));
        skinPopupMenu.add(new SkinMenuItem(this.pauseAction));
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            skinPopupMenu.add(new SkinMenuItem(this.showInLibraryAction));
            skinPopupMenu.add(new SkinMenuItem(this.exploreAction));
        }
        ((JPopupMenu)skinPopupMenu).addSeparator();
        skinPopupMenu.add(new SkinMenuItem(this.shareTorrentAction));
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            skinPopupMenu.add(new SkinMenuItem(this.sendToItunesAction));
        }
        skinPopupMenu.add(new SkinMenuItem(this.copyMagnetAction));
        skinPopupMenu.add(new SkinMenuItem(this.copyHashAction));
        SkinMenu skinMenu = BTDownloadMediatorAdvancedMenuFactory.createAddToPlaylistSubMenu();
        if (skinMenu != null) {
            skinPopupMenu.add(skinMenu);
        }
        ((JPopupMenu)skinPopupMenu).addSeparator();
        skinPopupMenu.add(new SkinMenuItem(this.removeAction));
        skinPopupMenu.add(new SkinMenuItem(BTDownloadActions.REMOVE_TORRENT_ACTION));
        skinPopupMenu.add(new SkinMenuItem(BTDownloadActions.REMOVE_TORRENT_AND_DATA_ACTION));
        skinPopupMenu.add(new SkinMenuItem(this.removeYouTubeAction));
        ((JPopupMenu)skinPopupMenu).addSeparator();
        skinPopupMenu.add(new SkinMenuItem(BTDownloadActions.TOGGLE_SEEDS_VISIBILITY_ACTION));
        SkinMenu skinMenu2 = BTDownloadMediatorAdvancedMenuFactory.createAdvancedSubMenu();
        if (skinMenu2 != null) {
            ((JPopupMenu)skinPopupMenu).addSeparator();
            skinPopupMenu.add(skinMenu2);
        }
        return skinPopupMenu;
    }

    @Override
    public void handleSelection(int n) {
        BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(n);
        boolean bl = ((BTDownload)bTDownloadDataLine.getInitializeObject()).isPausable();
        boolean bl2 = ((BTDownload)bTDownloadDataLine.getInitializeObject()).isResumable();
        boolean bl3 = ((BTDownload)bTDownloadDataLine.getInitializeObject()).isCompleted();
        File file = ((BTDownload)bTDownloadDataLine.getInitializeObject()).getSaveLocation();
        boolean bl4 = this.selectionHasAudioFiles((BTDownload)bTDownloadDataLine.getInitializeObject());
        boolean bl5 = this.selectionHasMP4s(file);
        boolean bl6 = this.selectionIsSingleFile(file);
        this.removeAction.putValue("Name", I18n.tr("Cancel Download"));
        this.removeAction.putValue("LimeShortName", I18n.tr("Cancel"));
        this.removeAction.putValue("ShortDescription", I18n.tr("Cancel Selected Downloads"));
        BTDownload bTDownload = (BTDownload)bTDownloadDataLine.getInitializeObject();
        this.exploreAction.setEnabled(bTDownload.isCompleted());
        this.showInLibraryAction.setEnabled(bTDownload.isCompleted());
        this.removeAction.setEnabled(true);
        this.resumeAction.setEnabled(bl2);
        this.pauseAction.setEnabled(bl);
        this.copyMagnetAction.setEnabled(!this.isHttpDownload((BTDownload)bTDownloadDataLine.getInitializeObject()));
        this.copyHashAction.setEnabled(!this.isHttpDownload((BTDownload)bTDownloadDataLine.getInitializeObject()));
        this.sendToItunesAction.setEnabled(bl3 && (bl4 || bl5));
        this.shareTorrentAction.setEnabled(this.getSelectedDownloaders().length == 1 && ((BTDownload)bTDownloadDataLine.getInitializeObject()).isPausable());
        this.playSingleAudioFileAction.setEnabled(this.getSelectedDownloaders().length == 1 && bl4 && bl6);
        this.removeYouTubeAction.setEnabled(this.isHttpDownload((BTDownload)bTDownloadDataLine.getInitializeObject()));
        BTDownloadActions.REMOVE_TORRENT_ACTION.setEnabled(!this.isHttpDownload((BTDownload)bTDownloadDataLine.getInitializeObject()));
        BTDownloadActions.REMOVE_TORRENT_AND_DATA_ACTION.setEnabled(!this.isHttpDownload((BTDownload)bTDownloadDataLine.getInitializeObject()));
    }

    private boolean selectionHasMP4s(File file) {
        boolean bl = file != null && (LibraryUtils.directoryContainsExtension(file, 4, "mp4") || file.isFile() && FilenameUtils.hasExtension(file.getAbsolutePath(), "mp4"));
        return bl;
    }

    private boolean selectionIsSingleFile(File file) {
        boolean bl = file != null && file.isFile();
        return bl;
    }

    private boolean selectionHasAudioFiles(BTDownload bTDownload) {
        if (bTDownload instanceof SoundcloudTrackDownload) {
            return true;
        }
        File file = bTDownload.getSaveLocation();
        boolean bl = file != null && (LibraryUtils.directoryContainsAudio(file, 4) || file.isFile() && AudioPlayer.isPlayableFile(file));
        return bl;
    }

    private boolean isHttpDownload(BTDownload bTDownload) {
        return bTDownload instanceof YouTubeVideoUrlDownload || bTDownload instanceof YouTubeItemDownload || bTDownload instanceof SoundcloudTrackUrlDownload || bTDownload instanceof SoundcloudTrackDownload;
    }

    @Override
    public void handleNoSelection() {
        this.removeAction.setEnabled(false);
        this.resumeAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.exploreAction.setEnabled(false);
        this.showInLibraryAction.setEnabled(false);
        this.copyMagnetAction.setEnabled(false);
        this.copyHashAction.setEnabled(false);
        this.shareTorrentAction.setEnabled(false);
        this.sendToItunesAction.setEnabled(false);
        this.playSingleAudioFileAction.setEnabled(false);
        BTDownloadActions.REMOVE_TORRENT_ACTION.setEnabled(false);
        BTDownloadActions.REMOVE_TORRENT_AND_DATA_ACTION.setEnabled(false);
        this.removeYouTubeAction.setEnabled(false);
    }

    public void openTorrentSearchResult(final WebSearchResult webSearchResult, final boolean bl, final ActionListener actionListener) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                TorrentFetcherDownload torrentFetcherDownload = new TorrentFetcherDownload(webSearchResult.getTorrentURI(), webSearchResult.getDetailsUrl(), webSearchResult.getDisplayName(), webSearchResult.getHash(), webSearchResult.getSize(), bl, actionListener);
                BTDownloadMediator.this.add(torrentFetcherDownload);
            }
        });
    }

    public void openTorrentURI(final String string, final boolean bl, final ActionListener actionListener) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                TorrentFetcherDownload torrentFetcherDownload = new TorrentFetcherDownload(string, bl, actionListener);
                BTDownloadMediator.this.add(torrentFetcherDownload);
            }
        });
    }

    public void openTorrentURI(final String string, final String string2, final ActionListener actionListener) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                TorrentFetcherDownload torrentFetcherDownload = new TorrentFetcherDownload(string, string2, actionListener);
                BTDownloadMediator.this.add(torrentFetcherDownload);
            }
        });
    }

    public void openTorrentURI(final String string, final String string2, final String string3, final String string4, final ActionListener actionListener) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                TorrentFetcherDownload torrentFetcherDownload = new TorrentFetcherDownload(string, string2, string3, string4, actionListener);
                BTDownloadMediator.this.add(torrentFetcherDownload);
            }
        });
    }

    public void openTorrentFileForSeed(final File file, final File file2) {
        if (!AzureusStarter.isAzureusCoreStarted()) {
            LOG.error("Azureus core not started");
            return;
        }
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        BTDownloadCreator bTDownloadCreator = new BTDownloadCreator(file, file2, true, null);
                        BTDownload bTDownload = bTDownloadCreator.createDownload();
                        if (!(bTDownload instanceof DuplicateDownload)) {
                            BTDownloadMediator.this.add(bTDownload);
                        } else {
                            BTDownloadMediator.this.selectRowByDownload(bTDownload);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (exception.toString().contains("No files selected by user")) break block4;
                        GUIMediator.showError(I18n.tr("FrostWire was unable to load the torrent file \"{0}\", - it may be malformed or FrostWire does not have permission to access this file.", file.getName()), QuestionsHandler.TORRENT_OPEN_FAILURE);
                    }
                }
            }
        });
    }

    protected void selectRowByDownload(BTDownload bTDownload) {
        for (int i = 0; i < this.TABLE.getRowCount(); ++i) {
            BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(i);
            if (!bTDownload.getHash().equals(((BTDownload)bTDownloadDataLine.getInitializeObject()).getHash())) continue;
            ((BTDownload)bTDownloadDataLine.getInitializeObject()).getSize(true);
            ((BTDownload)bTDownloadDataLine.getInitializeObject()).updateDownloadManager(bTDownload.getDownloadManager());
            this.TABLE.setSelectedRow(i);
            return;
        }
    }

    public void openTorrentFile(final File file, final boolean bl) {
        if (!AzureusStarter.isAzureusCoreStarted()) {
            LOG.error("Azureus core not started");
            return;
        }
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        BTDownload bTDownload;
                        Object object;
                        boolean[] blArray = null;
                        if (bl) {
                            object = new PartialFilesDialog(GUIMediator.getAppFrame(), file);
                            ((Dialog)object).setVisible(true);
                            blArray = ((PartialFilesDialog)object).getFilesSelection();
                            if (blArray == null) {
                                return;
                            }
                        }
                        if (!((bTDownload = ((BTDownloadCreator)(object = new BTDownloadCreator(file, null, false, blArray))).createDownload()) instanceof DuplicateDownload)) {
                            BTDownloadMediator.this.add(bTDownload);
                        } else {
                            BTDownloadMediator.this.selectRowByDownload(bTDownload);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (exception.toString().contains("No files selected by user")) break block6;
                        GUIMediator.showError(I18n.tr("FrostWire was unable to load the torrent file \"{0}\", - it may be malformed or FrostWire does not have permission to access this file.", file.getName()), QuestionsHandler.TORRENT_OPEN_FAILURE);
                    }
                }
            }
        });
    }

    public BTDownload[] getSelectedDownloaders() {
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList<BTDownload> arrayList = new ArrayList<BTDownload>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(nArray[i]);
            BTDownload bTDownload = (BTDownload)bTDownloadDataLine.getInitializeObject();
            arrayList.add(bTDownload);
        }
        return arrayList.toArray(new BTDownload[0]);
    }

    public long getTotalBytesDownloaded() {
        if (!AzureusStarter.isAzureusCoreStarted()) {
            return 0L;
        }
        AzureusCore azureusCore = AzureusStarter.getAzureusCore();
        if (azureusCore == null) {
            return 0L;
        }
        return azureusCore.getGlobalManager().getStats().getTotalDataBytesReceived();
    }

    public long getTotalBytesUploaded() {
        if (!AzureusStarter.isAzureusCoreStarted()) {
            return 0L;
        }
        AzureusCore azureusCore = AzureusStarter.getAzureusCore();
        if (azureusCore == null) {
            return 0L;
        }
        return azureusCore.getGlobalManager().getStats().getTotalDataBytesSent();
    }

    public void stopCompleted() {
        int n = ((BTDownloadRowFilteredModel)this.DATA_MODEL).getRowCount();
        for (int i = n - 1; i >= 0; --i) {
            BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)((BTDownloadRowFilteredModel)this.DATA_MODEL).get(i);
            BTDownload bTDownload = (BTDownload)bTDownloadDataLine.getInitializeObject();
            if (!bTDownload.isCompleted()) continue;
            bTDownload.pause();
        }
    }

    public boolean isDownloading(String string) {
        return ((BTDownloadRowFilteredModel)this.DATA_MODEL).isDownloading(string);
    }

    public void addDownloadManager(DownloadManager downloadManager) {
        try {
            this.add(BTDownloadCreator.createDownload(downloadManager, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void restoreSorting() {
        int n = BittorrentSettings.BTMEDIATOR_COLUMN_SORT_INDEX.getValue();
        boolean bl = BittorrentSettings.BTMEDIATOR_COLUMN_SORT_ORDER.getValue();
        LimeTableColumn limeTableColumn = BTDownloadDataLine.staticGetColumn(n);
        if (n != -1 && limeTableColumn != null && TablesHandlerSettings.getVisibility(limeTableColumn.getId(), limeTableColumn.getDefaultVisibility()).getValue()) {
            ((BTDownloadRowFilteredModel)this.DATA_MODEL).sort(n);
            if (!bl) {
                ((BTDownloadRowFilteredModel)this.DATA_MODEL).sort(n);
            }
        } else {
            ((BTDownloadRowFilteredModel)this.DATA_MODEL).sort(13);
        }
    }

    public void openYouTubeVideoUrl(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                YouTubeVideoUrlDownload youTubeVideoUrlDownload = new YouTubeVideoUrlDownload(string);
                BTDownloadMediator.this.add(youTubeVideoUrlDownload);
            }
        });
    }

    public void openSoundcloudTrackUrl(final String string, final String string2) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                SoundcloudTrackUrlDownload soundcloudTrackUrlDownload = new SoundcloudTrackUrlDownload(string, string2);
                BTDownloadMediator.this.add(soundcloudTrackUrlDownload);
            }
        });
    }

    public void openYouTubeItem(final FilePackage filePackage) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                Object object;
                try {
                    object = new ArrayList<FilePackage>(DownloadController.getInstance().getPackages());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        FilePackage filePackage2 = (FilePackage)iterator.next();
                        if (!filePackage2.getChildren().get(0).getName().equals(filePackage.getChildren().get(0).getName())) continue;
                        System.out.println("YouTube download duplicated");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object = new YouTubeItemDownload(filePackage);
                BTDownloadMediator.this.add((BTDownload)object);
            }
        });
    }

    public void openSoundcloudItem(final FilePackage filePackage, final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                Object object;
                try {
                    object = new ArrayList<FilePackage>(DownloadController.getInstance().getPackages());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        FilePackage filePackage2 = (FilePackage)iterator.next();
                        if (!filePackage2.getChildren().get(0).getName().equals(filePackage.getChildren().get(0).getName())) continue;
                        System.out.println("Soundcloud download duplicated");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object = new SoundcloudTrackDownload(filePackage, string);
                BTDownloadMediator.this.add((BTDownload)object);
            }
        });
    }

    class SeedingFilter
    implements TableLineFilter<BTDownloadDataLine> {
        SeedingFilter() {
        }

        @Override
        public boolean allow(BTDownloadDataLine bTDownloadDataLine) {
            if (ApplicationSettings.SHOW_SEEDING_TRANSFERS.getValue()) {
                return true;
            }
            if (bTDownloadDataLine == null) {
                return false;
            }
            return !bTDownloadDataLine.isSeeding();
        }
    }
}

