/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadDataLine;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import java.util.HashSet;

public class BTDownloadModel
extends BasicDataLineModel<BTDownloadDataLine, BTDownload> {
    private static final long serialVersionUID = 8163563369069283107L;
    private HashSet<String> _hashDownloads = new HashSet();

    BTDownloadModel() {
        super(BTDownloadDataLine.class);
    }

    @Override
    public BTDownloadDataLine createDataLine() {
        return new BTDownloadDataLine();
    }

    int getActiveDownloads() {
        int n = this.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            BTDownload bTDownload = (BTDownload)((BTDownloadDataLine)this.get(i)).getInitializeObject();
            if (bTDownload.isCompleted() || bTDownload.getState() != 50) continue;
            ++n2;
        }
        return n2;
    }

    int getActiveUploads() {
        int n = this.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            BTDownload bTDownload = (BTDownload)((BTDownloadDataLine)this.get(i)).getInitializeObject();
            if (!bTDownload.isCompleted() || bTDownload.getState() != 60) continue;
            ++n2;
        }
        return n2;
    }

    public int getTotalDownloads() {
        return this.getRowCount();
    }

    @Override
    public Object refresh() {
        try {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)this.get(i);
                bTDownloadDataLine.update();
            }
            this.fireTableRowsUpdated(0, n);
        }
        catch (Exception exception) {
            System.out.println("ATENTION: Send the following output to the FrostWire Development team.");
            System.out.println("===============================START COPY & PASTE=======================================");
            exception.printStackTrace();
            System.out.println("===============================END COPY & PASTE=======================================");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public int add(BTDownload bTDownload) {
        this._hashDownloads.add(bTDownload.getHash());
        return super.add(bTDownload);
    }

    @Override
    public int add(BTDownload bTDownload, int n) {
        this._hashDownloads.add(bTDownload.getHash());
        return super.add(bTDownload, n);
    }

    @Override
    public void remove(int n) {
        BTDownloadDataLine bTDownloadDataLine = (BTDownloadDataLine)this.get(n);
        BTDownload bTDownload = (BTDownload)bTDownloadDataLine.getInitializeObject();
        bTDownload.remove();
        this._hashDownloads.remove(bTDownload.getHash());
        super.remove(n);
    }

    public BTDownloadDataLine getDataline(int n) {
        return (BTDownloadDataLine)this.get(n);
    }

    public boolean isDownloading(String string) {
        return this._hashDownloads.contains(string);
    }
}

