/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SearchResultTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class BTDownloadTransferHandler
extends LimeTransferHandler {
    private static final long serialVersionUID = 7090230440259575371L;
    private static final Log LOG = LogFactory.getLog(BTDownloadTransferHandler.class);

    public BTDownloadTransferHandler() {
        super(1);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (DNDUtils.contains(dataFlavorArray, SearchResultTransferable.dataFlavor)) {
            return true;
        }
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), SearchResultTransferable.dataFlavor)) {
            try {
                SearchResultTransferable searchResultTransferable = (SearchResultTransferable)transferable.getTransferData(SearchResultTransferable.dataFlavor);
                SearchResultMediator searchResultMediator = searchResultTransferable.getResultPanel();
                SearchResultDataLine[] searchResultDataLineArray = searchResultTransferable.getTableLines();
                SearchMediator.downloadFromPanel(searchResultMediator, searchResultDataLineArray);
                return true;
            }
            catch (Throwable throwable) {
                LOG.error("Error importing DnD data", throwable);
            }
        }
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.importData(jComponent, transferable);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        BTDownload[] bTDownloadArray = BTDownloadMediator.instance().getSelectedBTDownloads();
        if (bTDownloadArray.length > 0) {
            List<File> list = this.getListOfFilesFromBTDowloads(bTDownloadArray);
            return new FileTransferable(list);
        }
        return null;
    }

    private List<File> getListOfFilesFromBTDowloads(BTDownload[] bTDownloadArray) {
        LinkedList<File> linkedList = new LinkedList<File>();
        Set<File> set = TorrentUtil.getIgnorableFiles();
        for (BTDownload bTDownload : bTDownloadArray) {
            File file = bTDownload.getSaveLocation();
            this.addFilesRecursively(linkedList, file, set);
        }
        return linkedList;
    }

    private void addFilesRecursively(List<File> list, File file, Set<File> set) {
        if (file.isFile()) {
            if (!set.contains(file)) {
                list.add(file);
            }
        } else if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                this.addFilesRecursively(list, file2, set);
            }
        }
    }
}

