/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.TrackersUtil;

public class CreateTorrentDialog
extends JDialog
implements TOTorrentProgressListener {
    private static final long serialVersionUID = -985586062136324042L;
    static final int TT_LOCAL = 1;
    static final int TT_EXTERNAL = 2;
    static final int TT_DECENTRAL = 3;
    static final String TT_EXTERNAL_DEFAULT = "http://";
    static final String TT_DECENTRAL_DEFAULT = TorrentUtils.getDecentralisedEmptyURL().toString();
    private static String default_save_dir = SharingSettings.TORRENTS_DIR_SETTING.getValueAsString();
    private static String comment = I18n.tr("Torrent File Created with FrostWire");
    private static int tracker_type = COConfigurationManager.getIntParameter("CreateTorrent.default.trackertype", 2);
    boolean create_from_dir;
    String singlePath = null;
    String directoryPath = null;
    String savePath = null;
    String trackerURL = "http://";
    boolean computed_piece_size = true;
    long manual_piece_size;
    boolean useMultiTracker = false;
    boolean useWebSeed = false;
    private boolean addOtherHashes = false;
    String multiTrackerConfig = "";
    List<List<String>> trackers = new ArrayList<List<String>>();
    String webSeedConfig = "";
    boolean autoOpen = true;
    boolean autoHost = false;
    boolean permitDHT = true;
    boolean privateTorrent = false;
    TOTorrentCreator creator = null;
    private File _saveDir;
    private Container _container;
    private JButton _buttonSelectFile;
    private JTextArea _textTrackers;
    private JCheckBox _checkStartSeeding;
    private JCheckBox _checkUseDHT;
    private JButton _buttonSaveAs;
    private JProgressBar _progressBar;
    private JTextField _textSelectedContent;
    private final Dimension MINIMUM_DIALOG_DIMENSIONS = new Dimension(600, 570);
    private JLabel _labelTrackers;
    private JScrollPane _textTrackersScrollPane;
    private JFileChooser _fileChooser;
    private String _invalidTrackerURL;
    private JFileChooser _saveAsDialog;
    private JButton _buttonClose;

    public CreateTorrentDialog(JFrame jFrame) {
        super(jFrame);
        this.trackers.add(new ArrayList());
        this.initComponents();
        this.setLocationRelativeTo(jFrame);
    }

    private void initComponents() {
        this.setTitle(I18n.tr("Create New Torrent"));
        this.setSize(this.MINIMUM_DIALOG_DIMENSIONS);
        this.setMinimumSize(this.MINIMUM_DIALOG_DIMENSIONS);
        this._container = this.getContentPane();
        this._container.setLayout(new GridBagLayout());
        this.initTorrentContents();
        this.initTorrentProperties();
        this.initSaveCloseButtons();
        this.initProgressBar();
        this.buildListeners();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
    }

    private void initTorrentContents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr("Torrent Contents")));
        this._buttonSelectFile = new JButton(I18n.tr("Select File or Folder..."));
        this._buttonSelectFile.setToolTipText(I18n.tr("Click here to select a single file or a folder as the content indexed by your new .torrent"));
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this._textSelectedContent = new JTextField();
        this._textSelectedContent.setEditable(false);
        this._textSelectedContent.setToolTipText(I18n.tr("These box shows the contents you've selected for your new .torrent.\nEither a file, or the contents of a folder."));
        jPanel.add((Component)this._textSelectedContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._buttonSelectFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.ipady = 50;
        gridBagConstraints.ipadx = 50;
        this._container.add((Component)jPanel, gridBagConstraints);
    }

    private void initTorrentProperties() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr("Torrent Properties")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        this._checkUseDHT = new JCheckBox(I18n.tr("Trackerless Torrent (DHT)"), true);
        this._checkUseDHT.setToolTipText(I18n.tr("Select this option to create torrents that don't need trackers, completely descentralized. (Recommended)"));
        jPanel.add((Component)this._checkUseDHT, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        this._checkStartSeeding = new JCheckBox(I18n.tr("Start seeding"), true);
        this._checkStartSeeding.setToolTipText(I18n.tr("Announce yourself as a seed for the content indexed by this torrent as soon as it's created.\nIf nobody is seeding the torrent won't work. (Recommended)"));
        jPanel.add((Component)this._checkStartSeeding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this._labelTrackers = new JLabel(I18n.tr("<html><p>Tracker Announce URLs</p><p>(One tracker per line)</p></html>"));
        this._labelTrackers.setToolTipText(I18n.tr("Enter a list of valid BitTorrent Tracker Server URLs.\nYour new torrent will be announced to these trackers if you start seeding the torrent."));
        jPanel.add((Component)this._labelTrackers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this._textTrackers = new JTextArea(10, 80);
        this._textTrackers.setToolTipText(this._labelTrackers.getToolTipText());
        this._textTrackers.setLineWrap(false);
        this._textTrackersScrollPane = new JScrollPane(this._textTrackers);
        jPanel.add((Component)this._textTrackersScrollPane, gridBagConstraints);
        this.updateTrackerRelatedControlsAvailability(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this._container.add((Component)jPanel, gridBagConstraints);
    }

    private void initSaveCloseButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this._buttonClose = new JButton(I18n.tr("Close"));
        this._container.add((Component)this._buttonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this._buttonSaveAs = new JButton(I18n.tr("Save torrent as..."));
        this._container.add((Component)this._buttonSaveAs, gridBagConstraints);
    }

    private void initProgressBar() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridwidth = 2;
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setStringPainted(true);
        this._container.add((Component)this._progressBar, gridBagConstraints);
    }

    private void buildListeners() {
        this._buttonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTorrentDialog.this.onButtonSelectFile();
            }
        });
        this._buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTorrentDialog.this.onButtonClose(actionEvent);
            }
        });
        this._buttonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTorrentDialog.this.onButtonSaveAs();
            }
        });
        this._checkUseDHT.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = CreateTorrentDialog.this._checkUseDHT.isSelected();
                CreateTorrentDialog.this.updateTrackerRelatedControlsAvailability(bl);
            }
        });
        this._textTrackers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (CreateTorrentDialog.this._checkUseDHT.isSelected()) {
                    CreateTorrentDialog.this._checkUseDHT.setSelected(false);
                }
            }
        });
    }

    private void updateTrackerRelatedControlsAvailability(boolean bl) {
        this._labelTrackers.setEnabled(!bl);
        this._textTrackers.setEnabled(!bl);
        this._textTrackersScrollPane.setEnabled(!bl);
        this._textTrackersScrollPane.getHorizontalScrollBar().setEnabled(!bl);
        this._textTrackersScrollPane.getVerticalScrollBar().setEnabled(!bl);
        this._labelTrackers.setForeground(bl ? Color.GRAY : Color.BLACK);
    }

    protected void onButtonClose(ActionEvent actionEvent) {
        GUIUtils.getDisposeAction().actionPerformed(actionEvent);
    }

    private void initFileChooser(int n) {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setMultiSelectionEnabled(false);
            this._fileChooser.setApproveButtonText(I18n.tr("Select"));
            this._fileChooser.setSelectedFile(FileChooserHandler.getLastInputDirectory());
        }
        this._fileChooser.setFileSelectionMode(n);
    }

    private void showFileChooser() {
        int n = this._fileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this._fileChooser.getSelectedFile();
            FileChooserHandler.setLastInputDirectory(file);
            this.setChosenContent(file);
        } else if (n == -1) {
            this._textSelectedContent.setText(I18n.tr("Unkown error. Try again please."));
        }
    }

    public void setChosenContent(File file) {
        if (!file.canRead()) {
            this._textSelectedContent.setText(I18n.tr("Error: You can't read on that file/folder."));
            return;
        }
        this.correctFileSelectionMode(file);
        this.setTorrentPathFromChosenFile(file);
        this.displayChosenContent(file);
    }

    private void displayChosenContent(File file) {
        String string = file.isFile() ? "[file] " : "[folder] ";
        this._textSelectedContent.setText(string + file.getAbsolutePath());
    }

    private void setTorrentPathFromChosenFile(File file) {
        File file2 = null;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file2.isFile()) {
            this.directoryPath = null;
            this.singlePath = file.getAbsolutePath();
        } else if (file2.isDirectory()) {
            this.directoryPath = file.getAbsolutePath();
            this.singlePath = null;
        }
    }

    private void correctFileSelectionMode(File file) {
        if (this._fileChooser == null) {
            this.initFileChooser(2);
        }
        if (file.isDirectory() && this._fileChooser.getFileSelectionMode() == 0) {
            this._fileChooser.setFileSelectionMode(1);
        }
        this.create_from_dir = file.isDirectory();
    }

    protected void onContentSelectionButton(int n) {
        this.initFileChooser(n);
        this.showFileChooser();
        this.revertSaveCloseButtons();
    }

    protected void onButtonSelectFile() {
        this.onContentSelectionButton(2);
    }

    protected void onButtonSaveAs() {
        boolean bl;
        if (this.singlePath == null && this.directoryPath == null) {
            JOptionPane.showMessageDialog(this, I18n.tr("Please select a file or a folder.\nYour new torrent will need content to index."), I18n.tr("Something's missing"), 0);
            return;
        }
        if (this.directoryPath != null && new File(this.directoryPath).listFiles().length == 0) {
            JOptionPane.showMessageDialog(this, I18n.tr("The folder you selected is empty."), I18n.tr("Invalid Folder"), 0);
            return;
        }
        boolean bl2 = bl = !this._checkUseDHT.isSelected();
        if (bl) {
            if (!this.validateAndFixTrackerURLS()) {
                if (this._invalidTrackerURL == null) {
                    this._invalidTrackerURL = "";
                }
                JOptionPane.showMessageDialog(this, I18n.tr("Check again your tracker URL(s).\n" + this._invalidTrackerURL), I18n.tr("Invalid Tracker URL\n"), 0);
                return;
            }
            this.setTrackerType(2);
        } else {
            this.trackers.clear();
            this.setTrackerType(3);
        }
        this.autoOpen = this._checkStartSeeding.isSelected();
        if (!this.showSaveAsDialog()) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (CreateTorrentDialog.this.makeTorrent()) {
                    CreateTorrentDialog.this.revertSaveCloseButtons();
                    CreateTorrentDialog.this._progressBar.setString(I18n.tr("Torrent Created."));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CreateTorrentDialog.this.dispose();
                        }
                    });
                    if (CreateTorrentDialog.this.autoOpen) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GUIMediator.instance().openTorrentForSeed(new File(CreateTorrentDialog.this.savePath), CreateTorrentDialog.this._saveDir);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    private boolean showSaveAsDialog() {
        if (this._saveAsDialog == null) {
            this._saveAsDialog = new JFileChooser(SharingSettings.DEFAULT_TORRENTS_DIR);
            this._saveAsDialog.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return I18n.tr("Torrent File");
                }

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".torrent");
                }
            });
        }
        File file = null;
        File file2 = this.create_from_dir ? new File(this.directoryPath) : new File(this.singlePath);
        file = new File(this._saveAsDialog.getSelectedFile(), file2.getName() + ".torrent");
        this._saveAsDialog.setSelectedFile(file);
        int n = this._saveAsDialog.showSaveDialog(this);
        if (n != 0) {
            this.savePath = null;
            return false;
        }
        this.savePath = this._saveAsDialog.getSelectedFile().getAbsolutePath();
        if (!this.savePath.endsWith(".torrent")) {
            this.savePath = this.savePath + ".torrent";
        }
        return true;
    }

    private boolean validateAndFixTrackerURLS() {
        String string = this._textTrackers.getText();
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = "^(https?|udp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        Pattern pattern = Pattern.compile(string2);
        String[] stringArray = string.split("\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray) {
            Matcher matcher;
            if (string3.trim().equals("")) continue;
            if (!string3.startsWith(TT_EXTERNAL_DEFAULT) && !string3.startsWith("udp://")) {
                string3 = TT_EXTERNAL_DEFAULT + string3.trim();
            }
            if (!(matcher = pattern.matcher(string3.trim())).matches()) {
                this._invalidTrackerURL = string3.trim();
                return false;
            }
            arrayList.add(string3.trim());
        }
        this.fixValidTrackers(arrayList);
        this.trackers.clear();
        this.trackers.add(arrayList);
        this.trackerURL = (String)arrayList.get(0);
        this.useMultiTracker = arrayList.size() > 1;
        this._invalidTrackerURL = null;
        return true;
    }

    private void fixValidTrackers(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string + "\n");
        }
        this._textTrackers.setText(stringBuilder.toString());
    }

    protected int getTrackerType() {
        return tracker_type;
    }

    protected void setPieceSizeComputed() {
        this.computed_piece_size = true;
    }

    public boolean getPieceSizeComputed() {
        return this.computed_piece_size;
    }

    protected void setPieceSizeManual(long l) {
        this.computed_piece_size = false;
        this.manual_piece_size = l;
    }

    protected long getPieceSizeManual() {
        return this.manual_piece_size;
    }

    protected void setTrackerType(int n) {
        tracker_type = n;
        COConfigurationManager.setParameter("CreateTorrent.default.trackertype", tracker_type);
    }

    protected String getDefaultSaveDir() {
        return default_save_dir;
    }

    protected void setDefaultSaveDir(String string) {
        default_save_dir = string;
        COConfigurationManager.setParameter("CreateTorrent.default.save", default_save_dir);
    }

    public boolean makeTorrent() {
        this.disableSaveCloseButtons();
        int n = this.getTrackerType();
        if (n == 2) {
            TrackersUtil.getInstance().addTracker(this.trackerURL);
        }
        File file = this.create_from_dir ? new File(this.directoryPath) : new File(this.singlePath);
        try {
            Object object;
            TOTorrent tOTorrent;
            URL uRL = new URL(this.trackerURL);
            if (this.getPieceSizeComputed()) {
                this.creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, uRL, this.addOtherHashes);
                this.creator.addListener(this);
                tOTorrent = this.creator.create();
            } else {
                object = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, uRL, this.addOtherHashes, this.getPieceSizeManual());
                object.addListener(this);
                tOTorrent = object.create();
            }
            if (n == 3) {
                TorrentUtils.setDecentralised(tOTorrent);
            }
            tOTorrent.setComment(comment);
            TorrentUtils.setDHTBackupEnabled(tOTorrent, this.permitDHT);
            TorrentUtils.setPrivate(tOTorrent, this.privateTorrent);
            LocaleTorrentUtil.setDefaultTorrentEncoding(tOTorrent);
            object = this.create_from_dir ? file : file.getParentFile();
            this._saveDir = object;
            if (this.useMultiTracker) {
                this.reportCurrentTask(MessageText.getString("wizard.addingmt"));
                TorrentUtils.listToAnnounceGroups(this.trackers, tOTorrent);
            }
            this.reportCurrentTask(MessageText.getString("wizard.savingfile"));
            File file2 = new File(this.savePath);
            tOTorrent.serialiseToBEncodedFile(file2);
            this.reportCurrentTask(MessageText.getString("wizard.filesaved"));
        }
        catch (Exception exception) {
            this.revertSaveCloseButtons();
            if (exception instanceof TOTorrentException) {
                TOTorrentException tOTorrentException = (TOTorrentException)exception;
                if (tOTorrentException.getReason() != 9) {
                    this.reportCurrentTask(MessageText.getString("wizard.operationfailed"));
                    this.reportCurrentTask(TorrentUtils.exceptionToText(tOTorrentException));
                }
            } else {
                Debug.printStackTrace(exception);
                this.reportCurrentTask(MessageText.getString("wizard.operationfailed"));
            }
            return false;
        }
        return true;
    }

    private void revertSaveCloseButtons() {
        this._buttonClose.setEnabled(true);
        this._buttonSaveAs.setText(I18n.tr("Save torrent as..."));
        this._buttonSaveAs.setEnabled(true);
    }

    private void disableSaveCloseButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateTorrentDialog.this._buttonSaveAs.setText(I18n.tr("Saving Torrent..."));
                CreateTorrentDialog.this._buttonSaveAs.setEnabled(false);
                CreateTorrentDialog.this._buttonClose.setEnabled(false);
            }
        });
    }

    public static void waitForCore(final TriggerInThread triggerInThread, final AzureusCoreRunningListener azureusCoreRunningListener) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(final AzureusCore azureusCore) {
                if (triggerInThread == TriggerInThread.ANY_THREAD) {
                    azureusCoreRunningListener.azureusCoreRunning(azureusCore);
                } else if (triggerInThread == TriggerInThread.NEW_THREAD) {
                    new AEThread2("CoreWaiterInvoke", true){

                        @Override
                        public void run() {
                            azureusCoreRunningListener.azureusCoreRunning(azureusCore);
                        }
                    }.start();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (triggerInThread == TriggerInThread.SWT_THREAD) {
                            azureusCoreRunningListener.azureusCoreRunning(azureusCore);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void reportProgress(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("reportProgress: " + n);
                CreateTorrentDialog.this._progressBar.setValue(n);
            }
        });
    }

    @Override
    public void reportCurrentTask(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateTorrentDialog.this._progressBar.setString(string);
            }
        });
    }

    public static enum TriggerInThread {
        SWT_THREAD,
        ANY_THREAD,
        NEW_THREAD;

    }
}

