/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.TorrentFileInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.limewire.util.StringUtils;

public class PartialFilesDialog
extends JDialog {
    private static final long serialVersionUID = 4312306965758592618L;
    private LabeledTextField _filter;
    private RowFilter<Object, Object> _textBasedFilter = new RowFilterExtension();
    private JLabel labelTitle;
    private JTable _table;
    private JScrollPane _scrollPane;
    private JButton _buttonOK;
    private JButton _buttonCancel;
    private final TOTorrent _torrent;
    private final String _name;
    private final TorrentTableModel _model;
    private boolean[] _filesSelection;
    private JCheckBox _checkBoxToggleAll;

    public PartialFilesDialog(JFrame jFrame, File file) throws TOTorrentException {
        super((Frame)jFrame, I18n.tr("Select files to download"));
        this._torrent = TorrentUtils.readFromFile(file, false);
        this._name = file.getName();
        this._model = new TorrentTableModel(this._torrent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                GUIMediator.instance().setRemoteDownloadsAllowed(false);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIMediator.instance().setRemoteDownloadsAllowed(true);
            }
        });
        this.setupUI();
        this.setLocationRelativeTo(jFrame);
    }

    protected void setupUI() {
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setupTitle();
        this.setupTextFilter();
        this.setupToggleAllSelectionCheckbox();
        this.setupTable();
        this.setupOkButton();
        this.setupCancelButton();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getRootPane().setDefaultButton(this._buttonOK);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
    }

    private void setupCancelButton() {
        this._buttonCancel = new JButton(I18n.tr("Cancel"));
        this._buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartialFilesDialog.this.buttonCancel_actionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 8, 6);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 18;
        this.getContentPane().add((Component)this._buttonCancel, gridBagConstraints);
    }

    private void setupOkButton() {
        this._buttonOK = new JButton(I18n.tr("Download Selected Files Only"));
        this._buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartialFilesDialog.this.buttonOK_actionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 430, 8, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this._buttonOK, gridBagConstraints);
    }

    private void setupTable() {
        this._table = new JTable();
        this._table.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this._table.setModel(this._model);
        this._table.getColumnModel().getColumn(0).setHeaderValue("");
        this._table.getColumnModel().getColumn(1).setHeaderValue(I18n.tr("File"));
        this._table.getColumnModel().getColumn(2).setHeaderValue(I18n.tr("Size"));
        this._table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(620);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(60);
        this._scrollPane = new JScrollPane(this._table, 20, 30);
        this._table.setFillsViewportHeight(true);
        this._table.setAutoResizeMode(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)this._scrollPane, gridBagConstraints);
    }

    private void setupToggleAllSelectionCheckbox() {
        this._checkBoxToggleAll = new JCheckBox(I18n.tr("Select/Unselect all files"), true);
        this._checkBoxToggleAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PartialFilesDialog.this.onCheckBoxToggleAll(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._checkBoxToggleAll, gridBagConstraints);
    }

    private void setupTextFilter() {
        this._filter = new LabeledTextField("Filter files", 30);
        this._filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (PartialFilesDialog.this._filter.getText() == null || PartialFilesDialog.this._filter.getText().equals("")) {
                    PartialFilesDialog.this._table.setRowSorter(null);
                    return;
                }
                PartialFilesDialog.this._checkBoxToggleAll.setSelected(false);
                TableRowSorter<TorrentTableModel> tableRowSorter = new TableRowSorter<TorrentTableModel>(PartialFilesDialog.this._model);
                tableRowSorter.setRowFilter(PartialFilesDialog.this._textBasedFilter);
                PartialFilesDialog.this._table.setRowSorter(tableRowSorter);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._filter, gridBagConstraints);
    }

    private void setupTitle() {
        String string = this._torrent.getUTF8Name();
        if (string == null) {
            string = this._torrent.getName() != null ? StringUtils.getUTF8String(this._torrent.getName()) : this._name.replace("_", " ").replace(".torrent", "").replace("&quot;", "\"");
        }
        this.labelTitle = new JLabel(string);
        this.labelTitle.setFont(new Font("Dialog", 1, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.labelTitle, gridBagConstraints);
    }

    protected void onCheckBoxToggleAll(ItemEvent itemEvent) {
        this._model.setAllSelected(this._checkBoxToggleAll.isSelected());
        this._buttonOK.setEnabled(this._checkBoxToggleAll.isSelected());
    }

    public void checkboxToggleAllSetSelectedNoTrigger(boolean bl) {
        ItemListener[] itemListenerArray;
        for (ItemListener itemListener : itemListenerArray = this._checkBoxToggleAll.getItemListeners()) {
            this._checkBoxToggleAll.removeItemListener(itemListener);
        }
        this._checkBoxToggleAll.setSelected(bl);
        for (ItemListener itemListener : itemListenerArray) {
            this._checkBoxToggleAll.addItemListener(itemListener);
        }
    }

    protected void buttonOK_actionPerformed(ActionEvent actionEvent) {
        TorrentFileInfo[] torrentFileInfoArray = this._model.getFileInfos();
        this._filesSelection = new boolean[torrentFileInfoArray.length];
        for (int i = 0; i < this._filesSelection.length; ++i) {
            this._filesSelection[i] = torrentFileInfoArray[i].selected;
        }
        GUIUtils.getDisposeAction().actionPerformed(actionEvent);
    }

    protected void buttonCancel_actionPerformed(ActionEvent actionEvent) {
        GUIUtils.getDisposeAction().actionPerformed(actionEvent);
    }

    public boolean[] getFilesSelection() {
        return this._filesSelection;
    }

    private final class TorrentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8689494570949104116L;
        private final TOTorrent _torrent;
        private final TorrentFileInfo[] _fileInfos;

        public TorrentTableModel(TOTorrent tOTorrent) {
            this._torrent = tOTorrent;
            this._fileInfos = new TorrentFileInfo[tOTorrent.getFiles().length];
            for (int i = 0; i < this._fileInfos.length; ++i) {
                this._fileInfos[i] = new TorrentFileInfo(tOTorrent.getFiles()[i], true);
            }
        }

        @Override
        public int getRowCount() {
            return this._torrent.getFiles().length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return SizeHolder.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this._fileInfos[n].selected;
                }
                case 1: {
                    return this._fileInfos[n].torrentFile.getRelativePath();
                }
                case 2: {
                    return new SizeHolder(this._fileInfos[n].torrentFile.getLength());
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this._fileInfos[n].selected = (Boolean)object;
                this.fireTableDataChanged();
            }
            PartialFilesDialog.this.checkboxToggleAllSetSelectedNoTrigger(this.isAllSelected());
            PartialFilesDialog.this._buttonOK.setEnabled(!this.isNoneSelected());
        }

        public void setAllSelected(boolean bl) {
            for (int i = 0; i < this._fileInfos.length; ++i) {
                this._fileInfos[i].selected = bl;
            }
            this.fireTableDataChanged();
        }

        public boolean isAllSelected() {
            for (int i = 0; i < this._fileInfos.length; ++i) {
                if (this._fileInfos[i].selected) continue;
                return false;
            }
            return true;
        }

        public boolean isNoneSelected() {
            for (int i = 0; i < this._fileInfos.length; ++i) {
                if (!this._fileInfos[i].selected) continue;
                return false;
            }
            return true;
        }

        public TorrentFileInfo[] getFileInfos() {
            return this._fileInfos;
        }
    }

    private final class RowFilterExtension
    extends RowFilter<Object, Object> {
        private RowFilterExtension() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
            String[] stringArray;
            String string = (String)entry.getValue(1);
            for (String string2 : stringArray = PartialFilesDialog.this._filter.getText().split(" ")) {
                if (string.toLowerCase().contains(string2.toLowerCase())) continue;
                return false;
            }
            return true;
        }
    }
}

