/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.limewire.util.FilenameUtils;

public class PartialYouTubePackageDialog
extends JDialog {
    private static final long serialVersionUID = -7028188722959174740L;
    private LabeledTextField _filter;
    private RowFilter<Object, Object> _textBasedFilter = new RowFilterExtension();
    private JLabel _label;
    private JTable _table;
    private JScrollPane _scrollPane;
    private JButton _buttonOK;
    private JButton _buttonCancel;
    private String name;
    private final FilePackageTableModel _model;
    private List<FilePackage> _filesSelection;
    private JCheckBox _checkBoxToggleAll;

    public PartialYouTubePackageDialog(JFrame jFrame, String string, List<FilePackage> list) throws TOTorrentException {
        super((Frame)jFrame, I18n.tr("Select files to download"));
        this.name = string;
        this._model = new FilePackageTableModel(list);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                GUIMediator.instance().setRemoteDownloadsAllowed(false);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIMediator.instance().setRemoteDownloadsAllowed(true);
            }
        });
        this.setupUI();
        this.setLocationRelativeTo(jFrame);
    }

    protected void setupUI() {
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setupTitle();
        this.setupTextFilter();
        this.setupToggleAllSelectionCheckbox();
        this.setupTable();
        this.setupOkButton();
        this.setupCancelButton();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getRootPane().setDefaultButton(this._buttonOK);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
    }

    private void setupCancelButton() {
        this._buttonCancel = new JButton(I18n.tr("Cancel"));
        this._buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartialYouTubePackageDialog.this.buttonCancel_actionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 8, 6);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 18;
        this.getContentPane().add((Component)this._buttonCancel, gridBagConstraints);
    }

    private void setupOkButton() {
        this._buttonOK = new JButton(I18n.tr("Download Selected Files Only"));
        this._buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartialYouTubePackageDialog.this.buttonOK_actionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 430, 8, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this._buttonOK, gridBagConstraints);
    }

    private void setupTable() {
        this._table = new JTable();
        this._table.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this._table.setModel(this._model);
        this._table.getColumnModel().getColumn(0).setHeaderValue("");
        this._table.getColumnModel().getColumn(1).setHeaderValue(I18n.tr("File"));
        this._table.getColumnModel().getColumn(2).setHeaderValue(I18n.tr("Type"));
        this._table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(620);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(60);
        this._scrollPane = new JScrollPane(this._table, 20, 30);
        this._table.setFillsViewportHeight(true);
        this._table.setAutoResizeMode(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)this._scrollPane, gridBagConstraints);
    }

    private void setupToggleAllSelectionCheckbox() {
        this._checkBoxToggleAll = new JCheckBox(I18n.tr("Select/Unselect all files"), true);
        this._checkBoxToggleAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PartialYouTubePackageDialog.this.onCheckBoxToggleAll(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._checkBoxToggleAll, gridBagConstraints);
    }

    private void setupTextFilter() {
        this._filter = new LabeledTextField("Filter files", 30);
        this._filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (PartialYouTubePackageDialog.this._filter.getText() == null || PartialYouTubePackageDialog.this._filter.getText().equals("")) {
                    PartialYouTubePackageDialog.this._table.setRowSorter(null);
                    return;
                }
                PartialYouTubePackageDialog.this._checkBoxToggleAll.setSelected(false);
                TableRowSorter<FilePackageTableModel> tableRowSorter = new TableRowSorter<FilePackageTableModel>(PartialYouTubePackageDialog.this._model);
                tableRowSorter.setRowFilter(PartialYouTubePackageDialog.this._textBasedFilter);
                PartialYouTubePackageDialog.this._table.setRowSorter(tableRowSorter);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._filter, gridBagConstraints);
    }

    private void setupTitle() {
        this._label = new JLabel(this.name.replace("_", " ").replace(".torrent", "").replace("&quot;", "\""));
        this._label.setFont(new Font("Dialog", 1, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._label, gridBagConstraints);
    }

    protected void onCheckBoxToggleAll(ItemEvent itemEvent) {
        this._model.setAllSelected(this._checkBoxToggleAll.isSelected());
        this._buttonOK.setEnabled(this._checkBoxToggleAll.isSelected());
    }

    public void checkboxToggleAllSetSelectedNoTrigger(boolean bl) {
        ItemListener[] itemListenerArray;
        for (ItemListener itemListener : itemListenerArray = this._checkBoxToggleAll.getItemListeners()) {
            this._checkBoxToggleAll.removeItemListener(itemListener);
        }
        this._checkBoxToggleAll.setSelected(bl);
        for (ItemListener itemListener : itemListenerArray) {
            this._checkBoxToggleAll.addItemListener(itemListener);
        }
    }

    protected void buttonOK_actionPerformed(ActionEvent actionEvent) {
        FilePackageInfo[] filePackageInfoArray = this._model.getFileInfos();
        this._filesSelection = new ArrayList<FilePackage>();
        for (int i = 0; i < filePackageInfoArray.length; ++i) {
            if (!filePackageInfoArray[i].selected) continue;
            this._filesSelection.add(filePackageInfoArray[i].file);
        }
        GUIUtils.getDisposeAction().actionPerformed(actionEvent);
    }

    protected void buttonCancel_actionPerformed(ActionEvent actionEvent) {
        GUIUtils.getDisposeAction().actionPerformed(actionEvent);
    }

    public List<FilePackage> getFilesSelection() {
        return this._filesSelection;
    }

    private final class FilePackageTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8689494570949104117L;
        private final FilePackageInfo[] _fileInfos;

        public FilePackageTableModel(List<FilePackage> list) {
            this._fileInfos = new FilePackageInfo[list.size()];
            for (int i = 0; i < this._fileInfos.length; ++i) {
                this._fileInfos[i] = new FilePackageInfo(list.get(i), true);
            }
        }

        @Override
        public int getRowCount() {
            return this._fileInfos.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this._fileInfos[n].selected;
                }
                case 1: {
                    return this.readFilename(this._fileInfos[n].file);
                }
                case 2: {
                    return FilenameUtils.getExtension(this.readFilename(this._fileInfos[n].file));
                }
            }
            return null;
        }

        private String readFilename(FilePackage filePackage) {
            DownloadLink downloadLink = filePackage.getChildren().get(0);
            if (downloadLink.getStringProperty("convertto", "").equals("AUDIOMP3")) {
                PartialYouTubePackageDialog.this.name = FilenameUtils.getBaseName(downloadLink.getName());
                PartialYouTubePackageDialog.this._label.setText(PartialYouTubePackageDialog.this.name);
                return FilenameUtils.getBaseName(downloadLink.getName()) + ".mp3";
            }
            return downloadLink.getName();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this._fileInfos[n].selected = (Boolean)object;
                this.fireTableDataChanged();
            }
            PartialYouTubePackageDialog.this.checkboxToggleAllSetSelectedNoTrigger(this.isAllSelected());
            PartialYouTubePackageDialog.this._buttonOK.setEnabled(!this.isNoneSelected());
        }

        public void setAllSelected(boolean bl) {
            for (int i = 0; i < this._fileInfos.length; ++i) {
                this._fileInfos[i].selected = bl;
            }
            this.fireTableDataChanged();
        }

        public boolean isAllSelected() {
            for (int i = 0; i < this._fileInfos.length; ++i) {
                if (this._fileInfos[i].selected) continue;
                return false;
            }
            return true;
        }

        public boolean isNoneSelected() {
            for (int i = 0; i < this._fileInfos.length; ++i) {
                if (!this._fileInfos[i].selected) continue;
                return false;
            }
            return true;
        }

        public FilePackageInfo[] getFileInfos() {
            return this._fileInfos;
        }
    }

    public class FilePackageInfo {
        public FilePackage file;
        public boolean selected;

        public FilePackageInfo(FilePackage filePackage, boolean bl) {
            this.file = filePackage;
            this.selected = bl;
        }
    }

    private final class RowFilterExtension
    extends RowFilter<Object, Object> {
        private RowFilterExtension() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
            String[] stringArray;
            String string = (String)entry.getValue(1);
            for (String string2 : stringArray = PartialYouTubePackageDialog.this._filter.getText().split(" ")) {
                if (string.toLowerCase().contains(string2.toLowerCase())) continue;
                return false;
            }
            return true;
        }
    }
}

