/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.ShareTorrentDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class SendFileProgressDialog
extends JDialog {
    private static final Log LOG = LogFactory.getLog(SendFileProgressDialog.class);
    private JProgressBar _progressBar;
    private JButton _cancelButton;
    private static final long serialVersionUID = 8298555975449164242L;
    private Container _container;
    private TOTorrentCreator _torrentCreator;
    private int _percent_complete;
    private File _preselectedFile;

    public SendFileProgressDialog(JFrame jFrame, File file) {
        this(jFrame);
        this._preselectedFile = file;
    }

    public SendFileProgressDialog(JFrame jFrame) {
        super(jFrame);
        this.setupUI();
        this.setLocationRelativeTo(jFrame);
    }

    protected void setupUI() {
        this.setupWindow();
        this.initProgressBar();
        this.initCancelButton();
    }

    public void setupWindow() {
        String string = I18n.tr("Preparing selection");
        this.setTitle(string + ", " + I18n.tr("please wait..."));
        Dimension dimension = new Dimension(512, 100);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                SendFileProgressDialog.this.this_windowOpened(windowEvent);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (SendFileProgressDialog.this._torrentCreator != null) {
                    SendFileProgressDialog.this._torrentCreator.cancel();
                }
            }
        });
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this._container = this.getContentPane();
        this._container.setLayout(new GridBagLayout());
    }

    private void initCancelButton() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this._cancelButton = new JButton(I18n.tr("Cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendFileProgressDialog.this.onCancelButton();
            }
        });
        this._container.add((Component)this._cancelButton, gridBagConstraints);
    }

    protected void onCancelButton() {
        if (this._torrentCreator != null) {
            this._torrentCreator.cancel();
        }
        this.dispose();
    }

    private void initProgressBar() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridwidth = -1;
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setStringPainted(true);
        this._container.add((Component)this._progressBar, gridBagConstraints);
    }

    protected void this_windowOpened(WindowEvent windowEvent) {
        if (this._preselectedFile == null) {
            this.chooseFile();
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this.makeTorrentAndDownload(SendFileProgressDialog.this._preselectedFile.getAbsoluteFile());
                }
            }).start();
        }
    }

    public void chooseFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setDialogTitle(I18n.tr("Select the content you want to send"));
        jFileChooser.setApproveButtonText(I18n.tr("Select"));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            final File file = jFileChooser.getSelectedFile();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this.makeTorrentAndDownload(file.getAbsoluteFile());
                }
            }).start();
        } else if (n == 1) {
            this.onCancelButton();
        } else if (n == -1) {
            LOG.error("Error selecting the file");
        }
    }

    private void updateProgressBarText() {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                SendFileProgressDialog.this._progressBar.setString("Preparing files (" + SendFileProgressDialog.this._percent_complete + " %)");
                SendFileProgressDialog.this._progressBar.setValue(SendFileProgressDialog.this._percent_complete);
            }
        });
    }

    protected void torrentCreator_reportProgress(int n) {
        this._percent_complete = n;
        this.updateProgressBarText();
    }

    private void makeTorrentAndDownload(final File file) {
        try {
            this._torrentCreator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, new URL("http://"), false);
            this._torrentCreator.addListener(new TOTorrentProgressListener(){

                @Override
                public void reportProgress(int n) {
                    SendFileProgressDialog.this.torrentCreator_reportProgress(n);
                }

                @Override
                public void reportCurrentTask(String string) {
                }
            });
            final TOTorrent tOTorrent = this._torrentCreator.create();
            TorrentUtils.setDecentralised(tOTorrent);
            TorrentUtils.setDHTBackupEnabled(tOTorrent, true);
            TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{new URL("udp://tracker.openbittorrent.com:80"), new URL("udp://tracker.publicbt.com:80"), new URL("udp://tracker.ccc.de:80")});
            tOTorrent.getAnnounceURLGroup().setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{tOTorrentAnnounceURLSet});
            TorrentUtils.setPrivate(tOTorrent, false);
            LocaleTorrentUtil.setDefaultTorrentEncoding(tOTorrent);
            final File file2 = new File(SharingSettings.TORRENTS_DIR_SETTING.getValue(), file.getName() + ".torrent");
            tOTorrent.serialiseToBEncodedFile(file2.getAbsoluteFile());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this.dispose();
                    GUIMediator.instance().openTorrentForSeed(file2, file.getParentFile());
                    new ShareTorrentDialog(tOTorrent).setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this._progressBar.setString("There was an error. Make sure the file/folder is not empty.");
                }
            });
        }
    }
}

