/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.HttpFetcher;
import com.frostwire.HttpFetcherListener;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;

public class ShareTorrentDialog
extends JDialog {
    private static final long serialVersionUID = -7466273012830791935L;
    private TOTorrent _torrent;
    private Container _container;
    private JLabel _introLabel;
    private JEditorPane _textArea;
    private JLabel _tipsLabel;
    private Action[] _actions;
    private JLabel _feedbackLabel;
    private AbstractHttpFetcherListener _bitlyShortnerListener;
    private AbstractHttpFetcherListener _tinyurlShortnerListener;
    private List<AbstractHttpFetcherListener> _shortnerListeners;
    private String _link;
    private String _info_hash;
    private String _torrent_name;

    public ShareTorrentDialog(TOTorrent tOTorrent) {
        this._torrent = tOTorrent;
        this.setupUI();
    }

    private void initURLShortnerListeners() {
        this._bitlyShortnerListener = new AbstractHttpFetcherListener("http://api.bit.ly/v3/shorten?format=txt&login=frostwire&apiKey=R_749968a37da3260493d8aa19ee021d14&longUrl=" + UrlUtils.encode(this.getLink())){

            @Override
            public void onSuccess(byte[] byArray) {
                ShareTorrentDialog.this._link = new String(byArray);
                ShareTorrentDialog.this.updateTextArea();
            }

            @Override
            HttpFetcher.HttpRequestInfo getRequestInfo() {
                return new HttpFetcher.HttpRequestInfo(true, null, null);
            }
        };
        this._tinyurlShortnerListener = new AbstractHttpFetcherListener("http://tinyurl.com/api-create.php?url=" + this.getLink()){

            @Override
            public void onSuccess(byte[] byArray) {
                ShareTorrentDialog.this._link = new String(byArray);
                ShareTorrentDialog.this.updateTextArea();
            }

            @Override
            HttpFetcher.HttpRequestInfo getRequestInfo() {
                return new HttpFetcher.HttpRequestInfo(true, null, null);
            }
        };
        this._shortnerListeners = new LinkedList<AbstractHttpFetcherListener>(Arrays.asList(this._bitlyShortnerListener, this._tinyurlShortnerListener));
    }

    private void updateTextArea() {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                ShareTorrentDialog.this._textArea.setText(I18n.tr("Download") + " \"" + ShareTorrentDialog.this._torrent_name.replace("_", " ") + "\" " + I18n.tr("at") + " " + ShareTorrentDialog.this.getLink() + " " + I18n.tr("via FrostWire"));
            }
        });
    }

    private void setupUI() {
        this.setupWindow();
        this.initTorrentname();
        this.initInfoHash();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 10, 10, 10);
        TOTorrentFile[] tOTorrentFileArray = this._torrent.getFiles();
        boolean bl = tOTorrentFileArray.length > 1;
        this._introLabel = new JLabel(bl ? String.format(I18n.tr("Use the following text to share the \"%s\" folder"), this._torrent_name) : String.format(String.format("Use the following text to share the \"%s\" file", this._torrent_name), new Object[0]));
        this._introLabel.setFont(new Font("Dialog", 0, 12));
        this._container.add((Component)this._introLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(1, 10, 1, 10);
        this._textArea = new JEditorPane();
        this._textArea.setEditable(false);
        this.updateTextArea();
        Font font = new Font("Dialog", 1, 13);
        this._textArea.setFont(font);
        this._textArea.setMargin(new Insets(10, 10, 10, 10));
        this._textArea.selectAll();
        this._textArea.setBorder(BorderFactory.createEtchedBorder());
        this._container.add((Component)this._textArea, gridBagConstraints);
        this.initURLShortnerListeners();
        this.performAsyncURLShortening(this._shortnerListeners.get(0));
        this.initActions();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ButtonRow buttonRow = new ButtonRow(this._actions, 0, 13);
        this.fixButtonBorders(buttonRow);
        ToolTipManager.sharedInstance().setInitialDelay(200);
        this._container.add((Component)buttonRow, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this._tipsLabel = new JLabel("<html><p> > <strong>Keep FrostWire Open</strong> until the file has been downloaded by at least one other friend.</p><p>&nbsp;</p><p> > <strong>The more, the merrier.</strong> The more people sharing the faster it can be downloaded by others.</p><p>&nbsp;</p><p> > <strong>Your files can be discovered by others.</strong> Once you share this link and you seed the files they will be available to everybody on the BitTorrent network.</p></html>");
        this._tipsLabel.setFont(new Font("Dialog", 0, 12));
        this._tipsLabel.setBorder(BorderFactory.createTitledBorder(I18n.tr("Tips")));
        this._container.add((Component)this._tipsLabel, gridBagConstraints);
        JPanel jPanel = (JPanel)this.getGlassPane();
        jPanel.setLayout(null);
        jPanel.setVisible(true);
        this._feedbackLabel = new JLabel("Feedback here to clipboard");
        this._feedbackLabel.setVisible(false);
        this._feedbackLabel.setFont(new Font("Arial", 1, 14));
        jPanel.add(this._feedbackLabel);
        this._feedbackLabel.setBounds(100, 100, 300, 20);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.pack();
    }

    private void fixButtonBorders(ButtonRow buttonRow) {
        if (this._actions == null) {
            return;
        }
        for (int i = 0; i < this._actions.length; ++i) {
            JButton jButton = buttonRow.getButtonAtIndex(i);
            jButton.setBorderPainted(true);
        }
    }

    private void initTorrentname() {
        this._torrent_name = this._torrent.getUTF8Name();
        if (this._torrent_name == null) {
            this._torrent_name = new String(this._torrent.getName());
        }
    }

    private void initInfoHash() {
        try {
            this._info_hash = TorrentUtil.hashToString(this._torrent.getHash());
        }
        catch (TOTorrentException tOTorrentException) {
            // empty catch block
        }
    }

    private String getLink() {
        if (this._link == null) {
            this._link = "http://maglnk.com/" + this._info_hash + "/?" + TorrentUtil.getMagnetURLParameters(this._torrent);
        }
        return this._link;
    }

    private void performAsyncURLShortening(AbstractHttpFetcherListener abstractHttpFetcherListener) {
        HttpFetcher httpFetcher = new HttpFetcher(abstractHttpFetcherListener.getShortenerURL(), 2000);
        httpFetcher.asyncRequest(abstractHttpFetcherListener.getRequestInfo(), abstractHttpFetcherListener);
    }

    private void initActions() {
        this._actions = new Action[4];
        this._actions[0] = new TwitterAction();
        this._actions[1] = new CopyToClipboardAction();
        this._actions[2] = new CopyLinkAction();
        this._actions[3] = new CopyMagnetAction();
    }

    private void setupWindow() {
        this.setTitle(I18n.tr("All done! Now share the link"));
        Dimension dimension = new Dimension(540, 380);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this._container = this.getContentPane();
        this._container.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setInitialDelay(500);
            }
        });
    }

    public void showFeedback(String string, double d, double d2) {
        int n = (int)(d2 - this.getLocationOnScreen().getY() - 40.0);
        this._feedbackLabel.setLocation((int)(d - this.getLocationOnScreen().getX()), n);
        this._feedbackLabel.setVisible(true);
        this._feedbackLabel.setText(string);
        int n2 = 50;
        Timeline timeline = new Timeline(new TimelineJLabel(this._feedbackLabel));
        timeline.addCallback(new TimelineCallbackAdapter(){

            @Override
            public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                if (timelineState2 == Timeline.TimelineState.DONE) {
                    ShareTorrentDialog.this._feedbackLabel.setVisible(false);
                }
            }
        });
        timeline.setDuration(800L);
        timeline.addPropertyToInterpolate("y", n, n - n2);
        timeline.addPropertyToInterpolate("color", Color.BLACK, this._feedbackLabel.getBackground());
        timeline.play();
    }

    private class CopyMagnetAction
    extends AbstractAction {
        private static final long serialVersionUID = 4972170728829407730L;

        public CopyMagnetAction() {
            this.putValue("Name", I18n.tr("Copy Magnet"));
            this.putValue("ShortDescription", I18n.tr("Copy Magnet URL to Clipboard"));
            this.putValue("LimeIconName", "MAGNET");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.setClipboardContent(TorrentUtil.getMagnet(ShareTorrentDialog.this._info_hash) + "&" + TorrentUtil.getMagnetURLParameters(ShareTorrentDialog.this._torrent));
            ShareTorrentDialog.this.setTitle(I18n.tr("Magnet copied to clipboard."));
            JButton jButton = (JButton)actionEvent.getSource();
            ShareTorrentDialog.this.showFeedback(ShareTorrentDialog.this.getTitle(), jButton.getLocationOnScreen().getX(), jButton.getLocationOnScreen().getY());
        }
    }

    public class CopyLinkAction
    extends AbstractAction {
        private static final long serialVersionUID = 5396173442291772242L;

        public CopyLinkAction() {
            this.putValue("Name", I18n.tr("Copy Link"));
            this.putValue("ShortDescription", I18n.tr("Copy Link to Clipboard"));
            this.putValue("LimeIconName", "LINK");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.setClipboardContent(ShareTorrentDialog.this._link);
            ShareTorrentDialog.this.setTitle(I18n.tr("Link copied to clipboard."));
            JButton jButton = (JButton)actionEvent.getSource();
            ShareTorrentDialog.this.showFeedback(ShareTorrentDialog.this.getTitle(), jButton.getLocationOnScreen().getX(), jButton.getLocationOnScreen().getY());
        }
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        private static final long serialVersionUID = 2130811125951128397L;

        public CopyToClipboardAction() {
            this.putValue("Name", I18n.tr("Copy Text"));
            this.putValue("ShortDescription", I18n.tr("Copy entire message to Clipboard"));
            this.putValue("LimeIconName", "COPY_PASTE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.setClipboardContent(ShareTorrentDialog.this._textArea.getText());
            ShareTorrentDialog.this.setTitle(I18n.tr("Message copied to clipboard."));
            JButton jButton = (JButton)actionEvent.getSource();
            ShareTorrentDialog.this.showFeedback(ShareTorrentDialog.this.getTitle(), jButton.getLocationOnScreen().getX(), jButton.getLocationOnScreen().getY());
        }
    }

    private class TwitterAction
    extends AbstractAction {
        private static final long serialVersionUID = -2035234758115291468L;

        public TwitterAction() {
            this.putValue("Name", I18n.tr("Twitter it"));
            this.putValue("ShortDescription", I18n.tr("Send the message above to Twitter"));
            this.putValue("LimeIconName", "TWITTER");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.openURL("http://twitter.com/intent/tweet?source=FrostWire&text=" + UrlUtils.encode(ShareTorrentDialog.this._textArea.getText()));
        }
    }

    public static class TimelineJLabel {
        public int y;
        public Color color;
        private JLabel _label;
        private int x;

        public TimelineJLabel(JLabel jLabel) {
            this._label = jLabel;
            this.x = (int)this._label.getLocation().getX();
        }

        public void setColor(Color color) {
            this.color = color;
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineJLabel.this._label.setForeground(TimelineJLabel.this.color);
                }
            });
        }

        public void setY(int n) {
            this.y = n;
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineJLabel.this._label.setLocation(TimelineJLabel.this.x, TimelineJLabel.this.y);
                }
            });
        }
    }

    private abstract class AbstractHttpFetcherListener
    implements HttpFetcherListener {
        private URI _shortenerUri;

        public AbstractHttpFetcherListener(String string) {
            try {
                this._shortenerUri = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (ShareTorrentDialog.this._shortnerListeners.size() > 1) {
                ShareTorrentDialog.this._shortnerListeners.remove(0);
                ShareTorrentDialog.this.performAsyncURLShortening((AbstractHttpFetcherListener)ShareTorrentDialog.this._shortnerListeners.get(0));
                System.out.println(">>> AbstractHttpFetcherListener ERROR >>>");
                throwable.printStackTrace();
                System.out.println();
                System.out.println("URL: [" + this._shortenerUri.toString() + "]");
                System.out.println(">>> AbstractHttpFetcherListener ERROR >>>");
            }
        }

        @Override
        public abstract void onSuccess(byte[] var1);

        public URI getShortenerURL() {
            return this._shortenerUri;
        }

        abstract HttpFetcher.HttpRequestInfo getRequestInfo();
    }

    public class GoogleShortenerResponse {
        public String kind;
        public String id;
        public String longUrl;
    }
}

