/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appwork.utils.StringUtils;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.jdownloader.controlling.filter.LinkFilterController;

public class SoundcloudTrackUrlDownload
implements BTDownload {
    private static final Log LOG = LogFactory.getLog(SoundcloudTrackUrlDownload.class);
    private static final String STATE_CRAWLING = I18n.tr("Crawling");
    private static final String STATE_FINISHED = I18n.tr("Finished");
    private static final String STATE_ERROR = I18n.tr("Error");
    private static final String STATE_STOPPED = I18n.tr("Stopped");
    private final String trackUrl;
    private final String title;
    private final Date dateCreated;
    private String _state;
    private int progress;

    public SoundcloudTrackUrlDownload(String string, String string2) {
        if (!string.startsWith("http://")) {
            string = "http://" + string;
        }
        this.trackUrl = string;
        this.title = string2;
        this.dateCreated = new Date();
        this._state = STATE_CRAWLING;
        this.start();
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public long getSize(boolean bl) {
        return 0L;
    }

    @Override
    public String getDisplayName() {
        return this.trackUrl;
    }

    @Override
    public boolean isResumable() {
        return false;
    }

    @Override
    public boolean isPausable() {
        return false;
    }

    @Override
    public boolean isCompleted() {
        return this._state.equals(STATE_FINISHED);
    }

    @Override
    public int getState() {
        return -1;
    }

    @Override
    public void remove() {
        this._state = STATE_STOPPED;
    }

    @Override
    public void pause() {
    }

    @Override
    public File getSaveLocation() {
        return null;
    }

    @Override
    public void resume() {
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public String getStateString() {
        return this._state;
    }

    @Override
    public long getBytesReceived() {
        return 0L;
    }

    @Override
    public long getBytesSent() {
        return 0L;
    }

    @Override
    public double getDownloadSpeed() {
        return 0.0;
    }

    @Override
    public double getUploadSpeed() {
        return 0.0;
    }

    @Override
    public long getETA() {
        return 0L;
    }

    @Override
    public DownloadManager getDownloadManager() {
        return null;
    }

    @Override
    public String getPeersString() {
        return "";
    }

    @Override
    public String getSeedsString() {
        return "";
    }

    @Override
    public boolean isDeleteTorrentWhenRemove() {
        return false;
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean bl) {
    }

    @Override
    public boolean isDeleteDataWhenRemove() {
        return false;
    }

    @Override
    public void setDeleteDataWhenRemove(boolean bl) {
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public String getSeedToPeerRatio() {
        return "";
    }

    @Override
    public String getShareRatio() {
        return "";
    }

    @Override
    public boolean isPartialDownload() {
        return false;
    }

    @Override
    public void updateDownloadManager(DownloadManager downloadManager) {
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    private void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LinkCollector linkCollector = LinkCollector.getInstance();
                    LinkCrawler linkCrawler = new LinkCrawler();
                    linkCrawler.setFilter(LinkFilterController.getInstance());
                    linkCrawler.crawl(SoundcloudTrackUrlDownload.this.trackUrl);
                    linkCrawler.waitForCrawling();
                    if (SoundcloudTrackUrlDownload.this._state.equals(STATE_STOPPED)) {
                        return;
                    }
                    SoundcloudTrackUrlDownload.this._state = STATE_FINISHED;
                    SoundcloudTrackUrlDownload.this.progress = 100;
                    final ArrayList<FilePackage> arrayList = new ArrayList<FilePackage>();
                    for (CrawledLink crawledLink : linkCrawler.getCrawledLinks()) {
                        CrawledPackage crawledPackage = SoundcloudTrackUrlDownload.this.createCrawledPackage(crawledLink);
                        crawledPackage.setControlledBy(linkCollector);
                        crawledLink.setParentNode(crawledPackage);
                        ArrayList<CrawledLink> arrayList2 = new ArrayList<CrawledLink>();
                        arrayList2.add(crawledLink);
                        arrayList.add(SoundcloudTrackUrlDownload.this.createFilePackage(crawledPackage, arrayList2));
                    }
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                for (FilePackage filePackage : arrayList) {
                                    BTDownloadMediator.instance().openSoundcloudItem(filePackage, SoundcloudTrackUrlDownload.this.title);
                                }
                            }
                            catch (Throwable throwable) {
                                LOG.error("Error reading soundcloud package:" + throwable.getMessage(), throwable);
                                SoundcloudTrackUrlDownload.this._state = STATE_ERROR;
                            }
                        }
                    });
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            BTDownloadMediator.instance().remove(SoundcloudTrackUrlDownload.this);
                        }
                    });
                }
                catch (Throwable throwable) {
                    LOG.error("Error crawling soundcloud: " + SoundcloudTrackUrlDownload.this.trackUrl, throwable);
                    SoundcloudTrackUrlDownload.this._state = STATE_ERROR;
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("Soundcloud Crawl: " + this.trackUrl);
        thread.start();
    }

    private CrawledPackage createCrawledPackage(CrawledLink crawledLink) {
        CrawledPackage crawledPackage = new CrawledPackage();
        String string = this.title;
        if (StringUtils.isEmpty(string)) {
            string = LinknameCleaner.cleanFileName(crawledLink.getName());
            crawledPackage.setName(string);
        } else {
            crawledPackage.setName(string);
        }
        crawledPackage.setCreated(crawledLink.getCreated());
        crawledPackage.setComment("");
        return crawledPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilePackage createFilePackage(CrawledPackage crawledPackage, ArrayList<CrawledLink> arrayList) {
        FilePackage filePackage = FilePackage.getInstance();
        filePackage.setName(crawledPackage.getName());
        filePackage.setDownloadDirectory(crawledPackage.getDownloadFolder());
        filePackage.setCreated(crawledPackage.getCreated());
        filePackage.setExpanded(crawledPackage.isExpanded());
        filePackage.setComment(crawledPackage.getComment());
        CrawledPackage crawledPackage2 = crawledPackage;
        synchronized (crawledPackage2) {
            ArrayList<DownloadLink> arrayList2 = new ArrayList<DownloadLink>(crawledPackage.getChildren().size());
            List<CrawledLink> list = crawledPackage.getChildren();
            if (arrayList != null && arrayList.size() > 0) {
                list = new ArrayList<CrawledLink>(arrayList);
            }
            for (CrawledLink crawledLink : list) {
                DownloadLink downloadLink = crawledLink.getDownloadLink();
                if (downloadLink == null) continue;
                if (crawledLink.isNameSet()) {
                    downloadLink.forceFileName(crawledLink.getName());
                }
                downloadLink.setNodeChangeListener(null);
                downloadLink.setCreated(crawledLink.getCreated());
                arrayList2.add(downloadLink);
                downloadLink.setParentNode(filePackage);
            }
            filePackage.getChildren().addAll(arrayList2);
        }
        return filePackage;
    }
}

