/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadCreator;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.DuplicateDownload;
import com.frostwire.gui.bittorrent.PartialFilesDialog;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TorrentFetcherDownload
implements BTDownload {
    private static final String STATE_DOWNLOADING = I18n.tr("Downloading Torrent");
    private static final String STATE_ERROR = I18n.tr("Error");
    private static final String STATE_CANCELED = I18n.tr("Canceled");
    private String _uri;
    private final String _torrentSaveDir;
    private TorrentDownloader _torrentDownloader;
    private final String _displayName;
    private final String _hash;
    private final long _size;
    private final boolean _partialDownload;
    private final ActionListener _postPartialDownloadAction;
    private final Date dateCreated;
    private String _state;
    private boolean _removed;
    private BTDownload _delegate;
    private String relativePath;

    public TorrentFetcherDownload(String string, String string2, String string3, String string4, long l, boolean bl, ActionListener actionListener) {
        this._uri = string;
        this._torrentSaveDir = SharingSettings.TORRENTS_DIR_SETTING.getValue().getAbsolutePath();
        this._torrentDownloader = TorrentDownloaderFactory.create(new TorrentDownloaderListener(), this._uri, string2, this._torrentSaveDir);
        this._displayName = string3;
        this._hash = string4 != null ? string4 : "";
        this._size = l;
        this._partialDownload = bl;
        this._postPartialDownloadAction = actionListener;
        this.dateCreated = new Date();
        this._state = STATE_DOWNLOADING;
        this._torrentDownloader.start();
    }

    public TorrentFetcherDownload(String string, boolean bl, ActionListener actionListener) {
        this(string, null, TorrentFetcherDownload.getDownloadNameFromMagnetURI(string), "", -1L, bl, actionListener);
    }

    public TorrentFetcherDownload(String string, String string2, ActionListener actionListener) {
        this(string, null, TorrentFetcherDownload.getDownloadNameFromMagnetURI(string), "", -1L, true, actionListener);
        this.relativePath = string2;
    }

    public TorrentFetcherDownload(String string, String string2, String string3, String string4, ActionListener actionListener) {
        this(string, string2, TorrentFetcherDownload.getDownloadNameFromMagnetURI(string), string4, -1L, true, actionListener);
        this.relativePath = string3;
    }

    private static String getDownloadNameFromMagnetURI(String string) {
        if (!string.startsWith("magnet:")) {
            return string;
        }
        if (string.contains("dn=")) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&")) {
                if (!string2.toLowerCase().startsWith("dn=") || string2.length() <= 3) continue;
                return UrlUtils.decode(string2.split("=")[1]);
            }
        }
        return string;
    }

    @Override
    public long getSize() {
        return this._delegate != null ? this._delegate.getSize() : this._size;
    }

    @Override
    public String getDisplayName() {
        return this._delegate != null ? this._delegate.getDisplayName() : this._displayName;
    }

    @Override
    public boolean isResumable() {
        return this._delegate != null ? this._delegate.isResumable() : false;
    }

    @Override
    public boolean isPausable() {
        return this._delegate != null ? this._delegate.isPausable() : false;
    }

    @Override
    public boolean isCompleted() {
        return this._delegate != null ? this._delegate.isCompleted() : false;
    }

    @Override
    public int getState() {
        return this._delegate != null ? this._delegate.getState() : -1;
    }

    @Override
    public void remove() {
        if (this._delegate != null) {
            this._delegate.remove();
        } else {
            this._removed = true;
            try {
                this._torrentDownloader.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this._torrentDownloader.getFile().delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void pause() {
        if (this._delegate != null) {
            this._delegate.pause();
        }
    }

    @Override
    public void resume() {
        if (this._delegate != null) {
            this._delegate.resume();
        }
    }

    @Override
    public File getSaveLocation() {
        return this._delegate != null ? this._delegate.getSaveLocation() : null;
    }

    @Override
    public int getProgress() {
        return this._delegate != null ? this._delegate.getProgress() : 0;
    }

    @Override
    public String getStateString() {
        return this._delegate != null ? this._delegate.getStateString() : this._state;
    }

    @Override
    public long getBytesReceived() {
        return this._delegate != null ? this._delegate.getBytesReceived() : 0L;
    }

    @Override
    public long getBytesSent() {
        return this._delegate != null ? this._delegate.getBytesSent() : 0L;
    }

    @Override
    public double getDownloadSpeed() {
        return this._delegate != null ? this._delegate.getDownloadSpeed() : 0.0;
    }

    @Override
    public double getUploadSpeed() {
        return this._delegate != null ? this._delegate.getUploadSpeed() : 0.0;
    }

    @Override
    public long getETA() {
        return this._delegate != null ? this._delegate.getETA() : 0L;
    }

    @Override
    public DownloadManager getDownloadManager() {
        return this._delegate != null ? this._delegate.getDownloadManager() : null;
    }

    @Override
    public String getPeersString() {
        return this._delegate != null ? this._delegate.getPeersString() : "";
    }

    @Override
    public String getSeedsString() {
        return this._delegate != null ? this._delegate.getSeedsString() : "";
    }

    @Override
    public boolean isDeleteTorrentWhenRemove() {
        return this._delegate != null ? this._delegate.isDeleteTorrentWhenRemove() : false;
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean bl) {
        if (this._delegate != null) {
            this._delegate.setDeleteTorrentWhenRemove(bl);
        }
    }

    @Override
    public boolean isDeleteDataWhenRemove() {
        return this._delegate != null ? this._delegate.isDeleteDataWhenRemove() : false;
    }

    @Override
    public void setDeleteDataWhenRemove(boolean bl) {
        if (this._delegate != null) {
            this._delegate.setDeleteDataWhenRemove(bl);
        }
    }

    @Override
    public String getHash() {
        return this._delegate != null ? this._delegate.getHash() : this._hash;
    }

    @Override
    public String getSeedToPeerRatio() {
        return this._delegate != null ? this._delegate.getSeedToPeerRatio() : "";
    }

    @Override
    public String getShareRatio() {
        return this._delegate != null ? this._delegate.getShareRatio() : "";
    }

    @Override
    public Date getDateCreated() {
        return this._delegate != null ? this._delegate.getDateCreated() : this.dateCreated;
    }

    @Override
    public boolean isPartialDownload() {
        return this._delegate != null ? this._delegate.isPartialDownload() : this._partialDownload;
    }

    @Override
    public long getSize(boolean bl) {
        return this._delegate != null ? this._delegate.getSize(bl) : this._size;
    }

    @Override
    public void updateDownloadManager(DownloadManager downloadManager) {
        if (this._delegate != null) {
            this._delegate.updateDownloadManager(downloadManager);
        }
    }

    private final class TorrentDownloaderListener
    implements TorrentDownloaderCallBackInterface {
        private boolean[] filesSelection;
        private AtomicBoolean finished = new AtomicBoolean(false);

        private TorrentDownloaderListener() {
        }

        @Override
        public void TorrentDownloaderEvent(int n, final TorrentDownloader torrentDownloader) {
            if (TorrentFetcherDownload.this._removed) {
                return;
            }
            if (n == 3 && this.finished.compareAndSet(false, true)) {
                try {
                    Object object;
                    if (TorrentFetcherDownload.this.relativePath != null) {
                        object = TorrentUtils.readFromFile(torrentDownloader.getFile(), false);
                        this.filesSelection = new boolean[object.getFiles().length];
                        for (int i = 0; i < this.filesSelection.length; ++i) {
                            this.filesSelection[i] = object.getFiles()[i].getRelativePath().equals(TorrentFetcherDownload.this.relativePath);
                        }
                    } else if (TorrentFetcherDownload.this._partialDownload) {
                        GUIMediator.safeInvokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PartialFilesDialog partialFilesDialog = new PartialFilesDialog(GUIMediator.getAppFrame(), torrentDownloader.getFile());
                                    partialFilesDialog.setVisible(true);
                                    TorrentDownloaderListener.access$402(TorrentDownloaderListener.this, partialFilesDialog.getFilesSelection());
                                }
                                catch (TOTorrentException tOTorrentException) {
                                    System.out.println("Error reading torrent:" + tOTorrentException.getMessage());
                                    TorrentDownloaderListener.access$402(TorrentDownloaderListener.this, null);
                                }
                            }
                        });
                        if (this.filesSelection == null) {
                            this.cancelDownload();
                            return;
                        }
                        if (TorrentFetcherDownload.this._postPartialDownloadAction != null) {
                            try {
                                TorrentFetcherDownload.this._postPartialDownloadAction.actionPerformed(null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    object = new BTDownloadCreator(torrentDownloader.getFile(), this.filesSelection);
                    TorrentFetcherDownload.this._delegate = ((BTDownloadCreator)object).createDownload();
                    if (TorrentFetcherDownload.this._delegate instanceof DuplicateDownload) {
                        this.cancelDownload();
                        GUIMediator.safeInvokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BTDownloadMediator.instance().selectRowByDownload(TorrentFetcherDownload.this._delegate);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    TorrentFetcherDownload.this._state = STATE_ERROR;
                    exception.printStackTrace();
                }
            } else if (n == 4) {
                if (TorrentFetcherDownload.this._hash != null && TorrentFetcherDownload.this._hash.trim() != "" && (TorrentFetcherDownload.this._uri.toLowerCase().startsWith("http://") || TorrentFetcherDownload.this._uri.toLowerCase().startsWith("https://"))) {
                    TorrentFetcherDownload.this._uri = TorrentUtil.getMagnet(TorrentFetcherDownload.this._hash);
                    TorrentFetcherDownload.this._torrentDownloader = TorrentDownloaderFactory.create(new TorrentDownloaderListener(), TorrentFetcherDownload.this._uri, null, TorrentFetcherDownload.this._torrentSaveDir);
                    TorrentFetcherDownload.this._state = STATE_DOWNLOADING;
                    TorrentFetcherDownload.this._torrentDownloader.start();
                } else {
                    TorrentFetcherDownload.this._state = STATE_ERROR;
                }
            }
        }

        public void cancelDownload() {
            TorrentFetcherDownload.this._state = STATE_CANCELED;
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    BTDownloadMediator.instance().remove(TorrentFetcherDownload.this);
                }
            });
        }

        static /* synthetic */ boolean[] access$402(TorrentDownloaderListener torrentDownloaderListener, boolean[] blArray) {
            torrentDownloaderListener.filesSelection = blArray;
            return blArray;
        }
    }
}

