/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.limewire.util.OSUtils;

public class TorrentSaveFolderComponent
extends JPanel {
    private static final long serialVersionUID = -6564593945827058369L;
    private JTextField folderTextField = new JTextField(SharingSettings.TORRENT_DATA_DIR_SETTING.getValueAsString());
    private static String errorMessage;

    public TorrentSaveFolderComponent(boolean bl) {
        this.setLayout(new GridBagLayout());
        if (bl) {
            this.putClientProperty("CLIENT_PROPERTY_DARK_DARK_NOISE", true);
            this.setBorder(ThemeMediator.CURRENT_THEME.getCustomUI().createTitledBorder(I18n.tr("Torrent Data Save Folder")));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.folderTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)new ButtonRow(new Action[]{new DefaultAction(), new BrowseAction()}, 0, 12), gridBagConstraints);
    }

    public String getTorrentSaveFolderPath() {
        return this.folderTextField.getText();
    }

    public boolean isTorrentSaveFolderPathValid(boolean bl) {
        if (this.folderTextField.getText().trim().length() == 0) {
            errorMessage = I18n.tr("You forgot to enter a path for the Torrent Data Folder.");
            return false;
        }
        String string = this.folderTextField.getText().trim();
        File file = new File(string);
        return TorrentSaveFolderComponent.isTorrentSaveFolderPathValid(bl, file);
    }

    public static boolean isTorrentSaveFolderPathValid(boolean bl, File file) {
        if (!(!bl || file.exists() && file.isDirectory() && file.canWrite())) {
            errorMessage = I18n.tr("Please enter a valid path for the Torrent Data Folder");
            return false;
        }
        String string = file.getAbsolutePath().toLowerCase();
        return !OSUtils.isWindows() || !string.contains(System.getenv("ProgramFiles").toLowerCase());
    }

    public static boolean isParentOrChild(File file, File file2, String string) {
        try {
            if (file.getCanonicalPath().startsWith(file2.getCanonicalPath())) {
                errorMessage = I18n.tr("The Torrent Data Folder cannot be inside the " + string);
                return true;
            }
        }
        catch (IOException iOException) {
            errorMessage = I18n.tr("Could not resolve folder path.");
            return true;
        }
        try {
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
                errorMessage = I18n.tr("The Torrent Data Folder cannot be a parent folder of the " + string);
                return true;
            }
        }
        catch (IOException iOException) {
            errorMessage = I18n.tr("Could not resolve folder path.");
            return true;
        }
        return false;
    }

    public static String getError() {
        return errorMessage;
    }

    private class BrowseAction
    extends AbstractAction {
        private static final long serialVersionUID = 2976380710515726420L;

        public BrowseAction() {
            this.putValue("Name", I18n.tr("Browse..."));
            this.putValue("ShortDescription", I18n.tr("Choose Another Folder"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileChooserHandler.getInputDirectory(TorrentSaveFolderComponent.this);
            if (file == null || !file.isDirectory()) {
                return;
            }
            TorrentSaveFolderComponent.this.folderTextField.setText(file.getAbsolutePath());
        }
    }

    private class DefaultAction
    extends AbstractAction {
        private static final long serialVersionUID = 7266666461649699221L;

        public DefaultAction() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Use the Default Folder"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TorrentSaveFolderComponent.this.folderTextField.setText(SharingSettings.DEFAULT_TORRENT_DATA_DIR.getAbsolutePath());
        }
    }
}

