/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.frostwire.AzureusStarter;
import com.limegroup.gnutella.settings.iTunesImportSettings;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.NetworkUtils;
import org.limewire.util.StringUtils;

public final class TorrentUtil {
    private static final Log LOG = LogFactory.getLog(TorrentUtil.class);
    private static AsyncDispatcher async = new AsyncDispatcher(2000);

    public static boolean shouldStopGroup(Object[] objectArray) {
        DownloadManager[] downloadManagerArray = TorrentUtil.toDMS(objectArray);
        if (downloadManagerArray.length == 0) {
            return true;
        }
        for (DownloadManager downloadManager : downloadManagerArray) {
            boolean bl;
            int n = downloadManager.getState();
            boolean bl2 = bl = n == 70 || n == 65;
            if (bl) continue;
            return true;
        }
        return false;
    }

    public static void stopOrStartDataSources(Object[] objectArray) {
        Object[] objectArray2 = TorrentUtil.toDMS(objectArray);
        if (objectArray2.length == 0) {
            return;
        }
        boolean bl = TorrentUtil.shouldStopGroup(objectArray2);
        if (bl) {
            TorrentUtil.stopDataSources(objectArray);
        } else {
            TorrentUtil.queueDataSources(objectArray, true);
        }
    }

    public static void stopDataSources(Object[] objectArray) {
        DownloadManager[] downloadManagerArray;
        for (DownloadManager downloadManager : downloadManagerArray = TorrentUtil.toDMS(objectArray)) {
            TorrentUtil.stop(downloadManager);
        }
    }

    public static void queueDataSources(Object[] objectArray, boolean bl) {
        DownloadManager[] downloadManagerArray;
        for (DownloadManager downloadManager : downloadManagerArray = TorrentUtil.toDMS(objectArray)) {
            TorrentUtil.queue(downloadManager);
        }
    }

    public static void removeDownload(DownloadManager downloadManager, boolean bl, boolean bl2) {
        TorrentUtil.removeDownload(downloadManager, bl, bl2, true);
    }

    public static void removeDownload(DownloadManager downloadManager, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            TorrentUtil.asyncStopDelete(downloadManager, 70, bl, bl2, null);
        } else {
            TorrentUtil.blockingStopDelete(downloadManager, 70, bl, bl2, null);
        }
    }

    private static void finalCleanup(DownloadManager downloadManager) {
        Set<File> set = TorrentUtil.getSkippedFiles(downloadManager);
        for (File file : set) {
            try {
                if (TorrentUtil.isSkippedFileComplete(file, downloadManager) || !file.exists() || file.delete()) continue;
                System.out.println("Can't delete file: " + file);
            }
            catch (Exception exception) {
                System.out.println("Can't delete file: " + file + ", ex: " + exception.getMessage());
            }
        }
        FileUtils.deleteEmptyDirectoryRecursive(downloadManager.getSaveLocation());
        iTunesImportSettings.IMPORT_FILES.remove(downloadManager.getSaveLocation());
    }

    private static boolean isSkippedFileComplete(File file, DownloadManager downloadManager) {
        DiskManagerFileInfoSet diskManagerFileInfoSet = downloadManager.getDiskManagerFileInfoSet();
        for (DiskManagerFileInfo diskManagerFileInfo : diskManagerFileInfoSet.getFiles()) {
            File file2;
            if (!diskManagerFileInfo.isSkipped() || !(file2 = diskManagerFileInfo.getFile(false)).getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) continue;
            return diskManagerFileInfo.getLength() == file.length();
        }
        return false;
    }

    public static Set<File> getSkipedFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        if (AzureusStarter.isAzureusCoreStarted()) {
            List list = AzureusStarter.getAzureusCore().getGlobalManager().getDownloadManagers();
            for (Object e : list) {
                DownloadManager downloadManager = (DownloadManager)e;
                hashSet.addAll(TorrentUtil.getSkippedFiles(downloadManager));
            }
        }
        return hashSet;
    }

    public static Set<File> getSkippedFiles(DownloadManager downloadManager) {
        HashSet<File> hashSet = new HashSet<File>();
        DiskManagerFileInfoSet diskManagerFileInfoSet = downloadManager.getDiskManagerFileInfoSet();
        for (DiskManagerFileInfo diskManagerFileInfo : diskManagerFileInfoSet.getFiles()) {
            try {
                if (!diskManagerFileInfo.isSkipped()) continue;
                hashSet.add(diskManagerFileInfo.getFile(false));
            }
            catch (Throwable throwable) {
                LOG.error("Error getting file information", throwable);
            }
        }
        return hashSet;
    }

    public static Set<DiskManagerFileInfo> getNoSkippedFileInfoSet(DownloadManager downloadManager) {
        HashSet<DiskManagerFileInfo> hashSet = new HashSet<DiskManagerFileInfo>();
        DiskManagerFileInfoSet diskManagerFileInfoSet = downloadManager.getDiskManagerFileInfoSet();
        for (DiskManagerFileInfo diskManagerFileInfo : diskManagerFileInfoSet.getFiles()) {
            if (diskManagerFileInfo.isSkipped()) continue;
            hashSet.add(diskManagerFileInfo);
        }
        return hashSet;
    }

    public static Set<File> getIncompleteFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        if (AzureusStarter.isAzureusCoreStarted()) {
            List list = AzureusStarter.getAzureusCore().getGlobalManager().getDownloadManagers();
            for (Object e : list) {
                DownloadManager downloadManager = (DownloadManager)e;
                DiskManagerFileInfoSet diskManagerFileInfoSet = downloadManager.getDiskManagerFileInfoSet();
                for (DiskManagerFileInfo diskManagerFileInfo : diskManagerFileInfoSet.getFiles()) {
                    try {
                        if (TorrentUtil.getDownloadPercent(diskManagerFileInfo) >= 100) continue;
                        hashSet.add(diskManagerFileInfo.getFile(false));
                    }
                    catch (Throwable throwable) {
                        LOG.error("Error getting file information", throwable);
                    }
                }
            }
        }
        return hashSet;
    }

    public static int getDownloadPercent(DiskManagerFileInfo diskManagerFileInfo) {
        long l = diskManagerFileInfo.getLength();
        if (l == 0L || diskManagerFileInfo.getDownloaded() == l) {
            return 100;
        }
        return (int)(diskManagerFileInfo.getDownloaded() * 100L / l);
    }

    public static boolean isStartable(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return false;
        }
        int n = downloadManager.getState();
        return n == 70;
    }

    public static boolean isStopable(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return false;
        }
        int n = downloadManager.getState();
        return n != 70 && n != 65;
    }

    public static boolean isStopped(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return false;
        }
        int n = downloadManager.getState();
        return n == 70 || n == 100;
    }

    public static boolean isForceStartable(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return false;
        }
        int n = downloadManager.getState();
        return n == 70 || n == 75 || n == 60 || n == 50;
    }

    public static void asyncStopDelete(final DownloadManager downloadManager, int n, final boolean bl, final boolean bl2, final AERunnable aERunnable) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                block13: {
                    try {
                        boolean bl3 = bl2 && !downloadManager.getDownloadState().getFlag(64L);
                        downloadManager.getGlobalManager().removeDownloadManager(downloadManager, bl, bl3);
                    }
                    catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                        try {
                            PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
                            ShareManager shareManager = pluginInterface.getShareManager();
                            Tracker tracker = pluginInterface.getTracker();
                            ShareResource[] shareResourceArray = shareManager.getShares();
                            TOTorrent tOTorrent = downloadManager.getTorrent();
                            byte[] byArray = tOTorrent.getHash();
                            for (ShareResource shareResource : shareResourceArray) {
                                int n = shareResource.getType();
                                byte[] byArray2 = n == 2 ? ((ShareResourceDir)shareResource).getItem().getTorrent().getHash() : (n == 1 ? ((ShareResourceFile)shareResource).getItem().getTorrent().getHash() : null);
                                if (byArray2 == null || !Arrays.equals(byArray, byArray2)) continue;
                                try {
                                    downloadManager.stopIt(70, false, false);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                try {
                                    TrackerTorrent trackerTorrent = tracker.getTorrent(PluginCoreUtils.wrap(tOTorrent));
                                    if (trackerTorrent != null) {
                                        trackerTorrent.stop();
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                shareResource.delete();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!globalManagerDownloadRemovalVetoException.isSilent()) {
                            UIFunctionsManager.getUIFunctions().forceNotify(1, MessageText.getString("globalmanager.download.remove.veto"), globalManagerDownloadRemovalVetoException.getMessage(), null, null, -1);
                        }
                        if (aERunnable != null) {
                            aERunnable.runSupport();
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace(exception);
                        if (aERunnable == null) break block13;
                        aERunnable.runSupport();
                    }
                }
                TorrentUtil.finalCleanup(downloadManager);
            }
        });
    }

    public static void blockingStopDelete(DownloadManager downloadManager, int n, boolean bl, boolean bl2, AERunnable aERunnable) {
        block13: {
            try {
                boolean bl3 = bl2 && !downloadManager.getDownloadState().getFlag(64L);
                downloadManager.getGlobalManager().removeDownloadManager(downloadManager, bl, bl3);
            }
            catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                try {
                    PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
                    ShareManager shareManager = pluginInterface.getShareManager();
                    Tracker tracker = pluginInterface.getTracker();
                    ShareResource[] shareResourceArray = shareManager.getShares();
                    TOTorrent tOTorrent = downloadManager.getTorrent();
                    byte[] byArray = tOTorrent.getHash();
                    for (ShareResource shareResource : shareResourceArray) {
                        int n2 = shareResource.getType();
                        byte[] byArray2 = n2 == 2 ? ((ShareResourceDir)shareResource).getItem().getTorrent().getHash() : (n2 == 1 ? ((ShareResourceFile)shareResource).getItem().getTorrent().getHash() : null);
                        if (byArray2 == null || !Arrays.equals(byArray, byArray2)) continue;
                        try {
                            downloadManager.stopIt(70, false, false);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            TrackerTorrent trackerTorrent = tracker.getTorrent(PluginCoreUtils.wrap(tOTorrent));
                            if (trackerTorrent != null) {
                                trackerTorrent.stop();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        shareResource.delete();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!globalManagerDownloadRemovalVetoException.isSilent()) {
                    UIFunctionsManager.getUIFunctions().forceNotify(1, MessageText.getString("globalmanager.download.remove.veto"), globalManagerDownloadRemovalVetoException.getMessage(), null, null, -1);
                }
                if (aERunnable != null) {
                    aERunnable.runSupport();
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                if (aERunnable == null) break block13;
                aERunnable.runSupport();
            }
        }
        TorrentUtil.finalCleanup(downloadManager);
    }

    private static DownloadManager[] toDMS(Object[] objectArray) {
        int n = 0;
        DownloadManager[] downloadManagerArray = new DownloadManager[objectArray.length];
        for (Object object : objectArray) {
            Object object2;
            if (object instanceof DownloadManager) {
                object2 = (DownloadManager)object;
                downloadManagerArray[n++] = object2;
                continue;
            }
            if (!(object instanceof SelectedContent) || ((SelectedContent)(object2 = (SelectedContent)object)).getFileIndex() != -1 || ((SelectedContent)object2).getDownloadManager() == null) continue;
            downloadManagerArray[n++] = ((SelectedContent)object2).getDownloadManager();
        }
        Object[] objectArray2 = new DownloadManager[n];
        System.arraycopy(downloadManagerArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public static void stop(DownloadManager downloadManager) {
        TorrentUtil.stop(downloadManager, 70);
    }

    public static void stop(DownloadManager downloadManager, int n) {
        if (downloadManager == null) {
            return;
        }
        int n2 = downloadManager.getState();
        if (n2 == 70 || n2 == 65 || n2 == n) {
            return;
        }
        TorrentUtil.asyncStop(downloadManager, n);
    }

    public static void asyncStop(final DownloadManager downloadManager, final int n) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                downloadManager.stopIt(n, false, false);
            }
        });
    }

    public static void queue(DownloadManager downloadManager) {
        if (downloadManager != null && downloadManager.getState() == 70) {
            downloadManager.setStateQueued();
        }
    }

    public static void start(DownloadManager downloadManager) {
        if (downloadManager != null && downloadManager.getState() == 70) {
            downloadManager.initialize();
        }
    }

    public static String getMagnet(byte[] byArray) {
        return "magnet:?xt=urn:btih:" + TorrentUtil.hashToString(byArray);
    }

    public static String getMagnet(String string) {
        return "magnet:?xt=urn:btih:" + string;
    }

    public static String getMagnetURLParameters(TOTorrent tOTorrent) {
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNullOrEmpty(tOTorrent.getUTF8Name())) {
            stringBuilder.append("dn=" + UrlUtils.encode(new String(tOTorrent.getName())));
        } else {
            stringBuilder.append("dn=" + UrlUtils.encode(tOTorrent.getUTF8Name()));
        }
        TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = tOTorrent.getAnnounceURLGroup();
        for (TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet : tOTorrentAnnounceURLSetArray = tOTorrentAnnounceURLGroup.getAnnounceURLSets()) {
            URL[] uRLArray;
            for (URL uRL : uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs()) {
                stringBuilder.append("&tr=");
                stringBuilder.append(UrlUtils.encode(uRL.toString()));
            }
        }
        if (tOTorrent.getAnnounceURL() != null) {
            stringBuilder.append("&tr=");
            stringBuilder.append(UrlUtils.encode(tOTorrent.getAnnounceURL().toString()));
        }
        try {
            String throwable = NetworkUtils.getLocalAddress().getHostAddress();
            int n = TCPNetworkManager.getSingleton().getTCPListeningPortNumber();
            if (n != -1) {
                stringBuilder.append("&iipp=");
                stringBuilder.append(NetworkUtils.convertIPPortToHex(throwable, n));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static String hashToString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            if (string2.length() < 2) {
                string2 = "0" + string2;
            }
            string = string + string2;
        }
        return string;
    }

    public static Set<File> getIgnorableFiles() {
        Set<File> set = TorrentUtil.getIncompleteFiles();
        set.addAll(TorrentUtil.getSkipedFiles());
        return set;
    }
}

