/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.util.Date;
import jd.controlling.IOEQ;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.limewire.util.FilenameUtils;

public class YouTubeItemDownload
implements BTDownload {
    private static final String STATE_DOWNLOADING = I18n.tr("Downloading");
    private static final String STATE_ERROR = I18n.tr("Error");
    private static final String STATE_STOPPED = I18n.tr("Stopped");
    private static final String STATE_WAITING = I18n.tr("Waiting");
    private static final String STATE_FINISHED = I18n.tr("Finished");
    private final FilePackage filePackage;
    private final DownloadLink link;
    private final Date dateCreated;
    private final String saveLocation;
    private boolean deleteDataWhenRemove;
    private boolean started;
    private boolean finished;

    public YouTubeItemDownload(FilePackage filePackage) {
        this.filePackage = filePackage;
        this.link = filePackage.getChildren().get(0);
        this.dateCreated = new Date();
        this.saveLocation = this.readSaveLocation(filePackage);
        this.started = false;
        this.start();
    }

    @Override
    public long getSize() {
        return this.link.getDownloadSize();
    }

    @Override
    public long getSize(boolean bl) {
        return this.link.getDownloadSize();
    }

    @Override
    public String getDisplayName() {
        return FilenameUtils.getName(this.saveLocation);
    }

    @Override
    public boolean isResumable() {
        return this.started && !this.isPausable() && !this.finished;
    }

    @Override
    public boolean isPausable() {
        return this.link.getLinkStatus().hasStatus(1024);
    }

    @Override
    public boolean isCompleted() {
        return this.link.getLinkStatus().hasStatus(2);
    }

    @Override
    public int getState() {
        if (this.link.getLinkStatus().hasStatus(1024)) {
            return 50;
        }
        return 70;
    }

    @Override
    public void remove() {
        this.pause();
        if (this.deleteDataWhenRemove) {
            this.link.deleteFile(true, true);
        }
    }

    @Override
    public void pause() {
        DownloadController.getInstance().removePackage(this.filePackage);
        this.link.abort();
    }

    @Override
    public File getSaveLocation() {
        return new File(this.saveLocation);
    }

    @Override
    public void resume() {
        this.start();
    }

    @Override
    public int getProgress() {
        if (this.link.getDownloadSize() == 0L) {
            return 0;
        }
        return (int)(this.link.getDownloadCurrent() * 100L / this.link.getDownloadSize());
    }

    @Override
    public String getStateString() {
        if (this.link.getLinkStatus().hasStatus(1024)) {
            this.started = true;
            return STATE_DOWNLOADING;
        }
        if (this.link.getLinkStatus().isFailed()) {
            return STATE_ERROR;
        }
        if (this.link.getLinkStatus().hasStatus(2)) {
            this.finished = true;
            return STATE_FINISHED;
        }
        if (!this.started) {
            return STATE_WAITING;
        }
        return STATE_STOPPED;
    }

    @Override
    public long getBytesReceived() {
        return this.link.getDownloadCurrent();
    }

    @Override
    public long getBytesSent() {
        return 0L;
    }

    @Override
    public double getDownloadSpeed() {
        return this.link.getDownloadSpeed() / 1024L;
    }

    @Override
    public double getUploadSpeed() {
        return 0.0;
    }

    @Override
    public long getETA() {
        return 0L;
    }

    @Override
    public DownloadManager getDownloadManager() {
        return null;
    }

    @Override
    public String getPeersString() {
        return "";
    }

    @Override
    public String getSeedsString() {
        return "";
    }

    @Override
    public boolean isDeleteTorrentWhenRemove() {
        return false;
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean bl) {
    }

    @Override
    public boolean isDeleteDataWhenRemove() {
        return this.deleteDataWhenRemove;
    }

    @Override
    public void setDeleteDataWhenRemove(boolean bl) {
        this.deleteDataWhenRemove = bl;
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public String getSeedToPeerRatio() {
        return "";
    }

    @Override
    public String getShareRatio() {
        return "";
    }

    @Override
    public boolean isPartialDownload() {
        return false;
    }

    @Override
    public void updateDownloadManager(DownloadManager downloadManager) {
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    private void start() {
        this.link.reset();
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                DownloadController.getInstance().addPackage(YouTubeItemDownload.this.filePackage);
                IOEQ.add(new Runnable(){

                    @Override
                    public void run() {
                        DownloadWatchDog.getInstance().startDownloads();
                    }
                }, true);
            }
        }, true);
    }

    private String readSaveLocation(FilePackage filePackage) {
        DownloadLink downloadLink = filePackage.getChildren().get(0);
        if (downloadLink.getStringProperty("convertto", "").equals("AUDIOMP3")) {
            return FilenameUtils.getFullPath(downloadLink.getFileOutput()) + File.separator + FilenameUtils.getBaseName(downloadLink.getName()) + ".mp3";
        }
        return downloadLink.getFileOutput();
    }
}

