/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.PartialYouTubePackageDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.PackageInfo;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.jdownloader.controlling.filter.LinkFilterController;

public class YouTubeVideoUrlDownload
implements BTDownload {
    private static final Log LOG = LogFactory.getLog(YouTubeVideoUrlDownload.class);
    private static final String STATE_CRAWLING = I18n.tr("Crawling");
    private static final String STATE_FINISHED = I18n.tr("Finished");
    private static final String STATE_ERROR = I18n.tr("Error");
    private static final String STATE_STOPPED = I18n.tr("Stopped");
    private final String videoUrl;
    private final Date dateCreated;
    private String _state;
    private int progress;

    public YouTubeVideoUrlDownload(String string) {
        if (!string.startsWith("http://")) {
            string = "http://" + string;
        }
        this.videoUrl = string;
        this.dateCreated = new Date();
        this._state = STATE_CRAWLING;
        this.start();
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public long getSize(boolean bl) {
        return 0L;
    }

    @Override
    public String getDisplayName() {
        return this.videoUrl;
    }

    @Override
    public boolean isResumable() {
        return false;
    }

    @Override
    public boolean isPausable() {
        return false;
    }

    @Override
    public boolean isCompleted() {
        return this._state.equals(STATE_FINISHED);
    }

    @Override
    public int getState() {
        return -1;
    }

    @Override
    public void remove() {
        this._state = STATE_STOPPED;
    }

    @Override
    public void pause() {
    }

    @Override
    public File getSaveLocation() {
        return null;
    }

    @Override
    public void resume() {
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public String getStateString() {
        return this._state;
    }

    @Override
    public long getBytesReceived() {
        return 0L;
    }

    @Override
    public long getBytesSent() {
        return 0L;
    }

    @Override
    public double getDownloadSpeed() {
        return 0.0;
    }

    @Override
    public double getUploadSpeed() {
        return 0.0;
    }

    @Override
    public long getETA() {
        return 0L;
    }

    @Override
    public DownloadManager getDownloadManager() {
        return null;
    }

    @Override
    public String getPeersString() {
        return "";
    }

    @Override
    public String getSeedsString() {
        return "";
    }

    @Override
    public boolean isDeleteTorrentWhenRemove() {
        return false;
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean bl) {
    }

    @Override
    public boolean isDeleteDataWhenRemove() {
        return false;
    }

    @Override
    public void setDeleteDataWhenRemove(boolean bl) {
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public String getSeedToPeerRatio() {
        return "";
    }

    @Override
    public String getShareRatio() {
        return "";
    }

    @Override
    public boolean isPartialDownload() {
        return false;
    }

    @Override
    public void updateDownloadManager(DownloadManager downloadManager) {
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    private void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LinkCollector linkCollector = LinkCollector.getInstance();
                    LinkCrawler linkCrawler = new LinkCrawler();
                    linkCrawler.setFilter(LinkFilterController.getInstance());
                    linkCrawler.crawl(YouTubeVideoUrlDownload.this.videoUrl);
                    linkCrawler.waitForCrawling();
                    if (YouTubeVideoUrlDownload.this._state.equals(STATE_STOPPED)) {
                        return;
                    }
                    YouTubeVideoUrlDownload.this._state = STATE_FINISHED;
                    YouTubeVideoUrlDownload.this.progress = 100;
                    final ArrayList<FilePackage> arrayList = new ArrayList<FilePackage>();
                    for (CrawledLink crawledLink : linkCrawler.getCrawledLinks()) {
                        CrawledPackage crawledPackage = PackageInfo.createCrawledPackage(crawledLink);
                        crawledPackage.setControlledBy(linkCollector);
                        crawledLink.setParentNode(crawledPackage);
                        ArrayList<CrawledLink> arrayList2 = new ArrayList<CrawledLink>();
                        arrayList2.add(crawledLink);
                        arrayList.add(YouTubeVideoUrlDownload.this.createFilePackage(crawledPackage, arrayList2));
                    }
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PartialYouTubePackageDialog partialYouTubePackageDialog = new PartialYouTubePackageDialog(GUIMediator.getAppFrame(), YouTubeVideoUrlDownload.this.videoUrl, arrayList);
                                partialYouTubePackageDialog.setVisible(true);
                                if (partialYouTubePackageDialog.getFilesSelection() != null) {
                                    for (FilePackage filePackage : partialYouTubePackageDialog.getFilesSelection()) {
                                        BTDownloadMediator.instance().openYouTubeItem(filePackage);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                LOG.error("Error reading youtube package:" + throwable.getMessage(), throwable);
                                YouTubeVideoUrlDownload.this._state = STATE_ERROR;
                            }
                        }
                    });
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            BTDownloadMediator.instance().remove(YouTubeVideoUrlDownload.this);
                        }
                    });
                }
                catch (Throwable throwable) {
                    LOG.error("Error crawling youtube: " + YouTubeVideoUrlDownload.this.videoUrl, throwable);
                    YouTubeVideoUrlDownload.this._state = STATE_ERROR;
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("YouTube Crawl: " + this.videoUrl);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilePackage createFilePackage(CrawledPackage crawledPackage, ArrayList<CrawledLink> arrayList) {
        FilePackage filePackage = FilePackage.getInstance();
        filePackage.setName(crawledPackage.getName());
        filePackage.setDownloadDirectory(crawledPackage.getDownloadFolder());
        filePackage.setCreated(crawledPackage.getCreated());
        filePackage.setExpanded(crawledPackage.isExpanded());
        filePackage.setComment(crawledPackage.getComment());
        CrawledPackage crawledPackage2 = crawledPackage;
        synchronized (crawledPackage2) {
            ArrayList<DownloadLink> arrayList2 = new ArrayList<DownloadLink>(crawledPackage.getChildren().size());
            List<CrawledLink> list = crawledPackage.getChildren();
            if (arrayList != null && arrayList.size() > 0) {
                list = new ArrayList<CrawledLink>(arrayList);
            }
            for (CrawledLink crawledLink : list) {
                DownloadLink downloadLink = crawledLink.getDownloadLink();
                if (downloadLink == null) continue;
                if (crawledLink.isNameSet()) {
                    downloadLink.forceFileName(crawledLink.getName());
                }
                downloadLink.setNodeChangeListener(null);
                downloadLink.setCreated(crawledLink.getCreated());
                arrayList2.add(downloadLink);
                downloadLink.setParentNode(filePackage);
            }
            filePackage.getChildren().addAll(arrayList2);
        }
        return filePackage;
    }
}

