/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components;

import com.frostwire.HttpFetcher;
import com.frostwire.gui.components.SearchField;
import com.frostwire.gui.components.searchfield.JXSearchField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.limewire.util.LCS;
import org.limewire.util.StringUtils;

public class GoogleSearchField
extends SearchField {
    private static final long serialVersionUID = -7677894485818144062L;
    private static final String SUGGESTIONS_URL = GoogleSearchField.buildSuggestionsUrl();
    private static final int HTTP_QUERY_TIMEOUT = 1000;
    private SuggestionsThread suggestionsThread;

    public GoogleSearchField() {
        this.dict = this.createDefaultDictionary();
        this.setPrompt(I18n.tr("Hints by Google"));
        this.setSearchMode(JXSearchField.SearchMode.REGULAR);
    }

    @Override
    public void autoCompleteInput() {
        String string = this.getText();
        if (string != null && string.length() > 0) {
            if (this.suggestionsThread != null) {
                this.suggestionsThread.cancel();
            }
            this.suggestionsThread = new SuggestionsThread(string, this);
            this.suggestionsThread.start();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void setText(String string) {
        try {
            if (string != null) {
                string = string.replace("<html>", "").replace("</html>", "").replace("<b>", "").replace("</b>", "");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        super.setText(string);
    }

    @Override
    protected JComponent getPopupComponent() {
        if (this.entryPanel != null) {
            return this.entryPanel;
        }
        this.entryPanel = new JPanel(new GridBagLayout());
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.entryList = new SearchField.AutoCompleteList(this);
        JScrollPane jScrollPane = new JScrollPane(this.entryList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)jScrollPane, gridBagConstraints);
        this.entryList.setFont(this.getFont());
        return this.entryPanel;
    }

    private static String buildSuggestionsUrl() {
        String string = ApplicationSettings.LANGUAGE.getValue();
        if (StringUtils.isNullOrEmpty(string)) {
            string = "en";
        }
        return "http://suggestqueries.google.com/complete/search?output=firefox&hl=" + string + "&q=%s";
    }

    private static final class SuggestionsThread
    extends Thread {
        private final String constraint;
        private final GoogleSearchField input;
        private boolean cancelled;

        public SuggestionsThread(String string, GoogleSearchField googleSearchField) {
            this.constraint = string;
            this.input = googleSearchField;
            this.setName("SuggestionsThread: " + string);
            this.setDaemon(true);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            try {
                String string = String.format(SUGGESTIONS_URL, URLEncoder.encode(this.constraint, "UTF-8"));
                HttpFetcher httpFetcher = new HttpFetcher(new URI(string), 1000);
                String string2 = StringUtils.getUTF8String(httpFetcher.fetch());
                if (!this.isCancelled()) {
                    final List<String> list = this.readSuggestions((JSONArray)((JSONArray)JSONValue.parse(string2)).get(1));
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Iterator<String> iterator = list.iterator();
                            if (iterator.hasNext()) {
                                if (!StringUtils.isNullOrEmpty(SuggestionsThread.this.input.getText(), true)) {
                                    SuggestionsThread.this.input.showPopup(iterator);
                                } else {
                                    SuggestionsThread.this.input.hidePopup();
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private List<String> readSuggestions(JSONArray jSONArray) {
            String string = this.input.getText();
            ArrayList<String> arrayList = new ArrayList<String>(jSONArray.size());
            if (!StringUtils.isNullOrEmpty(string, true)) {
                for (Object e : jSONArray) {
                    String string2 = LCS.lcsHtml(string, (String)e);
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
    }
}

