/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JPanel;

public class GraphicPanel
extends JPanel {
    private static final long serialVersionUID = 9079271524527772928L;
    private GradientPaint _gradient;
    private Image _image;
    private String _text;
    private Image _textImage;

    public GradientPaint getGradient() {
        return this._gradient;
    }

    public void setGradient(GradientPaint gradientPaint) {
        this._gradient = gradientPaint;
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
    }

    public void setText(String string) {
        this._textImage = null;
        this._text = string;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this._gradient != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(this._gradient);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this._image != null) {
            graphics.drawImage(this._image, 0, 0, null);
        }
        if (this._text != null) {
            if (this._textImage == null) {
                this._textImage = this.buildTextImage(this._text);
            }
            graphics.drawImage(this._textImage, 0, 8, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage buildTextImage(String string) {
        Font font = this.getFont();
        Graphics graphics = null;
        Graphics graphics2 = null;
        Graphics graphics3 = null;
        BufferedImage bufferedImage = null;
        try {
            BufferedImage bufferedImage2 = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            graphics = bufferedImage2.createGraphics();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.stringWidth(string) + 20;
            int n2 = fontMetrics.getHeight() + 20;
            BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
            graphics2 = bufferedImage3.createGraphics();
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            TextLayout textLayout = new TextLayout(string, font, ((Graphics2D)graphics2).getFontRenderContext());
            ((Graphics2D)graphics2).setPaint(Color.BLACK);
            textLayout.draw((Graphics2D)graphics2, 11.0f, 14.0f);
            graphics2.dispose();
            float f = 0.11111111f;
            float[] fArray = new float[]{f, f, f, f, f, f, f, f, f};
            ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, fArray), 1, null);
            BufferedImage bufferedImage4 = convolveOp.filter(bufferedImage3, null);
            graphics3 = bufferedImage4.createGraphics();
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            ((Graphics2D)graphics3).setPaint(Color.WHITE);
            textLayout.draw((Graphics2D)graphics3, 10.0f, 13.0f);
            bufferedImage = bufferedImage4;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            if (graphics != null) {
                graphics2.dispose();
            }
            if (graphics != null) {
                graphics3.dispose();
            }
        }
        return bufferedImage;
    }
}

