/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components;

import com.frostwire.gui.components.RangeSlider;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class LabeledRangeSlider
extends JPanel {
    private static final long serialVersionUID = 17039376083098413L;
    private final RangeSlider slider;
    private final JLabel titleLabel;
    private final JLabel minLabel;
    private final JLabel maxLabel;

    public LabeledRangeSlider(String string, String string2, int n, int n2) {
        this.slider = new RangeSlider(n, n2);
        this.slider.setValue(n);
        this.slider.setUpperValue(n2);
        this.titleLabel = new JLabel(I18n.tr(string));
        this.minLabel = new JLabel(String.valueOf(n));
        this.maxLabel = string2 == null ? new JLabel(I18n.tr("Max")) : new JLabel(I18n.tr(string2));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.slider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.minLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.maxLabel, gridBagConstraints);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.slider.addChangeListener(changeListener);
    }

    public void setValue(int n) {
        this.slider.setValue(n);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public int getUpperValue() {
        return this.slider.getUpperValue();
    }

    public void setUpperValue(int n) {
        this.slider.setUpperValue(n);
    }

    public void setMinimum(int n) {
        this.slider.setMinimum(n);
    }

    public void setMaximum(int n) {
        this.slider.setMaximum(n);
    }

    public JLabel getMinimumValueLabel() {
        return this.minLabel;
    }

    public JLabel getMaximumValueLabel() {
        return this.maxLabel;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
    }
}

