/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components;

import com.frostwire.gui.components.RangeSliderUI;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class RangeSlider
extends JSlider {
    private static final long serialVersionUID = -8238895600671189387L;

    public RangeSlider() {
        this.setOrientation(0);
    }

    public RangeSlider(int n, int n2) {
        super(n, n2);
        this.setOrientation(0);
    }

    @Override
    public void updateUI() {
        ComponentUI componentUI = UIManager.getUI(this);
        if (componentUI == null) {
            componentUI = new RangeSliderUI(this);
        }
        this.setUI(componentUI);
        this.updateLabelUIs();
    }

    @Override
    public void setValue(int n) {
        int n2 = this.getValue();
        if (n2 == n) {
            return;
        }
        int n3 = this.getExtent();
        int n4 = Math.min(Math.max(this.getMinimum(), n), n2 + n3);
        int n5 = n3 + n2 - n4;
        this.getModel().setRangeProperties(n4, n5, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public void setUpperValue(int n) {
        int n2 = this.getValue();
        int n3 = Math.min(Math.max(0, n - n2), this.getMaximum() - n2);
        this.setExtent(n3);
    }

    @Override
    public String getUIClassID() {
        return "RangeSliderUI";
    }
}

