/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components;

import com.frostwire.gui.components.searchfield.JXSearchField;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.StringTrieSet;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

public class SearchField
extends JXSearchField {
    private static final long serialVersionUID = 3506693592729700194L;
    private static JPopupMenu POPUP;
    private UndoManager undoManager;
    private static Action UNDO_ACTION;
    private static Action CUT_ACTION;
    private static Action COPY_ACTION;
    private static Action PASTE_ACTION;
    private static Action DELETE_ACTION;
    private static Action SELECT_ALL_ACTION;
    protected AutoCompleteDictionary dict;
    protected AutoCompleteList entryList;
    protected JPanel entryPanel;
    protected Popup popup;
    protected boolean showPending;

    public SearchField() {
        this.init();
    }

    public void undo() {
        try {
            if (this.undoManager != null) {
                this.undoManager.undoOrRedo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setDocument(Document document) {
        if (document != this.getDocument()) {
            this.undoManager = null;
        }
        super.setDocument(document);
    }

    private void init() {
        this.setComponentPopupMenu(SearchField.createPopup());
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.enableEvents(8L);
        this.enableEvents(32768L);
        this.enableEvents(4L);
    }

    private static JPopupMenu createPopup() {
        if (POPUP != null) {
            return POPUP;
        }
        POPUP = new SkinPopupMenu(){
            private static final long serialVersionUID = -6004124495511263059L;

            @Override
            public void show(Component component, int n, int n2) {
                ((SearchField)component).updateActions();
                super.show(component, n, n2);
            }
        };
        POPUP.add(new SkinMenuItem(UNDO_ACTION));
        POPUP.addSeparator();
        POPUP.add(new SkinMenuItem(CUT_ACTION));
        POPUP.add(new SkinMenuItem(COPY_ACTION));
        POPUP.add(new SkinMenuItem(PASTE_ACTION));
        POPUP.add(new SkinMenuItem(DELETE_ACTION));
        POPUP.addSeparator();
        POPUP.add(new SkinMenuItem(SELECT_ALL_ACTION));
        return POPUP;
    }

    private void updateActions() {
        String string = this.getSelectedText();
        if (string == null) {
            string = "";
        }
        boolean bl = !string.equals("");
        boolean bl2 = string.equals(this.getText());
        UNDO_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isUndoAvailable());
        CUT_ACTION.setEnabled(this.isEnabled() && this.isEditable() && bl);
        COPY_ACTION.setEnabled(this.isEnabled() && bl);
        PASTE_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isPasteAvailable());
        DELETE_ACTION.setEnabled(this.isEnabled() && bl);
        SELECT_ALL_ACTION.setEnabled(this.isEnabled() && !bl2);
    }

    private boolean isUndoAvailable() {
        return this.getUndoManager() != null && this.getUndoManager().canUndoOrRedo();
    }

    private boolean isPasteAvailable() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public void setDictionary(AutoCompleteDictionary autoCompleteDictionary) {
        if (this.dict == null) {
            this.setUp();
        }
        this.dict = autoCompleteDictionary;
    }

    public AutoCompleteDictionary getDictionary() {
        return this.dict;
    }

    public AutoCompleteDictionary createDefaultDictionary() {
        return new StringTrieSet(true);
    }

    public void setAutoComplete(boolean bl) {
        UISettings.AUTOCOMPLETE_ENABLED.setValue(bl);
    }

    public boolean getAutoComplete() {
        return UISettings.AUTOCOMPLETE_ENABLED.getValue();
    }

    public void addToDictionary() {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(this.getText().trim());
    }

    public void addToDictionary(String string) {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(string.trim());
    }

    protected String lookup(String string) {
        if (this.dict != null && this.getAutoComplete() && !string.equals("")) {
            return this.dict.lookup(string);
        }
        return null;
    }

    @Override
    protected void fireActionPerformed() {
        String string;
        if (this.popup != null && (string = (String)this.entryList.getSelectedValue()) != null) {
            this.hidePopup();
            this.setText(string);
            return;
        }
        super.fireActionPerformed();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
        if (this.dict != null) {
            block0 : switch (keyEvent.getID()) {
                case 401: {
                    switch (keyEvent.getKeyCode()) {
                        case 38: {
                            if (this.popup != null) {
                                this.entryList.decrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                            break;
                        }
                        case 40: {
                            if (this.popup != null) {
                                this.entryList.incrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                            break;
                        }
                        case 27: {
                            if (this.popup == null) break;
                            this.hidePopup();
                            this.selectAll();
                        }
                    }
                    break;
                }
                case 400: {
                    switch (keyEvent.getKeyChar()) {
                        case '\n': {
                            break block0;
                        }
                    }
                    this.autoCompleteInput();
                }
            }
        }
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        super.processHierarchyEvent(hierarchyEvent);
        if ((hierarchyEvent.getChangeFlags() & 4L) == 4L) {
            boolean bl = this.isShowing();
            if (!bl && this.popup != null) {
                this.hidePopup();
            } else if (bl && this.popup == null && this.showPending) {
                this.autoCompleteInput();
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005 && this.popup != null) {
            this.hidePopup();
        }
    }

    protected void setUp() {
    }

    protected JComponent getPopupComponent() {
        if (this.entryPanel != null) {
            return this.entryPanel;
        }
        this.entryPanel = new JPanel(new GridBagLayout());
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.entryList = new AutoCompleteList();
        JScrollPane jScrollPane = new JScrollPane(this.entryList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)jScrollPane, gridBagConstraints);
        this.entryPanel.add((Component)new ClearHistory(), gridBagConstraints);
        return this.entryPanel;
    }

    protected void showPopup(Iterator<String> iterator) {
        this.getPopupComponent();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        ListModel listModel = this.entryList.getModel();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            vector.add(string);
            if (!bl && n < listModel.getSize()) {
                bl |= !string.equals(listModel.getElementAt(n));
            }
            ++n;
        }
        if (bl |= listModel.getSize() != vector.size()) {
            this.entryList.setListData(vector);
            this.entryList.clearSelection();
        }
        this.entryList.setCurrentText(this.getText());
        this.showPopup();
    }

    public void showPopup() {
        if (this.popup == null && this.entryList.getModel().getSize() > 0) {
            if (this.isShowing()) {
                Point point = this.getLocationOnScreen();
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                JComponent jComponent = this;
                if (OSUtils.isMacOSX()) {
                    jComponent = new JPanel();
                    new MyPopup(this, jComponent, 0, 0);
                }
                this.popup = popupFactory.getPopup(jComponent, this.getPopupComponent(), point.x, point.y + this.getHeight() + 1);
                this.showPending = false;
                this.popup.show();
            } else {
                this.showPending = true;
            }
        }
    }

    public void hidePopup() {
        this.showPending = false;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void autoCompleteInput() {
        String string = this.getText();
        if (string != null && string.length() > 0) {
            Iterator<String> iterator = this.dict.iterator(string);
            if (iterator.hasNext()) {
                this.showPopup(iterator);
            } else {
                this.hidePopup();
            }
        } else {
            this.hidePopup();
        }
    }

    static {
        UNDO_ACTION = new FieldAction(I18nMarker.marktr("Undo")){
            private static final long serialVersionUID = -4598808952764108125L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getField(actionEvent).undo();
            }
        };
        CUT_ACTION = new FieldAction(I18nMarker.marktr("Cut")){
            private static final long serialVersionUID = 4315097846248426786L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getField(actionEvent).cut();
            }
        };
        COPY_ACTION = new FieldAction(I18nMarker.marktr("Copy")){
            private static final long serialVersionUID = -6811443826148258282L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getField(actionEvent).copy();
            }
        };
        PASTE_ACTION = new FieldAction(I18nMarker.marktr("Paste")){
            private static final long serialVersionUID = 5894287146853247748L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getField(actionEvent).paste();
            }
        };
        DELETE_ACTION = new FieldAction(I18nMarker.marktr("Delete")){
            private static final long serialVersionUID = 5996971351238158202L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getField(actionEvent).replaceSelection("");
            }
        };
        SELECT_ALL_ACTION = new FieldAction(I18nMarker.marktr("Select All")){
            private static final long serialVersionUID = -4805338416149604566L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getField(actionEvent).selectAll();
            }
        };
    }

    private static class MyPopup
    extends Popup {
        public MyPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
        }
    }

    protected class AutoCompleteList
    extends JList {
        private static final long serialVersionUID = -7324769835640667828L;
        private String currentText;

        public AutoCompleteList() {
            this.enableEvents(16L);
            this.setSelectionMode(0);
            this.setFocusable(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n;
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.getID() == 500 && (n = this.locationToIndex(mouseEvent.getPoint())) != -1 && this.isSelectedIndex(n)) {
                String string = (String)this.getSelectedValue();
                SearchField.this.setText(string);
                SearchField.this.hidePopup();
            }
        }

        void setCurrentText(String string) {
            this.currentText = string;
        }

        void incrementSelection() {
            if (this.getSelectedIndex() == this.getModel().getSize() - 1) {
                SearchField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int n = this.getSelectedIndex() + 1;
                this.setSelectedIndex(n);
                this.ensureIndexIsVisible(n);
                SearchField.this.setText((String)this.getSelectedValue());
            }
        }

        void decrementSelection() {
            if (this.getSelectedIndex() == 0) {
                SearchField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int n = this.getSelectedIndex();
                n = n == -1 ? this.getModel().getSize() - 1 : --n;
                this.setSelectedIndex(n);
                this.ensureIndexIsVisible(n);
                SearchField.this.setText((String)this.getSelectedValue());
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            int n = SearchField.this.getSize().width - 2;
            int n2 = Math.min(this.getModel().getSize(), 8);
            int n3 = n2 * this.getCellBounds((int)0, (int)0).height;
            return new Dimension(n, n3);
        }
    }

    private class ClearHistory
    extends JButton {
        private static final long serialVersionUID = 601999394867955024L;

        ClearHistory() {
            super(I18n.tr("Clear History"));
            this.enableEvents(16L);
            this.setFocusable(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.getID() == 500) {
                SearchField.this.dict.clear();
                SearchField.this.hidePopup();
            }
        }
    }

    private static abstract class FieldAction
    extends AbstractAction {
        private static final long serialVersionUID = 2309395089029318488L;

        public FieldAction(String string) {
            super(I18n.tr(string));
        }

        protected SearchField getField(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            JPopupMenu jPopupMenu = (JPopupMenu)jMenuItem.getParent();
            return (SearchField)jPopupMenu.getInvoker();
        }
    }
}

