/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components;

import com.frostwire.HttpFetcher;
import com.frostwire.ImageCache;
import com.frostwire.JsonEngine;
import com.frostwire.gui.components.FadeSlideTransition;
import com.frostwire.gui.components.Slide;
import com.frostwire.gui.components.SlideList;
import com.frostwire.gui.components.SlideshowPanelControls;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import org.limewire.util.OSUtils;

public class SlideshowPanel
extends JPanel {
    private static final long serialVersionUID = -1964953870003850981L;
    private List<Slide> _slides;
    private boolean _randomStart;
    private int _currentSlideIndex;
    private BufferedImage _currentImage;
    private BufferedImage _lastImage;
    private BufferedImage _masterImage1;
    private BufferedImage _masterImage2;
    private boolean masterFlag;
    private boolean _loadingNextImage;
    private FadeSlideTransition _transition;
    private long _transitionTime;
    private boolean _started;
    private boolean _stoppedTransitions;
    private List<SlideshowListener> _listeners;
    private long _lastTimeSlideLoaded;
    private Timer _timer;
    private JPanel _controlsContainer;
    private boolean _useControls;

    public SlideshowPanel(List<Slide> list, boolean bl) {
        this.setup(list, false);
    }

    public SlideshowPanel(final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SlideshowPanel.this.load(string);
            }
        }).start();
    }

    private void load(final String string) {
        try {
            HttpFetcher httpFetcher = new HttpFetcher(new URI(string));
            byte[] byArray = httpFetcher.fetch();
            if (byArray != null) {
                final SlideList slideList = new JsonEngine().toObject(new String(byArray), SlideList.class);
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SlideshowPanel.this.setup(slideList.slides, slideList.randomStart);
                            SlideshowPanel.this.repaint();
                        }
                        catch (Exception exception) {
                            System.out.println("Failed load of Slide Show:" + string);
                            SlideshowPanel.this._slides = null;
                            exception.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            System.out.println("Failed load of Slide Show:" + string);
            this._slides = null;
            exception.printStackTrace();
        }
    }

    @Override
    public int getHeight() {
        return super.getHeight() - 1;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight() + 4);
        if (!this._started && !this._stoppedTransitions) {
            this.startAnimation();
        }
        if (this._transition != null) {
            this._transition.paint(graphics);
            if (!this._transition.isRunning()) {
                this._transition = null;
            }
        }
        if (this._transition == null && this._currentImage != null) {
            graphics.drawImage(this._currentImage, 0, 0, null);
        }
    }

    private void setup(List<Slide> list, boolean bl) {
        this._slides = this.filter(list);
        this._randomStart = bl;
        this._currentSlideIndex = -1;
        this.setCursor(new Cursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    if (SlideshowPanel.this._currentImage == null) {
                        return;
                    }
                    int n = SlideshowPanel.this._currentSlideIndex == -1 && SlideshowPanel.this._slides != null && SlideshowPanel.this._slides.size() > 0 ? 0 : SlideshowPanel.this._currentSlideIndex;
                    Slide slide = (Slide)SlideshowPanel.this._slides.get(n);
                    if (slide.url != null) {
                        GUIMediator.openURL(slide.url);
                    }
                    if (slide.torrent != null) {
                        if (slide.torrent.toLowerCase().startsWith("http")) {
                            GUIMediator.instance().openTorrentURI(slide.torrent, false);
                        } else if (slide.torrent.toLowerCase().startsWith("magnet:?")) {
                            GUIMediator.instance().openTorrentURI(slide.torrent, false);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (this._controlsContainer != null && this._useControls) {
            this._controlsContainer.add((Component)new SlideshowPanelControls(this), "Last");
        }
    }

    private void startAnimation() {
        if (this._slides == null || this._slides.size() == 0 || this._stoppedTransitions) {
            return;
        }
        this._started = true;
        this._lastTimeSlideLoaded = 0L;
        if (this._slides.size() == 1) {
            try {
                ImageCache.instance().getImage(new URL(this._slides.get((int)0).imageSrc), new ImageCache.OnLoadedListener(){

                    @Override
                    public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl, boolean bl2) {
                        SlideshowPanel.this._currentImage = bufferedImage;
                        SlideshowPanel.this.repaint();
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else {
            this._timer = new Timer();
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SlideshowPanel.this.tryMoveNext(false);
                }
            }, 0L, 200L);
        }
    }

    private void tryMoveNext(boolean bl) {
        if (this._loadingNextImage) {
            return;
        }
        Slide slide = null;
        if (this._currentSlideIndex == -1) {
            this._currentSlideIndex = this._randomStart ? new Random(System.currentTimeMillis()).nextInt(this._slides.size()) : 0;
            this._loadingNextImage = true;
            try {
                ImageCache.instance().getImage(new URL(this._slides.get((int)this._currentSlideIndex).imageSrc), new ImageCache.OnLoadedListener(){

                    @Override
                    public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl, boolean bl2) {
                        SlideshowPanel.this._currentImage = bufferedImage;
                        SlideshowPanel.this._loadingNextImage = false;
                        if (SlideshowPanel.this._currentImage != null) {
                            SlideshowPanel.this._lastImage = SlideshowPanel.this._currentImage;
                            SlideshowPanel.this._lastTimeSlideLoaded = System.currentTimeMillis();
                            SlideshowPanel.this.repaint();
                        }
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else {
            slide = this._slides.get(this._currentSlideIndex);
            if (bl) {
                try {
                    ImageCache.instance().getImage(new URL(slide.imageSrc), new ImageCache.OnLoadedListener(){

                        @Override
                        public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl, boolean bl2) {
                            SlideshowPanel.this._currentImage = SlideshowPanel.this.prepareImage(bufferedImage);
                            if (SlideshowPanel.this._transition != null) {
                                SlideshowPanel.this._transition.stop();
                            }
                            SlideshowPanel.this._transition = null;
                            SlideshowPanel.this.repaint();
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                return;
            }
            if (slide.duration + this._lastTimeSlideLoaded + this._transitionTime < System.currentTimeMillis()) {
                this._currentSlideIndex = (this._currentSlideIndex + 1) % this._slides.size();
                slide = this._slides.get(this._currentSlideIndex);
            } else {
                slide = null;
            }
        }
        if (slide != null) {
            this._loadingNextImage = true;
            try {
                ImageCache.instance().getImage(new URL(slide.imageSrc), new ImageCache.OnLoadedListener(){

                    @Override
                    public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl, boolean bl2) {
                        SlideshowPanel.this._currentImage = SlideshowPanel.this.prepareImage(bufferedImage);
                        if (SlideshowPanel.this._lastImage != null && SlideshowPanel.this._currentImage != null) {
                            SlideshowPanel.this._transition = new FadeSlideTransition(SlideshowPanel.this, SlideshowPanel.this._lastImage, SlideshowPanel.this._currentImage);
                            SlideshowPanel.this._transitionTime = SlideshowPanel.this._transition.getEstimatedDuration();
                            SlideshowPanel.this._transition.start();
                        }
                        SlideshowPanel.this._loadingNextImage = false;
                        if (SlideshowPanel.this._currentImage != null) {
                            SlideshowPanel.this._lastImage = SlideshowPanel.this._currentImage;
                            SlideshowPanel.this._lastTimeSlideLoaded = System.currentTimeMillis();
                            SlideshowPanel.this.repaint();
                        }
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage prepareImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        try {
            BufferedImage bufferedImage2 = this.getMasterImage(800, 400);
            Graphics2D graphics2D = null;
            try {
                graphics2D = bufferedImage2.createGraphics();
                int n = 0;
                int n2 = 0;
                if (bufferedImage.getHeight() < this.getHeight()) {
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    n2 = (this.getHeight() - bufferedImage.getHeight()) / 2;
                }
                if (bufferedImage.getWidth() < this.getWidth()) {
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    n = (this.getWidth() - bufferedImage.getWidth()) / 2;
                }
                graphics2D.drawImage((Image)bufferedImage, n, n2, null);
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                }
            }
            return bufferedImage2;
        }
        catch (Exception exception) {
            System.out.println("Error creating image for SlideShow (" + this.getWidth() + ", " + this.getHeight() + ")");
            exception.printStackTrace();
            return null;
        }
    }

    private List<Slide> filter(List<Slide> list) {
        ArrayList<Slide> arrayList = new ArrayList<Slide>(list.size());
        for (Slide slide : list) {
            if (!this.isMessageEligibleForMyLang(slide.language) || !this.isMessageEligibleForMyOs(slide.os)) continue;
            arrayList.add(slide);
        }
        return arrayList;
    }

    private boolean isMessageEligibleForMyLang(String string) {
        if (string == null || string.equals("*")) {
            return true;
        }
        String string2 = ApplicationSettings.getLanguage().toLowerCase();
        if (string.length() == 2) {
            return string2.toLowerCase().startsWith(string.toLowerCase());
        }
        return string.equalsIgnoreCase(string2);
    }

    private boolean isMessageEligibleForMyOs(String string) {
        if (string == null) {
            return true;
        }
        boolean bl = string.equals("mac") && OSUtils.isMacOSX();
        boolean bl2 = string.equals("windows") && OSUtils.isWindows();
        boolean bl3 = string.equals("linux") && OSUtils.isLinux();
        return bl || bl2 || bl3;
    }

    public boolean hasSlides() {
        return this._slides != null && this._slides.size() > 0;
    }

    private BufferedImage getMasterImage(int n, int n2) {
        boolean bl = this.masterFlag = !this.masterFlag;
        if (this.masterFlag) {
            if (this._masterImage1 == null) {
                this._masterImage1 = null;
                this._masterImage1 = new BufferedImage(n, n2, 2);
            }
            return this._masterImage1;
        }
        if (this._masterImage2 == null) {
            this._masterImage2 = null;
            this._masterImage2 = new BufferedImage(n, n2, 2);
        }
        return this._masterImage2;
    }

    public void onTransitionStarted() {
        if (this._listeners == null || this._listeners.size() == 0) {
            return;
        }
        for (SlideshowListener slideshowListener : this._listeners) {
            slideshowListener.onSlideChanged();
        }
    }

    public int getNumSlides() {
        if (this._slides == null) {
            return -1;
        }
        return this._slides.size();
    }

    public int getCurrentSlideIndex() {
        return this._currentSlideIndex;
    }

    public void switchToSlide(int n) {
        this.stopTransitions();
        this._currentSlideIndex = n;
        this.tryMoveNext(true);
    }

    public void stopTransitions() {
        this._stoppedTransitions = true;
        this._loadingNextImage = false;
        if (this._timer != null) {
            this._timer.cancel();
        }
        this._lastTimeSlideLoaded = 0L;
    }

    public void addListener(SlideshowListener slideshowListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<SlideshowListener>();
        }
        this._listeners.add(slideshowListener);
    }

    public void removeListener(SlideshowListener slideshowListener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(slideshowListener);
    }

    public void setupContainerAndControls(JPanel jPanel, boolean bl) {
        this._controlsContainer = jPanel;
        this._useControls = bl;
    }

    public static interface SlideshowListener {
        public void onSlideChanged();
    }
}

