/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components;

import com.frostwire.gui.components.SlideshowPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SlideshowPanelControls
extends JPanel
implements SlideshowPanel.SlideshowListener {
    private static final long serialVersionUID = 7167253192165957777L;
    private SlideshowPanel _thePanel;
    private ButtonGroup _buttonGroup;
    private List<JRadioButton> _buttons;
    private ItemListener _selectionAdapter;

    public SlideshowPanelControls(SlideshowPanel slideshowPanel) {
        this._thePanel = slideshowPanel;
        this._thePanel.addListener(this);
        this.buildButtons();
        this.autoSelectCurrentSlideButton();
        this.buildItemListener();
        this.attachListeners();
    }

    public void autoSelectCurrentSlideButton() {
        int n = this._thePanel.getCurrentSlideIndex();
        if (n != -1) {
            this._buttons.get(n).setSelected(true);
        } else {
            this._buttons.get(0).setSelected(true);
        }
    }

    private void buildItemListener() {
        this._selectionAdapter = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (((JRadioButton)itemEvent.getItemSelectable()).isSelected()) {
                    SlideshowPanelControls.this.onRadioButtonClicked(itemEvent);
                }
            }
        };
    }

    protected void onRadioButtonClicked(ItemEvent itemEvent) {
        int n = this._buttons.indexOf(itemEvent.getSource());
        this._thePanel.switchToSlide(n);
    }

    private void buildButtons() {
        int n = this._thePanel.getNumSlides();
        this._buttonGroup = new ButtonGroup();
        this._buttons = new ArrayList<JRadioButton>(n);
        for (int i = 0; i < n; ++i) {
            JRadioButton jRadioButton = new JRadioButton();
            this._buttons.add(jRadioButton);
            this._buttonGroup.add(jRadioButton);
            this.add(jRadioButton);
        }
    }

    private void attachListeners() {
        for (int i = 0; i < this._buttons.size(); ++i) {
            this._buttons.get(i).addItemListener(this._selectionAdapter);
        }
    }

    @Override
    public void onSlideChanged() {
        ItemListener[] itemListenerArray;
        int n = this._thePanel.getCurrentSlideIndex();
        JRadioButton jRadioButton = this._buttons.get(n);
        for (ItemListener itemListener : itemListenerArray = jRadioButton.getItemListeners()) {
            jRadioButton.removeItemListener(itemListener);
        }
        jRadioButton.setSelected(true);
        for (ItemListener itemListener : itemListenerArray) {
            jRadioButton.addItemListener(itemListener);
        }
    }
}

