/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.BuddySupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;

public class BuddyLayoutAndBorder
extends CompoundBorder
implements LayoutManager,
Border,
PropertyChangeListener,
UIResource {
    private static final long serialVersionUID = 2275551286621857718L;
    private JTextField textField;
    private Border borderDelegate;

    protected void install(JTextField jTextField) {
        this.uninstall();
        this.textField = jTextField;
        jTextField.setLayout(this);
        this.replaceBorderIfNecessary();
        jTextField.addPropertyChangeListener("border", this);
    }

    public Border getBorderDelegate() {
        return this.borderDelegate;
    }

    protected void replaceBorderIfNecessary() {
        Border border = this.textField.getBorder();
        if (!(border instanceof BuddyLayoutAndBorder)) {
            this.borderDelegate = border;
            this.textField.setBorder(this);
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable2;
        Dimension dimension = new Dimension();
        for (Serializable serializable2 : BuddySupport.getLeft(this.textField)) {
            dimension.height = Math.max(dimension.height, serializable2.getPreferredSize().height);
        }
        for (Serializable serializable2 : BuddySupport.getRight(this.textField)) {
            dimension.height = Math.max(dimension.height, serializable2.getPreferredSize().height);
        }
        Insets insets = this.getRealBorderInsets();
        dimension.height += insets.top + insets.bottom;
        dimension.width += insets.left + insets.right;
        serializable2 = BuddySupport.getOuterMargin(this.textField);
        if (serializable2 != null) {
            dimension.width += ((Insets)serializable2).left + ((Insets)serializable2).right;
            dimension.height += ((Insets)serializable2).bottom + ((Insets)serializable2).top;
        }
        return dimension;
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension;
        Rectangle rectangle = this.getVisibleRect();
        for (Component component : BuddySupport.getLeft(this.textField)) {
            if (!component.isVisible()) continue;
            dimension = component.getPreferredSize();
            component.setBounds(rectangle.x, this.centerY(rectangle, dimension), dimension.width, dimension.height);
            rectangle.x += dimension.width;
            rectangle.width -= dimension.width;
        }
        for (Component component : BuddySupport.getRight(this.textField)) {
            if (!component.isVisible()) continue;
            dimension = component.getPreferredSize();
            component.setBounds(rectangle.x + rectangle.width - dimension.width, this.centerY(rectangle, dimension), dimension.width, dimension.height);
            rectangle.width -= dimension.width;
        }
    }

    protected int centerY(Rectangle rectangle, Dimension dimension) {
        return (int)(rectangle.getCenterY() - (double)(dimension.height / 2));
    }

    protected Rectangle getVisibleRect() {
        Rectangle rectangle = SwingUtilities.getLocalBounds(this.textField);
        this.substractInsets(rectangle, this.getRealBorderInsets());
        this.substractInsets(rectangle, BuddySupport.getOuterMargin(this.textField));
        return rectangle;
    }

    private void substractInsets(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = null;
        insets = this.borderDelegate != null ? (Insets)this.borderDelegate.getBorderInsets(this.textField).clone() : new Insets(0, 0, 0, 0);
        if (this.textField == null) {
            return insets;
        }
        for (Component component2 : BuddySupport.getLeft(this.textField)) {
            insets.left = insets.left + (component2.isVisible() ? component2.getPreferredSize().width : 0);
        }
        for (Component component2 : BuddySupport.getRight(this.textField)) {
            insets.right = insets.right + (component2.isVisible() ? component2.getPreferredSize().width : 0);
        }
        Insets insets2 = BuddySupport.getOuterMargin(this.textField);
        if (insets2 != null) {
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    public Insets getRealBorderInsets() {
        if (this.borderDelegate == null) {
            return null;
        }
        Insets insets = this.borderDelegate.getBorderInsets(this.textField);
        Insets insets2 = this.textField.getMargin();
        if (insets2 != null) {
            insets.left -= insets2.left;
            insets.right -= insets2.right;
            insets.top -= insets2.top;
            insets.bottom -= insets2.bottom;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        if (this.borderDelegate == null) {
            return false;
        }
        return this.borderDelegate.isBorderOpaque();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.borderDelegate != null) {
            this.borderDelegate.paintBorder(component, graphics, n, n2, n3, n4);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.replaceBorderIfNecessary();
    }

    public void uninstall() {
        if (this.textField != null) {
            this.textField.removePropertyChangeListener("border", this);
            if (this.textField.getBorder() == this) {
                this.textField.setBorder(this.borderDelegate);
            }
            this.textField.setLayout(null);
            this.textField = null;
        }
    }

    public String toString() {
        return String.format("%s (%s): %s", this.getClass().getName(), this.getBorderInsets(null), this.borderDelegate);
    }

    @Override
    public Border getInsideBorder() {
        return this.borderDelegate;
    }
}

