/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.TextUIWrapper;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class BuddySupport {
    public static final String OUTER_MARGIN = "outerMargin";

    public static void addLeft(Component component, JTextField jTextField) {
        BuddySupport.add(component, Position.LEFT, jTextField);
    }

    public static void addRight(Component component, JTextField jTextField) {
        BuddySupport.add(component, Position.RIGHT, jTextField);
    }

    public static void add(Component component, Position position, JTextField jTextField) {
        TextUIWrapper.getDefaultWrapper().install(jTextField, true);
        List<Component> list = BuddySupport.buddies(Position.LEFT, jTextField);
        List<Component> list2 = BuddySupport.buddies(Position.RIGHT, jTextField);
        BuddySupport.setLeft(jTextField, list);
        BuddySupport.setRight(jTextField, list2);
        if (list.contains(component) || list2.contains(component)) {
            throw new IllegalStateException("Component already added.");
        }
        if (Position.LEFT == position) {
            list.add(component);
        } else {
            list2.add(0, component);
        }
        BuddySupport.addToComponentHierarchy(component, position, jTextField);
    }

    public static void addGap(int n, Position position, JTextField jTextField) {
        BuddySupport.add(BuddySupport.createGap(n), position, jTextField);
    }

    public static void setRight(JTextField jTextField, List<Component> list) {
        BuddySupport.set(list, Position.RIGHT, jTextField);
    }

    public static void setLeft(JTextField jTextField, List<Component> list) {
        BuddySupport.set(list, Position.LEFT, jTextField);
    }

    public static void set(List<Component> list, Position position, JTextField jTextField) {
        jTextField.putClientProperty((Object)position, list);
    }

    private static void addToComponentHierarchy(Component component, Position position, JTextField jTextField) {
        jTextField.add(component, position.toString());
    }

    public static List<Component> getLeft(JTextField jTextField) {
        return BuddySupport.getBuddies(Position.LEFT, jTextField);
    }

    public static List<Component> getRight(JTextField jTextField) {
        return BuddySupport.getBuddies(Position.RIGHT, jTextField);
    }

    public static List<Component> getBuddies(Position position, JTextField jTextField) {
        return Collections.unmodifiableList(BuddySupport.buddies(position, jTextField));
    }

    private static List<Component> buddies(Position position, JTextField jTextField) {
        List list = (List)jTextField.getClientProperty((Object)position);
        if (list != null) {
            return list;
        }
        return new ArrayList<Component>();
    }

    public static boolean isBuddy(Component component, JTextField jTextField) {
        return BuddySupport.buddies(Position.LEFT, jTextField).contains(component) || BuddySupport.buddies(Position.RIGHT, jTextField).contains(component);
    }

    public static void remove(JComponent jComponent, JTextField jTextField) {
        BuddySupport.buddies(Position.LEFT, jTextField).remove(jComponent);
        BuddySupport.buddies(Position.RIGHT, jTextField).remove(jComponent);
        jTextField.remove(jComponent);
    }

    public static void removeAll(JTextField jTextField) {
        List<Component> list = BuddySupport.buddies(Position.LEFT, jTextField);
        for (Component object2 : list) {
            jTextField.remove(object2);
        }
        list.clear();
        List<Component> list2 = BuddySupport.buddies(Position.RIGHT, jTextField);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            jTextField.remove(component);
        }
        list2.clear();
    }

    public static void setOuterMargin(JTextField jTextField, Insets insets) {
        jTextField.putClientProperty(OUTER_MARGIN, insets);
    }

    public static Insets getOuterMargin(JTextField jTextField) {
        return (Insets)jTextField.getClientProperty(OUTER_MARGIN);
    }

    public static void ensureBuddiesAreInComponentHierarchy(JTextField jTextField) {
        for (Component component : BuddySupport.getLeft(jTextField)) {
            BuddySupport.addToComponentHierarchy(component, Position.LEFT, jTextField);
        }
        for (Component component : BuddySupport.getRight(jTextField)) {
            BuddySupport.addToComponentHierarchy(component, Position.RIGHT, jTextField);
        }
    }

    public static Component createGap(int n) {
        return Box.createHorizontalStrut(n);
    }

    public static enum Position {
        LEFT,
        RIGHT;

    }
}

