/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.BuddyLayoutAndBorder;
import com.frostwire.gui.components.searchfield.PromptTextFieldUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;

public class BuddyTextFieldUI
extends PromptTextFieldUI {
    protected BuddyLayoutAndBorder layoutAndBorder;
    private static final Insets MAC_MARGIN = new Insets(0, 2, 1, 2);

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.hasMacTextFieldBorder(jComponent)) {
            Insets insets = this.layoutAndBorder.getRealBorderInsets();
            insets.left -= BuddyTextFieldUI.MAC_MARGIN.left;
            int n = jComponent.getHeight() - insets.bottom - insets.top + BuddyTextFieldUI.MAC_MARGIN.bottom + BuddyTextFieldUI.MAC_MARGIN.top;
            int n2 = jComponent.getWidth() - insets.left - insets.right + BuddyTextFieldUI.MAC_MARGIN.right;
            graphics.clipRect(insets.left, insets.top, n2, n);
        }
        super.paint(graphics, jComponent);
    }

    private boolean hasMacTextFieldBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border == this.layoutAndBorder) {
            border = this.layoutAndBorder.getBorderDelegate();
        }
        return border != null && border.getClass().getName().equals("apple.laf.CUIAquaTextFieldBorder");
    }

    public BuddyTextFieldUI(TextUI textUI) {
        super(textUI);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.layoutAndBorder = this.createBuddyLayoutAndBorder();
        this.layoutAndBorder.install((JTextField)jComponent);
    }

    protected BuddyLayoutAndBorder createBuddyLayoutAndBorder() {
        return new BuddyLayoutAndBorder();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.layoutAndBorder.uninstall();
        super.uninstallUI(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = new Dimension();
        Dimension dimension2 = super.getPreferredSize(jComponent);
        Dimension dimension3 = jComponent.getLayout().preferredLayoutSize(jComponent);
        dimension.height = Math.max(dimension2.height, dimension3.height);
        dimension.width = Math.max(dimension2.width, dimension3.width);
        return dimension;
    }
}

