/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.BuddyButton;
import com.frostwire.gui.components.searchfield.JXSearchFieldAddon;
import com.frostwire.gui.components.searchfield.JXTextField;
import com.frostwire.gui.components.searchfield.NativeSearchFieldSupport;
import com.frostwire.gui.components.searchfield.RecentSearches;
import com.frostwire.gui.components.searchfield.TextUIWrapper;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JXSearchField
extends JXTextField {
    private static final long serialVersionUID = -6555528038058656677L;
    private static final int DEFAULT_INSTANT_SEARCH_DELAY = 180;
    private static final KeyStroke CANCEL_KEY = KeyStroke.getKeyStroke(27, 0);
    private JButton findButton;
    private JButton cancelButton;
    private JButton popupButton;
    private LayoutStyle layoutStyle;
    private SearchMode searchMode = SearchMode.INSTANT;
    private boolean useSeperatePopupButton;
    private boolean useSeperatePopupButtonSet;
    private boolean layoutStyleSet;
    private int instantSearchDelay = 180;
    private boolean promptFontStyleSet;
    private Timer instantSearchTimer;
    private String recentSearchesSaveKey;
    private RecentSearches recentSearches;

    public JXSearchField() {
        this("");
    }

    public JXSearchField(String string) {
        super(string);
        this.setUseNativeSearchFieldIfPossible(true);
        this.setCancelAction(new ClearAction());
        this.setFindAction(new FindAction());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (CANCEL_KEY.equals(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()))) {
                    JXSearchField.this.getCancelAction().actionPerformed(new ActionEvent(JXSearchField.this, keyEvent.getID(), KeyEvent.getKeyText(keyEvent.getKeyCode())));
                }
            }
        });
        this.addPropertyChangeListener("JTextField.Search.FindPopup", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JPopupMenu jPopupMenu = (JPopupMenu)propertyChangeEvent.getOldValue();
                JXSearchField.this.firePropertyChange("findPopupMenu", jPopupMenu, propertyChangeEvent.getNewValue());
            }
        });
        this.addPropertyChangeListener("JTextField.Search.CancelAction", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionListener actionListener2 = (ActionListener)propertyChangeEvent.getOldValue();
                JXSearchField.this.firePropertyChange("cancelAction", actionListener2, propertyChangeEvent.getNewValue());
            }
        });
        this.addPropertyChangeListener("JTextField.Search.FindAction", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionListener actionListener2 = (ActionListener)propertyChangeEvent.getOldValue();
                JXSearchField.this.firePropertyChange("findAction", actionListener2, propertyChangeEvent.getNewValue());
            }
        });
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public boolean isInstantSearchMode() {
        return SearchMode.INSTANT.equals((Object)this.getSearchMode());
    }

    public boolean isRegularSearchMode() {
        return SearchMode.REGULAR.equals((Object)this.getSearchMode());
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
        this.firePropertyChange("searchMode", (Object)this.searchMode, (Object)this.searchMode);
    }

    public int getInstantSearchDelay() {
        return this.instantSearchDelay;
    }

    public void setInstantSearchDelay(int n) {
        this.instantSearchDelay = n;
        this.firePropertyChange("instantSearchDelay", this.instantSearchDelay, this.instantSearchDelay);
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    public boolean isVistaLayoutStyle() {
        return LayoutStyle.VISTA.equals((Object)this.getLayoutStyle());
    }

    public boolean isMacLayoutStyle() {
        return LayoutStyle.MAC.equals((Object)this.getLayoutStyle());
    }

    public void setLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyleSet = true;
        this.layoutStyle = layoutStyle;
        this.firePropertyChange("layoutStyle", (Object)this.layoutStyle, (Object)this.layoutStyle);
    }

    @Override
    public void setMargin(Insets insets) {
        super.setMargin(insets);
    }

    public final ActionListener getCancelAction() {
        ActionListener actionListener2 = NativeSearchFieldSupport.getCancelAction(this);
        if (actionListener2 == null) {
            actionListener2 = new ClearAction();
        }
        return actionListener2;
    }

    public final void setCancelAction(ActionListener actionListener2) {
        NativeSearchFieldSupport.setCancelAction(this, actionListener2);
    }

    public final JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = this.createCancelButton();
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JXSearchField.this.getCancelAction().actionPerformed(actionEvent);
                }
            });
        }
        return this.cancelButton;
    }

    protected JButton createCancelButton() {
        BuddyButton buddyButton = new BuddyButton();
        return buddyButton;
    }

    public final ActionListener getFindAction() {
        ActionListener actionListener2 = NativeSearchFieldSupport.getFindAction(this);
        if (actionListener2 == null) {
            actionListener2 = new FindAction();
        }
        return actionListener2;
    }

    public final void setFindAction(ActionListener actionListener2) {
        NativeSearchFieldSupport.setFindAction(this, actionListener2);
    }

    public final JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = this.createFindButton();
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JXSearchField.this.getFindAction().actionPerformed(actionEvent);
                }
            });
        }
        return this.findButton;
    }

    protected JButton createFindButton() {
        BuddyButton buddyButton = new BuddyButton();
        return buddyButton;
    }

    public final JButton getPopupButton() {
        if (this.popupButton == null) {
            this.popupButton = this.createPopupButton();
        }
        return this.popupButton;
    }

    protected JButton createPopupButton() {
        return new BuddyButton();
    }

    public boolean isUseSeperatePopupButton() {
        return this.useSeperatePopupButton;
    }

    public void setUseSeperatePopupButton(boolean bl) {
        this.useSeperatePopupButtonSet = true;
        this.useSeperatePopupButton = bl;
        this.firePropertyChange("useSeperatePopupButton", this.useSeperatePopupButton, this.useSeperatePopupButton);
    }

    public boolean isUseNativeSearchFieldIfPossible() {
        return NativeSearchFieldSupport.isSearchField(this);
    }

    public void setUseNativeSearchFieldIfPossible(boolean bl) {
        TextUIWrapper.getDefaultWrapper().uninstall(this);
        NativeSearchFieldSupport.setSearchField(this, bl);
        TextUIWrapper.getDefaultWrapper().install(this, true);
        this.updateUI();
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.updateButtonState();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtonState();
    }

    protected void updateButtonState() {
        this.getCancelButton().setEnabled(this.isEditable() & this.isEnabled());
        this.getFindButton().setEnabled(this.isEnabled());
        this.getPopupButton().setEnabled(this.isEnabled());
    }

    public void setFindPopupMenu(JPopupMenu jPopupMenu) {
        if (this.isManagingRecentSearches()) {
            return;
        }
        NativeSearchFieldSupport.setFindPopupMenu(this, jPopupMenu);
    }

    public JPopupMenu getFindPopupMenu() {
        return NativeSearchFieldSupport.getFindPopupMenu(this);
    }

    public final boolean isManagingRecentSearches() {
        return this.recentSearches != null;
    }

    private boolean isValidRecentSearchesKey(String string) {
        return string != null && string.length() > 0;
    }

    public String getRecentSearchesSaveKey() {
        return this.recentSearchesSaveKey;
    }

    public void setRecentSearchesSaveKey(String string) {
        String string2 = this.getRecentSearchesSaveKey();
        this.recentSearchesSaveKey = string;
        if (this.recentSearches != null) {
            RecentSearches recentSearches = this.recentSearches;
            this.recentSearches = null;
            recentSearches.uninstall(this);
        }
        if (this.isValidRecentSearchesKey(string)) {
            this.recentSearches = new RecentSearches(string);
            this.recentSearches.install(this);
        }
        this.firePropertyChange("recentSearchesSaveKey", string2, this.recentSearchesSaveKey);
    }

    public RecentSearches getRecentSearches() {
        return this.recentSearches;
    }

    public Timer getInstantSearchTimer() {
        if (this.instantSearchTimer == null) {
            this.instantSearchTimer = new Timer(0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JXSearchField.this.postActionEvent();
                }
            });
            this.instantSearchTimer.setRepeats(false);
        }
        return this.instantSearchTimer;
    }

    @Override
    public boolean hasFocus() {
        if (this.getFindPopupMenu() != null && this.getFindPopupMenu().isVisible()) {
            return true;
        }
        return super.hasFocus();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getFindPopupMenu() != null) {
            SwingUtilities.updateComponentTreeUI(this.getFindPopupMenu());
        }
    }

    @Override
    public void setPromptFontStyle(Integer n) {
        super.setPromptFontStyle(n);
        this.promptFontStyleSet = true;
    }

    public void customSetUIProperty(String string, Object object) {
        this.customSetUIProperty(string, object, false);
    }

    public void customSetUIProperty(String string, Object object, boolean bl) {
        if (string == "useSeperatePopupButton") {
            if (!this.useSeperatePopupButtonSet || bl) {
                this.setUseSeperatePopupButton((Boolean)object);
                this.useSeperatePopupButtonSet = false;
            }
        } else if (string == "layoutStyle") {
            if (!this.layoutStyleSet || bl) {
                this.setLayoutStyle(LayoutStyle.valueOf(object.toString()));
                this.layoutStyleSet = false;
            }
        } else if (string == "promptFontStyle") {
            if (!this.promptFontStyleSet || bl) {
                this.setPromptFontStyle((Integer)object);
                this.promptFontStyleSet = false;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void postActionEvent() {
        this.getInstantSearchTimer().stop();
        super.postActionEvent();
    }

    static {
        new JXSearchFieldAddon().addDefaults();
    }

    public class FindAction
    extends AbstractAction {
        private static final long serialVersionUID = 6512288404613230232L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JXSearchField.this.isFocusOwner() && JXSearchField.this.isRegularSearchMode()) {
                JXSearchField.this.postActionEvent();
            }
            JXSearchField.this.requestFocusInWindow();
            JXSearchField.this.selectAll();
        }
    }

    class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = -3349455592229414653L;

        public ClearAction() {
            this.putValue("ShortDescription", "Clear Search Text");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.clear();
        }

        public void clear() {
            JXSearchField.this.setText(null);
            JXSearchField.this.requestFocusInWindow();
        }
    }

    public static enum SearchMode {
        REGULAR,
        INSTANT;

    }

    public static enum LayoutStyle {
        VISTA,
        MAC;

    }
}

