/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.AbstractUIChangeHandler;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class NativeSearchFieldSupport {
    public static final String FIND_POPUP_PROPERTY = "JTextField.Search.FindPopup";
    public static final String FIND_ACTION_PROPERTY = "JTextField.Search.FindAction";
    public static final String MAC_SEARCH_VARIANT = "search";
    public static final String MAC_TEXT_FIELD_VARIANT_PROPERTY = "JTextField.variant";
    public static final String CANCEL_ACTION_PROPERTY = "JTextField.Search.CancelAction";
    private static final SearchFieldUIChangeHandler uiChangeHandler = new SearchFieldUIChangeHandler();

    public static boolean isNativeSearchFieldSupported() {
        try {
            String string = System.getProperty("os.version");
            if (string.length() < 4) {
                return false;
            }
            string = string.substring(0, 4);
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setSearchField(JTextField jTextField, boolean bl) {
        if (bl == NativeSearchFieldSupport.isSearchField(jTextField)) {
            jTextField.putClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY, "_triggerevent_");
        } else if (bl) {
            uiChangeHandler.install(jTextField);
        } else {
            uiChangeHandler.uninstall(jTextField);
        }
        if (bl) {
            jTextField.putClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY, MAC_SEARCH_VARIANT);
            jTextField.putClientProperty("Quaqua.TextField.style", MAC_SEARCH_VARIANT);
        } else {
            jTextField.putClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY, "default");
            jTextField.putClientProperty("Quaqua.TextField.style", "default");
        }
    }

    public static boolean isSearchField(JTextField jTextField) {
        return MAC_SEARCH_VARIANT.equals(jTextField.getClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY));
    }

    public static boolean isNativeSearchField(JTextField jTextField) {
        return NativeSearchFieldSupport.isSearchField(jTextField) && NativeSearchFieldSupport.isNativeSearchFieldSupported();
    }

    public static void setFindPopupMenu(JTextField jTextField, JPopupMenu jPopupMenu) {
        jTextField.putClientProperty(FIND_POPUP_PROPERTY, jPopupMenu);
    }

    public static JPopupMenu getFindPopupMenu(JTextField jTextField) {
        return (JPopupMenu)jTextField.getClientProperty(FIND_POPUP_PROPERTY);
    }

    public static void setFindAction(JTextField jTextField, ActionListener actionListener2) {
        jTextField.putClientProperty(FIND_ACTION_PROPERTY, actionListener2);
    }

    public static ActionListener getFindAction(JTextField jTextField) {
        return (ActionListener)jTextField.getClientProperty(FIND_ACTION_PROPERTY);
    }

    public static void setCancelAction(JTextField jTextField, ActionListener actionListener2) {
        jTextField.putClientProperty(CANCEL_ACTION_PROPERTY, actionListener2);
    }

    public static ActionListener getCancelAction(JTextField jTextField) {
        return (ActionListener)jTextField.getClientProperty(CANCEL_ACTION_PROPERTY);
    }

    private static final class SearchFieldUIChangeHandler
    extends AbstractUIChangeHandler {
        private SearchFieldUIChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTextField jTextField = (JTextField)propertyChangeEvent.getSource();
            NativeSearchFieldSupport.setSearchField(jTextField, NativeSearchFieldSupport.isSearchField(jTextField));
        }
    }
}

