/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.TextUIWrapper;
import java.awt.Color;
import javax.swing.text.JTextComponent;

public class PromptSupport {
    public static final String PROMPT = "promptText";
    public static final String FOREGROUND = "promptForeground";
    public static final String BACKGROUND = "promptBackground";
    public static final String FOCUS_BEHAVIOR = "focusBehavior";
    public static final String FONT_STYLE = "promptFontStyle";

    public static void init(String string, Color color, Color color2, JTextComponent jTextComponent) {
        if (string != null && string.length() > 0) {
            PromptSupport.setPrompt(string, jTextComponent);
        }
        if (color != null) {
            PromptSupport.setForeground(color, jTextComponent);
        }
        if (color2 != null) {
            PromptSupport.setBackground(color2, jTextComponent);
        }
    }

    public static FocusBehavior getFocusBehavior(JTextComponent jTextComponent) {
        FocusBehavior focusBehavior = (FocusBehavior)((Object)jTextComponent.getClientProperty(FOCUS_BEHAVIOR));
        if (focusBehavior == null) {
            focusBehavior = FocusBehavior.HIDE_PROMPT;
        }
        return focusBehavior;
    }

    public static void setFocusBehavior(FocusBehavior focusBehavior, JTextComponent jTextComponent) {
        jTextComponent.putClientProperty(FOCUS_BEHAVIOR, (Object)focusBehavior);
        if (jTextComponent.isFocusOwner()) {
            jTextComponent.repaint();
        }
    }

    public static String getPrompt(JTextComponent jTextComponent) {
        return (String)jTextComponent.getClientProperty(PROMPT);
    }

    public static void setPrompt(String string, JTextComponent jTextComponent) {
        TextUIWrapper.getDefaultWrapper().install(jTextComponent, true);
        if (jTextComponent.getToolTipText() == null || jTextComponent.getToolTipText().equals(PromptSupport.getPrompt(jTextComponent))) {
            jTextComponent.setToolTipText(string);
        }
        jTextComponent.putClientProperty(PROMPT, string);
        jTextComponent.repaint();
    }

    public static Color getForeground(JTextComponent jTextComponent) {
        if (jTextComponent.getClientProperty(FOREGROUND) == null) {
            return jTextComponent.getDisabledTextColor();
        }
        return (Color)jTextComponent.getClientProperty(FOREGROUND);
    }

    public static void setForeground(Color color, JTextComponent jTextComponent) {
        jTextComponent.putClientProperty(FOREGROUND, color);
        jTextComponent.repaint();
    }

    public static Color getBackground(JTextComponent jTextComponent) {
        if (jTextComponent.getClientProperty(BACKGROUND) == null) {
            return jTextComponent.getBackground();
        }
        return (Color)jTextComponent.getClientProperty(BACKGROUND);
    }

    public static void setBackground(Color color, JTextComponent jTextComponent) {
        TextUIWrapper.getDefaultWrapper().install(jTextComponent, true);
        jTextComponent.putClientProperty(BACKGROUND, color);
        jTextComponent.repaint();
    }

    public static void setFontStyle(Integer n, JTextComponent jTextComponent) {
        jTextComponent.putClientProperty(FONT_STYLE, n);
        jTextComponent.revalidate();
        jTextComponent.repaint();
    }

    public static Integer getFontStyle(JTextComponent jTextComponent) {
        return (Integer)jTextComponent.getClientProperty(FONT_STYLE);
    }

    public static enum FocusBehavior {
        SHOW_PROMPT,
        HIGHLIGHT_PROMPT,
        HIDE_PROMPT;

    }
}

