/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.PromptSupport;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;

public abstract class PromptTextUI
extends TextUI
implements TransitionAwareUI {
    static final FocusHandler focusHandler = new FocusHandler();
    protected final TextUI delegate;
    protected JTextComponent promptComponent;

    public PromptTextUI(TextUI textUI) {
        this.delegate = textUI;
    }

    protected abstract JTextComponent createPromptComponent();

    @Override
    public void installUI(JComponent jComponent) {
        this.delegate.installUI(jComponent);
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        jTextComponent.addFocusListener(focusHandler);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.delegate.uninstallUI(jComponent);
        jComponent.removeFocusListener(focusHandler);
        this.promptComponent = null;
    }

    public JTextComponent getPromptComponent(JTextComponent jTextComponent) {
        if (this.promptComponent == null) {
            this.promptComponent = this.createPromptComponent();
            this.promptComponent.setUI(new BasicTextFieldUI());
        }
        if (jTextComponent.isFocusOwner() && PromptSupport.getFocusBehavior(jTextComponent) == PromptSupport.FocusBehavior.HIDE_PROMPT) {
            this.promptComponent.setText(null);
        } else {
            this.promptComponent.setText(PromptSupport.getPrompt(jTextComponent));
        }
        this.promptComponent.getHighlighter().removeAllHighlights();
        if (jTextComponent.isFocusOwner() && PromptSupport.getFocusBehavior(jTextComponent) == PromptSupport.FocusBehavior.HIGHLIGHT_PROMPT) {
            this.promptComponent.setForeground(jTextComponent.getSelectedTextColor());
            try {
                this.promptComponent.getHighlighter().addHighlight(0, this.promptComponent.getText().length(), new DefaultHighlighter.DefaultHighlightPainter(jTextComponent.getSelectionColor()));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            this.promptComponent.setForeground(PromptSupport.getForeground(jTextComponent));
        }
        if (PromptSupport.getFontStyle(jTextComponent) == null) {
            this.promptComponent.setFont(jTextComponent.getFont());
        } else {
            this.promptComponent.setFont(jTextComponent.getFont().deriveFont(PromptSupport.getFontStyle(jTextComponent)));
        }
        this.promptComponent.setBackground(PromptSupport.getBackground(jTextComponent));
        this.promptComponent.setEnabled(jTextComponent.isEnabled());
        this.promptComponent.setOpaque(jTextComponent.isOpaque());
        this.promptComponent.setBounds(jTextComponent.getBounds());
        this.promptComponent.setBorder(jTextComponent.getBorder());
        this.promptComponent.setSelectedTextColor(jTextComponent.getSelectedTextColor());
        this.promptComponent.setSelectionColor(jTextComponent.getSelectionColor());
        this.promptComponent.setEditable(jTextComponent.isEditable());
        this.promptComponent.setMargin(jTextComponent.getMargin());
        return this.promptComponent;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (this.shouldPaintPrompt(jTextComponent)) {
            return this.getPromptComponent(jTextComponent).getPreferredSize();
        }
        return this.delegate.getPreferredSize(jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (this.shouldPaintPrompt(jTextComponent)) {
            this.paintPromptComponent(graphics, jTextComponent);
        } else {
            this.delegate.paint(graphics, jComponent);
        }
    }

    protected void paintPromptComponent(Graphics graphics, JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = this.getPromptComponent(jTextComponent);
        jTextComponent2.paint(graphics);
        if (jTextComponent.getCaret() != null) {
            jTextComponent.getCaret().paint(graphics);
        }
    }

    public boolean shouldPaintPrompt(JTextComponent jTextComponent) {
        return jTextComponent.getText() == null || jTextComponent.getText().length() == 0;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        if (this.shouldPaintPrompt(jTextComponent)) {
            return this.getPromptComponent(jTextComponent).getUI().modelToView(jTextComponent, n, bias);
        }
        return this.delegate.modelToView(jTextComponent, n, bias);
    }

    @Override
    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    @Override
    public boolean contains(JComponent jComponent, int n, int n2) {
        return this.delegate.contains(jComponent, n, n2);
    }

    @Override
    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        this.delegate.damageRange(jTextComponent, n, n2, bias, bias2);
    }

    @Override
    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.delegate.damageRange(jTextComponent, n, n2);
    }

    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    @Override
    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        return this.delegate.getAccessibleChild(jComponent, n);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent jComponent) {
        return this.delegate.getAccessibleChildrenCount(jComponent);
    }

    @Override
    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return this.delegate.getEditorKit(jTextComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.delegate.getMaximumSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.delegate.getMinimumSize(jComponent);
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return this.delegate.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
    }

    @Override
    public View getRootView(JTextComponent jTextComponent) {
        return this.delegate.getRootView(jTextComponent);
    }

    @Override
    public String getToolTipText(JTextComponent jTextComponent, Point point) {
        return this.delegate.getToolTipText(jTextComponent, point);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return String.format("%s (%s)", this.getClass().getName(), this.delegate.toString());
    }

    @Override
    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        return this.delegate.viewToModel(jTextComponent, point, biasArray);
    }

    @Override
    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.delegate.viewToModel(jTextComponent, point);
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        try {
            Method method = this.delegate.getClass().getMethod("getBaseline", JComponent.class, Integer.TYPE, Integer.TYPE);
            Object object = method.invoke((Object)this.delegate, jComponent, n, n2);
            return (Integer)object;
        }
        catch (Exception exception) {
            return -2;
        }
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        if (this.delegate instanceof TransitionAwareUI) {
            return ((TransitionAwareUI)((Object)this.delegate)).isInside(mouseEvent);
        }
        return false;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        if (this.delegate instanceof TransitionAwareUI) {
            return ((TransitionAwareUI)((Object)this.delegate)).getTransitionTracker();
        }
        return null;
    }

    private static final class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }
    }
}

