/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.JXSearchField;
import com.frostwire.gui.components.searchfield.NativeSearchFieldSupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RecentSearches
implements ActionListener {
    private Preferences prefsNode;
    private int maxRecents = 5;
    private List<String> recentSearches = new ArrayList<String>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public RecentSearches(String string) {
        this(null, string);
    }

    public RecentSearches(Preferences preferences, String string) {
        if (preferences == null) {
            try {
                preferences = Preferences.userRoot();
            }
            catch (AccessControlException accessControlException) {
                Logger.getLogger(this.getClass().getName()).warning("cannot acces preferences. persistency disabled.");
            }
        }
        if (preferences != null && string != null) {
            this.prefsNode = preferences.node(string);
            this.load();
        }
    }

    private void load() {
        try {
            String[] stringArray = new String[this.prefsNode.keys().length];
            String[] stringArray2 = this.prefsNode.keys();
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string;
                stringArray[this.prefsNode.getInt((String)string, (int)-1)] = string = stringArray2[i];
            }
            this.recentSearches.addAll(Arrays.asList(stringArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        if (this.prefsNode == null) {
            return;
        }
        try {
            this.prefsNode.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int n = 0;
        for (String string : this.recentSearches) {
            this.prefsNode.putInt(string, n++);
        }
    }

    public void put(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        int n = this.recentSearches.indexOf(string);
        if (n != -1) {
            this.recentSearches.remove(n);
        }
        this.recentSearches.add(0, string);
        if (this.getLength() > this.getMaxRecents()) {
            this.recentSearches.remove(this.recentSearches.size() - 1);
        }
        this.save();
        this.fireChangeEvent();
    }

    public String[] getRecentSearches() {
        return this.recentSearches.toArray(new String[0]);
    }

    public int getLength() {
        return this.recentSearches.size();
    }

    public void removeAll() {
        this.recentSearches.clear();
        this.save();
        this.fireChangeEvent();
    }

    public int getMaxRecents() {
        return this.maxRecents;
    }

    public void setMaxRecents(int n) {
        this.maxRecents = n;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.listeners.toArray(new ChangeListener[0]);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    protected JPopupMenu createPopupMenu(JTextField jTextField) {
        return new RecentSearchesPopup(this, jTextField);
    }

    public void install(JTextField jTextField) {
        jTextField.addActionListener(this);
        NativeSearchFieldSupport.setFindPopupMenu(jTextField, this.createPopupMenu(jTextField));
    }

    public void uninstall(JXSearchField jXSearchField) {
        jXSearchField.removeActionListener(this);
        if (jXSearchField.getFindPopupMenu() instanceof RecentSearchesPopup) {
            this.removeChangeListener((ChangeListener)((Object)jXSearchField.getFindPopupMenu()));
            jXSearchField.setFindPopupMenu(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.put(actionEvent.getActionCommand());
    }

    public static class RecentSearchesPopup
    extends JPopupMenu
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = 3389724537449677787L;
        private RecentSearches recentSearches;
        private JTextField searchField;
        private JMenuItem clear;

        public RecentSearchesPopup(RecentSearches recentSearches, JTextField jTextField) {
            this.searchField = jTextField;
            this.recentSearches = recentSearches;
            recentSearches.addChangeListener(this);
            this.buildMenu();
        }

        private void buildMenu() {
            this.setVisible(false);
            this.removeAll();
            if (this.recentSearches.getLength() == 0) {
                JMenuItem jMenuItem = new JMenuItem(UIManager.getString("SearchField.noRecentsText"));
                jMenuItem.setEnabled(false);
                this.add(jMenuItem);
            } else {
                JMenuItem jMenuItem = new JMenuItem(UIManager.getString("SearchField.recentsMenuTitle"));
                jMenuItem.setEnabled(false);
                this.add(jMenuItem);
                for (String string : this.recentSearches.getRecentSearches()) {
                    JMenuItem jMenuItem2 = new JMenuItem(string);
                    jMenuItem2.addActionListener(this);
                    this.add(jMenuItem2);
                }
                this.addSeparator();
                this.clear = new JMenuItem(UIManager.getString("SearchField.clearRecentsText"));
                this.clear.addActionListener(this);
                this.add(this.clear);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.clear) {
                this.recentSearches.removeAll();
            } else {
                this.searchField.setText(actionEvent.getActionCommand());
                this.searchField.postActionEvent();
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.buildMenu();
        }
    }
}

