/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.BuddyLayoutAndBorder;
import com.frostwire.gui.components.searchfield.BuddySupport;
import com.frostwire.gui.components.searchfield.BuddyTextFieldUI;
import com.frostwire.gui.components.searchfield.JXSearchField;
import com.frostwire.gui.components.searchfield.NativeSearchFieldSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Document;

public class SearchFieldUI
extends BuddyTextFieldUI {
    protected JXSearchField searchField;
    private Handler handler;
    public static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

    public SearchFieldUI(TextUI textUI) {
        super(textUI);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.searchField = (JXSearchField)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.layoutButtons();
        this.configureListeners();
    }

    private void configureListeners() {
        if (this.isNativeSearchField()) {
            this.popupButton().removeActionListener(this.getHandler());
            this.searchField.removePropertyChangeListener(this.getHandler());
        } else {
            this.popupButton().addActionListener(this.getHandler());
            this.searchField.addPropertyChangeListener(this.getHandler());
        }
        this.searchField.getDocument().addDocumentListener(this.getHandler());
    }

    private boolean isNativeSearchField() {
        return NativeSearchFieldSupport.isNativeSearchField(this.searchField);
    }

    @Override
    protected BuddyLayoutAndBorder createBuddyLayoutAndBorder() {
        return new BuddyLayoutAndBorder(){
            private static final long serialVersionUID = 2126978772989855919L;

            @Override
            protected void replaceBorderIfNecessary() {
                if (!SearchFieldUI.this.isNativeSearchField()) {
                    super.replaceBorderIfNecessary();
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                if (SearchFieldUI.this.isNativeSearchField()) {
                    return new Dimension();
                }
                return super.preferredLayoutSize(container);
            }

            @Override
            public Insets getBorderInsets(Component component) {
                Insets insets = super.getBorderInsets(component);
                if (SearchFieldUI.this.searchField != null && !SearchFieldUI.this.isNativeSearchField()) {
                    if (SearchFieldUI.this.isMacLayoutStyle()) {
                        if (!SearchFieldUI.this.clearButton().isVisible()) {
                            insets.right += SearchFieldUI.this.clearButton().getPreferredSize().width;
                        }
                    } else {
                        int n;
                        JButton jButton = SearchFieldUI.this.popupButton();
                        if (SearchFieldUI.this.searchField.getFindPopupMenu() == null ^ SearchFieldUI.this.searchField.isUseSeperatePopupButton()) {
                            jButton = SearchFieldUI.this.searchButton();
                        }
                        int n2 = SearchFieldUI.this.clearButton().getPreferredSize().width;
                        int n3 = jButton.getPreferredSize().width;
                        int n4 = n = SearchFieldUI.this.clearButton().isVisible() ? n3 - n2 : n2 - n3;
                        if (n > 0) {
                            insets.right += n;
                        }
                    }
                }
                return insets;
            }
        };
    }

    private void layoutButtons() {
        BuddySupport.removeAll(this.searchField);
        if (this.isNativeSearchField()) {
            return;
        }
        if (this.isMacLayoutStyle()) {
            BuddySupport.addLeft(this.searchButton(), this.searchField);
        } else {
            BuddySupport.addRight(this.searchButton(), this.searchField);
        }
        BuddySupport.addRight(this.clearButton(), this.searchField);
        if (this.usingSeperatePopupButton()) {
            BuddySupport.addRight(BuddySupport.createGap(this.getPopupOffset()), this.searchField);
        }
        if (this.usingSeperatePopupButton() || !this.isMacLayoutStyle()) {
            BuddySupport.addRight(this.popupButton(), this.searchField);
        } else {
            BuddySupport.addLeft(this.popupButton(), this.searchField);
        }
    }

    private boolean isMacLayoutStyle() {
        return this.searchField.getLayoutStyle() == JXSearchField.LayoutStyle.MAC;
    }

    protected void installDefaults() {
        if (this.isNativeSearchField()) {
            return;
        }
        if (UIManager.getBoolean("SearchField.useSeperatePopupButton")) {
            this.searchField.customSetUIProperty("useSeperatePopupButton", Boolean.TRUE);
        } else {
            this.searchField.customSetUIProperty("useSeperatePopupButton", Boolean.FALSE);
        }
        this.searchField.customSetUIProperty("layoutStyle", UIManager.get("SearchField.layoutStyle"));
        this.searchField.customSetUIProperty("promptFontStyle", UIManager.get("SearchField.promptFontStyle"));
        if (this.shouldReplaceResource(this.searchField.getOuterMargin())) {
            this.searchField.setOuterMargin(UIManager.getInsets("SearchField.buttonMargin"));
        }
        this.updateButtons();
        if (this.shouldReplaceResource(this.clearButton().getIcon())) {
            this.clearButton().setIcon(UIManager.getIcon("SearchField.clearIcon"));
        }
        if (this.shouldReplaceResource(this.clearButton().getPressedIcon())) {
            this.clearButton().setPressedIcon(UIManager.getIcon("SearchField.clearPressedIcon"));
        }
        if (this.shouldReplaceResource(this.clearButton().getRolloverIcon())) {
            this.clearButton().setRolloverIcon(UIManager.getIcon("SearchField.clearRolloverIcon"));
        }
        this.searchButton().setIcon(this.getNewIcon(this.searchButton().getIcon(), "SearchField.icon"));
        this.popupButton().setIcon(this.getNewIcon(this.popupButton().getIcon(), "SearchField.popupIcon"));
        this.popupButton().setRolloverIcon(this.getNewIcon(this.popupButton().getRolloverIcon(), "SearchField.popupRolloverIcon"));
        this.popupButton().setPressedIcon(this.getNewIcon(this.popupButton().getPressedIcon(), "SearchField.popupPressedIcon"));
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.searchField.removePropertyChangeListener(this.getHandler());
        this.searchField.getDocument().removeDocumentListener(this.getHandler());
        this.popupButton().removeActionListener(this.getHandler());
        this.searchField.setLayout(null);
        this.searchField.removeAll();
        this.searchField = null;
    }

    protected boolean shouldReplaceResource(Object object) {
        return object == null || object instanceof UIResource;
    }

    protected Icon getNewIcon(Icon icon, String string) {
        Icon icon2 = UIManager.getIcon(string);
        if (this.shouldReplaceResource(icon)) {
            return icon2;
        }
        return icon;
    }

    protected final JButton clearButton() {
        return this.searchField.getCancelButton();
    }

    protected final JButton searchButton() {
        return this.searchField.getFindButton();
    }

    protected final JButton popupButton() {
        return this.searchField.getPopupButton();
    }

    public boolean usingSeperatePopupButton() {
        return this.searchField.isUseSeperatePopupButton() && this.searchField.getFindPopupMenu() != null;
    }

    protected int getPopupOffset() {
        if (this.usingSeperatePopupButton()) {
            return UIManager.getInt("SearchField.popupOffset");
        }
        return 0;
    }

    protected void updateButtons() {
        this.clearButton().setVisible((!this.searchField.isRegularSearchMode() || this.searchField.isMacLayoutStyle()) && this.hasText());
        boolean bl = this.searchField.isMacLayoutStyle() || !this.clearButton().isVisible();
        this.searchButton().setVisible((this.searchField.getFindPopupMenu() == null || this.usingSeperatePopupButton()) && bl);
        this.popupButton().setVisible(this.searchField.getFindPopupMenu() != null && (bl || this.usingSeperatePopupButton()));
        if (this.searchField.isRegularSearchMode()) {
            this.searchButton().setRolloverIcon(this.getNewIcon(this.searchButton().getRolloverIcon(), "SearchField.rolloverIcon"));
            this.searchButton().setPressedIcon(this.getNewIcon(this.searchButton().getPressedIcon(), "SearchField.pressedIcon"));
        } else {
            if (this.shouldReplaceResource(this.searchButton().getRolloverIcon())) {
                this.searchButton().setRolloverIcon(null);
            }
            if (this.shouldReplaceResource(this.searchButton().getPressedIcon())) {
                this.searchButton().setPressedIcon(null);
            }
        }
    }

    private boolean hasText() {
        return this.searchField.getText() != null && this.searchField.getText().length() > 0;
    }

    class Handler
    implements PropertyChangeListener,
    ActionListener,
    DocumentListener {
        Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (object.equals(SearchFieldUI.this.searchField)) {
                if ("findPopupMenu".equals(string) || "searchMode".equals(string) || "useSeperatePopupButton".equals(string) || "searchMode".equals(string) || "layoutStyle".equals(string)) {
                    SearchFieldUI.this.layoutButtons();
                    SearchFieldUI.this.updateButtons();
                } else if ("document".equals(string)) {
                    Document document = (Document)propertyChangeEvent.getOldValue();
                    if (document != null) {
                        document.removeDocumentListener(this);
                    }
                    if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                        document.addDocumentListener(this);
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchFieldUI.this.searchField.getFindPopupMenu() != null) {
                Component component = "searchField".equals(UIManager.getString("SearchField.popupSource")) ? SearchFieldUI.this.searchField : (Component)actionEvent.getSource();
                Rectangle rectangle = SwingUtilities.getLocalBounds(component);
                int n = SearchFieldUI.this.searchField.getFindPopupMenu().getPreferredSize().width;
                int n2 = SearchFieldUI.this.searchField.isVistaLayoutStyle() || SearchFieldUI.this.usingSeperatePopupButton() ? rectangle.x + rectangle.width - n : rectangle.x;
                SearchFieldUI.this.searchField.getFindPopupMenu().show(component, n2, rectangle.y + rectangle.height);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            if (SearchFieldUI.this.searchField.isInstantSearchMode()) {
                SearchFieldUI.this.searchField.getInstantSearchTimer().stop();
                if (SearchFieldUI.this.searchField.getInstantSearchDelay() > 0) {
                    SearchFieldUI.this.searchField.getInstantSearchTimer().setInitialDelay(SearchFieldUI.this.searchField.getInstantSearchDelay());
                    SearchFieldUI.this.searchField.getInstantSearchTimer().start();
                } else {
                    SearchFieldUI.this.searchField.postActionEvent();
                }
            }
            SearchFieldUI.this.updateButtons();
        }
    }
}

