/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.searchfield;

import com.frostwire.gui.components.searchfield.AbstractUIChangeHandler;
import com.frostwire.gui.components.searchfield.BuddySupport;
import com.frostwire.gui.components.searchfield.BuddyTextFieldUI;
import com.frostwire.gui.components.searchfield.JXSearchField;
import com.frostwire.gui.components.searchfield.PromptTextUI;
import com.frostwire.gui.components.searchfield.SearchFieldUI;
import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public abstract class TextUIWrapper<UI extends TextUI> {
    private static final DefaultWrapper defaultWrapper = new DefaultWrapper();
    private Class<UI> wrapperClass;
    private final TextUIChangeHandler uiChangeHandler = new TextUIChangeHandler();

    public static final TextUIWrapper<? extends PromptTextUI> getDefaultWrapper() {
        return defaultWrapper;
    }

    protected TextUIWrapper(Class<UI> clazz) {
        this.wrapperClass = clazz;
    }

    public final void install(JTextComponent jTextComponent, boolean bl) {
        this.replaceUIIfNeeded(jTextComponent);
        if (bl) {
            this.uiChangeHandler.install(jTextComponent);
        }
    }

    protected boolean replaceUIIfNeeded(JTextComponent jTextComponent) {
        if (this.wrapperClass.isAssignableFrom(jTextComponent.getUI().getClass())) {
            return false;
        }
        jTextComponent.setUI((TextUI)this.wrapUI(jTextComponent));
        return true;
    }

    public abstract UI wrapUI(JTextComponent var1);

    public Class<UI> getWrapperClass() {
        return this.wrapperClass;
    }

    public final void uninstall(JTextComponent jTextComponent) {
        this.uiChangeHandler.uninstall(jTextComponent);
        jTextComponent.updateUI();
    }

    public static final class DefaultWrapper
    extends TextUIWrapper<PromptTextUI> {
        private DefaultWrapper() {
            super(PromptTextUI.class);
        }

        @Override
        public PromptTextUI wrapUI(JTextComponent jTextComponent) {
            TextUI textUI = jTextComponent.getUI();
            if (textUI instanceof PromptTextUI) {
                return (PromptTextUI)textUI;
            }
            if (textUI instanceof BasicTextFieldUI) {
                if (jTextComponent instanceof JXSearchField) {
                    return new SearchFieldUI(textUI);
                }
                return new BuddyTextFieldUI(textUI);
            }
            if (textUI instanceof BasicTextAreaUI) {
                // empty if block
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected boolean replaceUIIfNeeded(JTextComponent jTextComponent) {
            boolean bl = super.replaceUIIfNeeded(jTextComponent);
            if (bl && jTextComponent instanceof JTextField) {
                BuddySupport.ensureBuddiesAreInComponentHierarchy((JTextField)jTextComponent);
            }
            return bl;
        }
    }

    private final class TextUIChangeHandler
    extends AbstractUIChangeHandler {
        private TextUIChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
            TextUIWrapper.this.replaceUIIfNeeded(jTextComponent);
        }
    }
}

